/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import org.opends.server.backends.jeb.Container;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

public class DN2ID {
    private Container container;
    private DatabaseConfig dbConfig;
    private String name;
    private ThreadLocal<Database> threadLocalDatabase = new ThreadLocal();

    public DN2ID(Container container, DatabaseConfig databaseConfig, String string) {
        this.container = container;
        this.dbConfig = databaseConfig;
        this.name = string;
    }

    public void open() throws DatabaseException {
        this.getDatabase();
    }

    private Database getDatabase() throws DatabaseException {
        Database database = this.threadLocalDatabase.get();
        if (database == null) {
            database = this.container.openDatabase(this.dbConfig, this.name);
            this.threadLocalDatabase.set(database);
        }
        return database;
    }

    private static DatabaseEntry DNdata(DN dN) {
        byte[] byArray = StaticUtils.getBytes(dN.toNormalizedString());
        return new DatabaseEntry(byArray);
    }

    public boolean insert(Transaction transaction, DN dN, EntryID entryID) throws DatabaseException {
        DatabaseEntry databaseEntry = DN2ID.DNdata(dN);
        DatabaseEntry databaseEntry2 = entryID.getDatabaseEntry();
        OperationStatus operationStatus = Container.insert(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public boolean put(Transaction transaction, DN dN, EntryID entryID) throws DatabaseException {
        DatabaseEntry databaseEntry = DN2ID.DNdata(dN);
        DatabaseEntry databaseEntry2 = entryID.getDatabaseEntry();
        OperationStatus operationStatus = Container.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public boolean putRaw(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = Container.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public boolean remove(Transaction transaction, DN dN) throws DatabaseException {
        DatabaseEntry databaseEntry = DN2ID.DNdata(dN);
        OperationStatus operationStatus = Container.delete(this.getDatabase(), transaction, databaseEntry);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public EntryID get(Transaction transaction, DN dN) throws DatabaseException {
        DatabaseEntry databaseEntry = DN2ID.DNdata(dN);
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = Container.read(this.getDatabase(), transaction, databaseEntry, databaseEntry2, LockMode.DEFAULT);
        if (operationStatus != OperationStatus.SUCCESS) {
            return null;
        }
        return new EntryID(databaseEntry2);
    }

    public Cursor openCursor(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        return this.getDatabase().openCursor(transaction, cursorConfig);
    }

    public long computeRecordCount() throws DatabaseException {
        BtreeStats btreeStats = (BtreeStats)this.getDatabase().getStats(new StatsConfig());
        return btreeStats.getLeafNodeCount();
    }
}

