/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.File;
import java.io.FilenameFilter;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;

public class EnvManager {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.EnvManager";
    private static final FilenameFilter jeAllFilesFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.endsWith(".jdb") || string.endsWith(".del") || string.equals("je.lck");
        }
    };

    public static void createHomeDir(String string) throws JebException {
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                String string2 = MessageHandler.getMessage(8650761, string);
                throw new JebException(8650761, string2);
            }
            EnvManager.removeFiles(string);
        } else {
            try {
                file.mkdir();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackendDirectory", exception));
                String string3 = MessageHandler.getMessage(8650759, exception.getMessage());
                throw new JebException(8650759, string3, exception);
            }
        }
    }

    public static void removeFiles(String string) throws JebException {
        File file = new File(string);
        if (!file.isDirectory()) {
            String string2 = MessageHandler.getMessage(8650761, string);
            throw new JebException(8650761, string2);
        }
        try {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(jeAllFilesFilter)) {
                file2.delete();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "removeFiles", exception));
            String string3 = MessageHandler.getMessage(0x840008, exception.getMessage());
            throw new JebException(0x840008, string3, exception);
        }
    }
}

