/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class RecurringTask {
    private static final String CLASS_NAME = "org.opends.server.backends.task.RecurringTask";
    private Entry recurringTaskEntry;
    private String recurringTaskID;
    private String taskClassName;
    private TaskScheduler taskScheduler;

    public RecurringTask(TaskScheduler taskScheduler, Entry entry) throws DirectoryException {
        Task task;
        Class<?> clazz;
        List<Attribute> list;
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(taskScheduler), String.valueOf(entry)));
        this.taskScheduler = taskScheduler;
        this.recurringTaskEntry = entry;
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-recurring-task-id".toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-id");
        }
        if ((list = entry.getAttribute(attributeType)) == null || list.isEmpty()) {
            int n = 9699428;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        if (list.size() > 1) {
            int n = 9699429;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        Attribute attribute = list.get(0);
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            int n = 9699430;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        Iterator iterator = linkedHashSet.iterator();
        AttributeValue attributeValue = (AttributeValue)iterator.next();
        if (iterator.hasNext()) {
            int n = 9699431;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-id");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, string, n);
        }
        this.recurringTaskID = attributeValue.getStringValue();
        attributeType = DirectoryServer.getAttributeType("ds-recurring-task-class-name".toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-class-name");
        }
        if ((list = entry.getAttribute(attributeType)) == null || list.isEmpty()) {
            int n = 9699432;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        if (list.size() > 0) {
            int n = 9699433;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        attribute = list.get(0);
        linkedHashSet = attribute.getValues();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            int n = 9699434;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        iterator = linkedHashSet.iterator();
        attributeValue = (AttributeValue)iterator.next();
        if (iterator.hasNext()) {
            int n = 9699435;
            String string = MessageHandler.getMessage(n, "ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        this.taskClassName = attributeValue.getStringValue();
        try {
            clazz = Class.forName(this.taskClassName);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            int n = 9699436;
            String string = MessageHandler.getMessage(n, String.valueOf(this.taskClassName), "ds-recurring-task-class-name", StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n, exception);
        }
        try {
            task = (Task)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            int n = 9699437;
            String string = MessageHandler.getMessage(n, String.valueOf(this.taskClassName), Task.class.getName());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n, exception);
        }
        try {
            task.initializeTaskInternal(taskScheduler, entry);
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "<init>", initializationException));
            int n = 9699438;
            String string = MessageHandler.getMessage(n, String.valueOf(this.taskClassName), initializationException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, initializationException);
        }
        task.initializeTask();
    }

    public String getRecurringTaskID() {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTaskID", new String[0]));
        return this.recurringTaskID;
    }

    public Entry getRecurringTaskEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTaskEntry", new String[0]));
        return this.recurringTaskEntry;
    }

    public String getTaskClassName() {
        assert (Debug.debugEnter(CLASS_NAME, "getTaskClassName", new String[0]));
        return this.taskClassName;
    }

    public Task scheduleNextIteration() {
        assert (Debug.debugEnter(CLASS_NAME, "scheduleNextIteration", new String[0]));
        return null;
    }
}

