/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class TaskThread
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.backends.task.TaskThread";
    private boolean exitRequested;
    private int threadID;
    private Task task;
    private TaskScheduler taskScheduler;
    private Object notifyLock;

    public TaskThread(TaskScheduler taskScheduler, int n) {
        super("Task Thread " + n);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(taskScheduler), String.valueOf(n)));
        this.taskScheduler = taskScheduler;
        this.threadID = n;
        this.task = null;
        this.notifyLock = new Object();
        this.exitRequested = false;
    }

    public Task getTask() {
        assert (Debug.debugEnter(CLASS_NAME, "getTask", new String[0]));
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTask(Task task) {
        assert (Debug.debugEnter(CLASS_NAME, "setTask", String.valueOf(task)));
        this.task = task;
        Object object = this.notifyLock;
        synchronized (object) {
            this.notifyLock.notify();
        }
    }

    public void interruptTask(TaskState taskState, String string, boolean bl) {
        block5: {
            assert (Debug.debugEnter(CLASS_NAME, "interruptTask", String.valueOf(bl)));
            if (this.task != null) {
                try {
                    this.task.interruptTask(taskState, string);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "interruptTask", exception)) break block5;
                    throw new AssertionError();
                }
            }
        }
        if (bl) {
            this.exitRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        while (!this.exitRequested) {
            Object object;
            if (this.task == null) {
                try {
                    object = this.notifyLock;
                    synchronized (object) {
                        this.notifyLock.wait(5000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    assert (Debug.debugException(CLASS_NAME, "run", interruptedException));
                    continue;
                }
            }
            try {
                object = this.task.execute();
                this.task.setTaskState((TaskState)((Object)object));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "run", exception));
                int n = 9699427;
                String string = MessageHandler.getMessage(n, String.valueOf(this.task.getTaskEntry().getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                this.task.addLogMessage(ErrorLogSeverity.FATAL_ERROR, n, string);
                this.task.setTaskState(TaskState.STOPPED_BY_ERROR);
            }
            object = this.task;
            this.task = null;
            if (this.taskScheduler.threadDone(this, (Task)object)) continue;
            this.exitRequested = true;
            break;
        }
        if (this.task != null) {
            this.task.setTaskState(TaskState.STOPPED_BY_SHUTDOWN);
            this.taskScheduler.threadDone(this, this.task);
        }
    }
}

