/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.opends.server.changelog.Changelog;
import org.opends.server.changelog.ChangelogDBException;
import org.opends.server.changelog.ChangelogData;
import org.opends.server.changelog.ChangelogKey;
import org.opends.server.core.DirectoryException;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelogDB {
    private static Environment dbEnvironment = null;
    private Database db;
    private static Database stateDb = null;
    private String stringId;

    public ChangelogDB(Short s, DN dN) throws DatabaseException {
        block4: {
            this.db = null;
            this.stringId = null;
            try {
                this.stringId = s.toString() + " " + dN.toNormalizedString();
                byte[] byArray = this.stringId.getBytes("UTF-8");
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(true);
                databaseConfig.setTransactional(true);
                this.db = dbEnvironment.openDatabase(null, this.stringId, databaseConfig);
                DatabaseEntry databaseEntry = new DatabaseEntry();
                databaseEntry.setData(byArray);
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                OperationStatus operationStatus = stateDb.get(null, databaseEntry, databaseEntry2, LockMode.DEFAULT);
                if (operationStatus != OperationStatus.NOTFOUND) break block4;
                Transaction transaction = dbEnvironment.beginTransaction(null, null);
                try {
                    databaseEntry2.setData(byArray);
                    stateDb.put(transaction, databaseEntry, databaseEntry2);
                    transaction.commitWriteNoSync();
                }
                catch (DatabaseException databaseException) {
                    transaction.abort();
                    throw databaseException;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public static void initialize(String string) throws DatabaseException, ChangelogDBException {
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        environmentConfig.setAllowCreate(true);
        environmentConfig.setTransactional(true);
        environmentConfig.setConfigParam("je.cleaner.expunge", "true");
        environmentConfig.setConfigParam("je.maxMemory", "5000000");
        dbEnvironment = new Environment(new File(string), environmentConfig);
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        databaseConfig.setTransactional(true);
        stateDb = dbEnvironment.openDatabase(null, "changelogstate", databaseConfig);
        Cursor cursor = stateDb.openCursor(null, null);
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        try {
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                try {
                    String string2 = new String(databaseEntry2.getData(), "UTF-8");
                    String[] stringArray = string2.split(" ", 2);
                    short s = new Short(stringArray[0]);
                    DN dN = null;
                    try {
                        dN = DN.decode(stringArray[1]);
                    }
                    catch (DirectoryException directoryException) {
                        int n = 17039387;
                        String string3 = MessageHandler.getMessage(n, stringArray[1]);
                        Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string3, n);
                    }
                    Changelog.getChangelogCache(dN).newDb(s, dN);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ChangelogDBException(0, "changelog state database has a wrong format");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ChangelogDBException(0, "need UTF-8 support");
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
            cursor.close();
        }
        catch (DatabaseException databaseException) {
            cursor.close();
            throw databaseException;
        }
    }

    public void addEntries(List<UpdateMessage> list) {
        block7: {
            Transaction transaction = null;
            try {
                transaction = dbEnvironment.beginTransaction(null, null);
                for (UpdateMessage updateMessage : list) {
                    ChangelogKey changelogKey = new ChangelogKey(updateMessage.getChangeNumber());
                    ChangelogData changelogData = new ChangelogData(updateMessage);
                    try {
                        this.db.put(transaction, (DatabaseEntry)changelogKey, (DatabaseEntry)changelogData);
                    }
                    catch (DatabaseException databaseException) {
                        int n = 17104922;
                        String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                        Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                        Changelog.shutdown();
                    }
                }
                transaction.commitWriteNoSync();
                transaction = null;
            }
            catch (DatabaseException databaseException) {
                int n = 17104922;
                String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                Changelog.shutdown();
                if (transaction == null) break block7;
                try {
                    transaction.abort();
                }
                catch (DatabaseException databaseException2) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdown() {
        try {
            this.db.close();
        }
        catch (DatabaseException databaseException) {
            int n = 17235992;
            String string = MessageHandler.getMessage(n, this.stringId) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
        }
    }

    public ChangelogCursor openReadCursor(ChangeNumber changeNumber) throws DatabaseException, Exception {
        if (changeNumber == null) {
            changeNumber = this.readFirstChange();
        }
        if (changeNumber == null) {
            return null;
        }
        return new ChangelogCursor(changeNumber);
    }

    public ChangelogCursor openDeleteCursor() throws DatabaseException, Exception {
        return new ChangelogCursor();
    }

    public ChangeNumber readFirstChange() {
        Cursor cursor;
        String string = null;
        try {
            cursor = this.db.openCursor(null, null);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            cursor.close();
            if (operationStatus != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                string = new String(databaseEntry.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return new ChangeNumber(string);
        }
        catch (DatabaseException databaseException) {
            try {
                cursor.close();
            }
            catch (DatabaseException databaseException2) {
                // empty catch block
            }
            int n = 17104922;
            String string2 = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            Changelog.shutdown();
            return null;
        }
    }

    public ChangeNumber readLastChange() {
        String string = null;
        try {
            Cursor cursor = this.db.openCursor(null, null);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getLast(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            cursor.close();
            if (operationStatus != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                string = new String(databaseEntry.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return new ChangeNumber(string);
        }
        catch (DatabaseException databaseException) {
            int n = 17104922;
            String string2 = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            Changelog.shutdown();
            return null;
        }
    }

    public static void shutdownDbEnvironment() {
        try {
            stateDb.close();
            dbEnvironment.close();
        }
        catch (DatabaseException databaseException) {
            int n = 17039388;
            String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
    }

    public class ChangelogCursor {
        private Cursor cursor = null;
        private Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();

        private ChangelogCursor(ChangeNumber changeNumber) throws Exception {
            this.cursor = ChangelogDB.this.db.openCursor(this.txn, null);
            ChangelogKey changelogKey = new ChangelogKey(changeNumber);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            if (this.cursor.getSearchKey((DatabaseEntry)changelogKey, databaseEntry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                throw new Exception("ChangeNumber not available");
            }
        }

        private ChangelogCursor() throws DatabaseException {
            this.txn = dbEnvironment.beginTransaction(null, null);
            this.cursor = ChangelogDB.this.db.openCursor(this.txn, null);
        }

        public void close() {
            String string;
            int n;
            if (this.cursor == null) {
                return;
            }
            try {
                this.cursor.close();
                this.cursor = null;
            }
            catch (DatabaseException databaseException) {
                n = 17104922;
                string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                Changelog.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException databaseException) {
                    n = 17104922;
                    string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
                    Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    Changelog.shutdown();
                }
            }
        }

        public ChangeNumber nextChangeNumber() throws DatabaseException {
            OperationStatus operationStatus = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
            if (operationStatus != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                String string = new String(this.key.getData(), "UTF-8");
                return new ChangeNumber(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }

        public UpdateMessage next() {
            UpdateMessage updateMessage = null;
            while (updateMessage == null) {
                try {
                    OperationStatus operationStatus = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
                    if (operationStatus != OperationStatus.SUCCESS) {
                        return null;
                    }
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
                try {
                    updateMessage = ChangelogData.generateChange(this.data.getData());
                }
                catch (Exception exception) {}
            }
            return updateMessage;
        }

        public void delete() throws DatabaseException {
            this.cursor.delete();
        }
    }
}

