/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.changelog.ChangelogCache;
import org.opends.server.changelog.ProtocolSession;
import org.opends.server.changelog.ServerHandler;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.synchronization.AckMessage;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class ServerReader
extends DirectoryThread {
    private short serverId;
    private ProtocolSession session;
    private ServerHandler handler;
    private ChangelogCache changelogCache;

    public ServerReader(ProtocolSession protocolSession, short s, ServerHandler serverHandler, ChangelogCache changelogCache) {
        super(serverHandler.toString() + " reader");
        this.session = protocolSession;
        this.serverId = s;
        this.handler = serverHandler;
        this.changelogCache = changelogCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                SynchronizationMessage synchronizationMessage;
                SynchronizationMessage synchronizationMessage2;
                if ((synchronizationMessage2 = this.session.receive()) == null) {
                    return;
                }
                if (synchronizationMessage2 instanceof AckMessage) {
                    synchronizationMessage = (AckMessage)synchronizationMessage2;
                    this.changelogCache.ack((AckMessage)synchronizationMessage, this.serverId);
                    continue;
                }
                if (!(synchronizationMessage2 instanceof UpdateMessage)) continue;
                synchronizationMessage = (UpdateMessage)synchronizationMessage2;
                this.changelogCache.put((UpdateMessage)synchronizationMessage, this.handler);
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            int n = 0x1070010;
            String string = MessageHandler.getMessage(n, this.handler.toString());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n = 17039391;
            String string = MessageHandler.getMessage(n, this.handler.toString());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.NOTICE, string, n);
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            try {
                this.session.close();
            }
            catch (IOException iOException) {}
            this.changelogCache.stopServer(this.handler);
        }
    }
}

