/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanConfigAttribute
extends ConfigAttribute {
    private static final String CLASS_NAME = "org.opends.server.config.BooleanConfigAttribute";
    private boolean activeValue;
    private boolean pendingValue;

    public BooleanConfigAttribute(String string, String string2, boolean bl) {
        super(string, string2, true, false, bl);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl)));
    }

    public BooleanConfigAttribute(String string, String string2, boolean bl, boolean bl2) {
        super(string, string2, true, false, bl, BooleanConfigAttribute.getValueSet(bl2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(bl2)));
        this.activeValue = bl2;
        this.pendingValue = bl2;
    }

    public BooleanConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        super(string, string2, true, false, bl, BooleanConfigAttribute.getValueSet(bl2), true, BooleanConfigAttribute.getValueSet(bl3));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(bl2), String.valueOf(bl3)));
        this.activeValue = bl2;
        this.pendingValue = bl3;
    }

    @Override
    public String getDataType() {
        assert (Debug.debugEnter(CLASS_NAME, "getDataType", new String[0]));
        return "Boolean";
    }

    @Override
    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return DirectoryServer.getDefaultBooleanSyntax();
    }

    public boolean activeValue() {
        assert (Debug.debugEnter(CLASS_NAME, "booleanValue", new String[0]));
        return this.activeValue;
    }

    public boolean pendingValue() {
        assert (Debug.debugEnter(CLASS_NAME, "booleanValue", new String[0]));
        if (this.hasPendingValues()) {
            return this.pendingValue;
        }
        return this.activeValue;
    }

    public void setValue(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(bl)));
        if (this.requiresAdminAction()) {
            this.pendingValue = bl;
            this.setPendingValues(BooleanConfigAttribute.getValueSet(bl));
        } else {
            this.activeValue = bl;
            this.setActiveValues(BooleanConfigAttribute.getValueSet(bl));
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(bl)));
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        if (bl) {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString("true"), (ByteString)new ASN1OctetString("true")));
        } else {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString("false"), (ByteString)new ASN1OctetString("false")));
        }
        return linkedHashSet;
    }

    @Override
    public void applyPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "applyPendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValue = this.pendingValue;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue attributeValue, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(attributeValue), "java.lang.StringBuilder"));
        String string = attributeValue.getStringValue();
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
            return true;
        }
        stringBuilder.append(MessageHandler.getMessage(0x330007, this.getName(), string));
        return false;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> list, boolean bl) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "stringsToValues", String.valueOf(list), String.valueOf(bl)));
        if (list == null || list.isEmpty()) {
            int n = 0x330001;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        Iterator<String> iterator = list.iterator();
        String string = iterator.next().toLowerCase();
        if (iterator.hasNext()) {
            int n = 0x330001;
            String string2 = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string2);
        }
        if (string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1")) {
            return BooleanConfigAttribute.getValueSet(true);
        }
        if (string.equals("false") || string.equals("no") || string.equals("off") || string.equals("0")) {
            return BooleanConfigAttribute.getValueSet(false);
        }
        int n = 0x330007;
        String string3 = MessageHandler.getMessage(n, string);
        throw new ConfigException(n, string3);
    }

    @Override
    public List<String> activeValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValuesToStrings", new String[0]));
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(String.valueOf(this.activeValue));
        return arrayList;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValuesToStrings", new String[0]));
        if (this.hasPendingValues()) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(String.valueOf(this.pendingValue));
            return arrayList;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(list)));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (Attribute object : list) {
            String string;
            LinkedHashSet<AttributeValue> n;
            Iterator n2;
            if (object.hasOptions()) {
                if (object.hasOption("pending")) {
                    if (bl4) {
                        int n3 = 0x330040;
                        n2 = MessageHandler.getMessage(n3, object.getName());
                        throw new ConfigException(n3, (String)((Object)n2));
                    }
                    n = object.getValues();
                    if (n.isEmpty()) {
                        int n4 = 0x330001;
                        string = MessageHandler.getMessage(n4, object.getName());
                        throw new ConfigException(n4, string);
                    }
                    n2 = n.iterator();
                    string = ((AttributeValue)n2.next()).getStringValue().toLowerCase();
                    if (string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1")) {
                        bl2 = true;
                        bl4 = true;
                    } else if (string.equals("false") || string.equals("no") || string.equals("off") || string.equals("0")) {
                        bl2 = false;
                        bl4 = true;
                    } else {
                        int n5 = 0x330007;
                        String string3 = MessageHandler.getMessage(n5, string);
                        throw new ConfigException(n5, string3);
                    }
                    if (!n2.hasNext()) continue;
                    int n6 = 0x330003;
                    String string4 = MessageHandler.getMessage(n6, object.getName());
                    throw new ConfigException(n6, string4);
                }
                int n7 = 3342366;
                n2 = MessageHandler.getMessage(n7, object.getName());
                throw new ConfigException(n7, (String)((Object)n2));
            }
            if (bl3) {
                int n8 = 3342401;
                n2 = MessageHandler.getMessage(n8, object.getName());
                throw new ConfigException(n8, (String)((Object)n2));
            }
            n = object.getValues();
            if (n.isEmpty()) {
                int n9 = 0x330001;
                string = MessageHandler.getMessage(n9, object.getName());
                throw new ConfigException(n9, string);
            }
            n2 = n.iterator();
            string = ((AttributeValue)n2.next()).getStringValue().toLowerCase();
            if (string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1")) {
                bl = true;
                bl3 = true;
            } else if (string.equals("false") || string.equals("no") || string.equals("off") || string.equals("0")) {
                bl = false;
                bl3 = true;
            } else {
                int n10 = 0x330007;
                String string5 = MessageHandler.getMessage(n10, string);
                throw new ConfigException(n10, string5);
            }
            if (!n2.hasNext()) continue;
            int n11 = 0x330003;
            String string2 = MessageHandler.getMessage(n11, object.getName());
            throw new ConfigException(n11, string2);
        }
        if (!bl3) {
            int n = 3342402;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (bl4) {
            return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), bl, bl2);
        }
        return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), bl);
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", new String[0]));
        return new javax.management.Attribute(this.getName(), this.activeValue);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return new javax.management.Attribute(this.getName() + ";" + "pending", this.pendingValue);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", String.valueOf(attributeList)));
        attributeList.add(new javax.management.Attribute(this.getName(), this.activeValue));
        if (this.requiresAdminAction() && this.pendingValue != this.activeValue) {
            String string = this.getName() + ";" + "pending";
            attributeList.add(new javax.management.Attribute(string, this.pendingValue));
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> list) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributeInfo", String.valueOf(list)));
        list.add(new MBeanAttributeInfo(this.getName(), Boolean.class.getName(), this.getDescription(), true, true, false));
        if (this.requiresAdminAction()) {
            String string = this.getName() + ";" + "pending";
            list.add(new MBeanAttributeInfo(string, Boolean.class.getName(), this.getDescription(), true, false, false));
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXParameterInfo", new String[0]));
        return new MBeanParameterInfo(this.getName(), Boolean.TYPE.getName(), this.getDescription());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setValue(javax.management.Attribute attribute) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(attribute)));
        Object object = attribute.getValue();
        if (object instanceof Boolean) {
            this.setValue((Boolean)object);
            return;
        }
        if (!(object instanceof String)) {
            int n = 0x330007;
            String string = MessageHandler.getMessage(n, object.getClass().getName() + ":" + String.valueOf(object));
            throw new ConfigException(n, string);
        }
        String string = ((String)object).toLowerCase();
        if (string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1")) {
            this.setValue(true);
            return;
        }
        if (!(string.equals("false") || string.equals("no") || string.equals("off") || string.equals("0"))) {
            int n = 0x330007;
            String string2 = MessageHandler.getMessage(n, string);
            throw new ConfigException(n, string2);
        }
        this.setValue(false);
    }

    @Override
    public ConfigAttribute duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), this.activeValue, this.pendingValue);
    }
}

