/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerWithUnitConfigAttribute
extends ConfigAttribute {
    private static final String CLASS_NAME = "org.opends.server.config.IntegerWithUnitConfigAttribute";
    private boolean hasLowerBound;
    private boolean hasUpperBound;
    private HashMap<String, Double> units;
    private long activeCalculatedValue;
    private long activeIntValue;
    private long lowerBound;
    private long pendingCalculatedValue;
    private long pendingIntValue;
    private long upperBound;
    private String activeUnit;
    private String pendingUnit;

    public IntegerWithUnitConfigAttribute(String string, String string2, boolean bl, HashMap<String, Double> hashMap, boolean bl2, long l, boolean bl3, long l2) {
        super(string, string2, true, false, bl);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(hashMap), String.valueOf(bl2), String.valueOf(l), String.valueOf(bl3), String.valueOf(l2)));
        this.units = hashMap;
        this.hasLowerBound = bl2;
        this.lowerBound = l;
        this.hasUpperBound = bl3;
        this.upperBound = l2;
    }

    public IntegerWithUnitConfigAttribute(String string, String string2, boolean bl, HashMap<String, Double> hashMap, boolean bl2, long l, boolean bl3, long l2, long l3, String string3) {
        super(string, string2, true, false, bl, IntegerWithUnitConfigAttribute.getValueSet(l3, string3));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(hashMap), String.valueOf(bl2), String.valueOf(l), String.valueOf(bl3), String.valueOf(l2), String.valueOf(l3), String.valueOf(string3)));
        this.units = hashMap;
        this.hasLowerBound = bl2;
        this.lowerBound = l;
        this.hasUpperBound = bl3;
        this.upperBound = l2;
        this.activeIntValue = l3;
        this.activeUnit = string3;
        this.pendingIntValue = this.activeIntValue;
        this.pendingUnit = this.activeUnit;
        if (hashMap.containsKey(string3)) {
            this.activeCalculatedValue = (long)((double)this.activeIntValue * hashMap.get(string3));
        }
        this.pendingCalculatedValue = this.activeCalculatedValue;
    }

    public IntegerWithUnitConfigAttribute(String string, String string2, boolean bl, HashMap<String, Double> hashMap, boolean bl2, long l, boolean bl3, long l2, long l3, String string3, long l4, String string4) {
        super(string, string2, true, false, bl, IntegerWithUnitConfigAttribute.getValueSet(l3, string3), string4 != null, IntegerWithUnitConfigAttribute.getValueSet(l4, string4));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(bl), String.valueOf(hashMap), String.valueOf(bl2), String.valueOf(l), String.valueOf(bl3), String.valueOf(l2), String.valueOf(l3), String.valueOf(string3), String.valueOf(l4), String.valueOf(string4)));
        this.units = hashMap;
        this.hasLowerBound = bl2;
        this.lowerBound = l;
        this.hasUpperBound = bl3;
        this.upperBound = l2;
        this.activeIntValue = l3;
        this.activeUnit = string3;
        if (string4 == null) {
            this.pendingIntValue = l3;
            this.pendingUnit = this.activeUnit;
        } else {
            this.pendingIntValue = l4;
            this.pendingUnit = string4;
        }
        if (hashMap.containsKey(this.activeUnit)) {
            this.activeCalculatedValue = (long)((double)l3 * hashMap.get(this.activeUnit));
        }
        if (hashMap.containsKey(this.pendingUnit)) {
            this.pendingCalculatedValue = (long)((double)l4 * hashMap.get(this.pendingUnit));
        }
    }

    @Override
    public String getDataType() {
        assert (Debug.debugEnter(CLASS_NAME, "getDataType", new String[0]));
        return "IntegerWithUnit";
    }

    @Override
    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return DirectoryServer.getDefaultStringSyntax();
    }

    public long activeIntValue() {
        assert (Debug.debugEnter(CLASS_NAME, "activeIntValue", new String[0]));
        return this.activeIntValue;
    }

    public String activeUnit() {
        assert (Debug.debugEnter(CLASS_NAME, "activeUnit", new String[0]));
        return this.activeUnit;
    }

    public long activeCalculatedValue() {
        assert (Debug.debugEnter(CLASS_NAME, "activeCalculatedValue", new String[0]));
        return this.activeCalculatedValue;
    }

    public long pendingIntValue() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingIntValue", new String[0]));
        if (this.hasPendingValues()) {
            return this.pendingIntValue;
        }
        return this.activeIntValue;
    }

    public String pendingUnit() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingUnit", new String[0]));
        if (this.hasPendingValues()) {
            return this.pendingUnit;
        }
        return this.activeUnit;
    }

    public long pendingCalculatedValue() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingCalculatedValue", new String[0]));
        if (this.hasPendingValues()) {
            return this.pendingCalculatedValue;
        }
        return this.activeCalculatedValue;
    }

    public HashMap<String, Double> getUnits() {
        assert (Debug.debugEnter(CLASS_NAME, "getUnits", new String[0]));
        return this.units;
    }

    public boolean hasLowerBound() {
        assert (Debug.debugEnter(CLASS_NAME, "hasLowerBound", new String[0]));
        return this.hasLowerBound;
    }

    public long getLowerBound() {
        assert (Debug.debugEnter(CLASS_NAME, "getLowerBound", new String[0]));
        return this.lowerBound;
    }

    public boolean hasUpperBound() {
        assert (Debug.debugEnter(CLASS_NAME, "hasUpperBound", new String[0]));
        return this.hasUpperBound;
    }

    public long getUpperBound() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpperBound", new String[0]));
        return this.upperBound;
    }

    public void setValue(long l, String string) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(l), String.valueOf(string)));
        if (string == null || !this.units.containsKey(string)) {
            int n = 0x330013;
            String string2 = MessageHandler.getMessage(n, string, this.getName());
            throw new ConfigException(n, string2);
        }
        long l2 = (long)((double)l * this.units.get(string));
        if (this.hasLowerBound && l2 < this.lowerBound) {
            int n = 0x33000C;
            String string3 = MessageHandler.getMessage(n, this.getName(), l2, this.lowerBound);
            throw new ConfigException(n, string3);
        }
        if (this.hasUpperBound && l2 > this.upperBound) {
            int n = 0x33000D;
            String string4 = MessageHandler.getMessage(n, this.getName(), l2, this.upperBound);
            throw new ConfigException(n, string4);
        }
        if (this.requiresAdminAction()) {
            this.pendingCalculatedValue = l2;
            this.pendingIntValue = l;
            this.pendingUnit = string;
            this.setPendingValues(IntegerWithUnitConfigAttribute.getValueSet(l, string));
        } else {
            this.activeCalculatedValue = l2;
            this.activeIntValue = l;
            this.activeUnit = string;
            this.setActiveValues(IntegerWithUnitConfigAttribute.getValueSet(l, string));
        }
    }

    public void setValue(String string) throws ConfigException {
        long l;
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(string)));
        int n = string.indexOf(32);
        if (n <= 0) {
            int n2 = 3342356;
            String string2 = MessageHandler.getMessage(n2, String.valueOf(string), this.getName());
            throw new ConfigException(n2, string2);
        }
        try {
            l = Long.parseLong(string.substring(0, n));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setValue", exception));
            int n3 = 3342357;
            String string3 = MessageHandler.getMessage(n3, String.valueOf(string), this.getName(), String.valueOf(exception));
            throw new ConfigException(n3, string3, exception);
        }
        this.setValue(l, string.substring(n + 1));
    }

    private static LinkedHashSet<AttributeValue> getValueSet(long l, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(l), String.valueOf(string)));
        if (string == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        String string2 = l + " " + string;
        linkedHashSet.add(new AttributeValue(new ASN1OctetString(string2), (ByteString)new ASN1OctetString(string2)));
        return linkedHashSet;
    }

    @Override
    public void applyPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "applyPendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeCalculatedValue = this.pendingCalculatedValue;
        this.activeIntValue = this.pendingIntValue;
        this.activeUnit = this.pendingUnit;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue attributeValue, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(attributeValue), "java.lang.StringBuilder"));
        String string = attributeValue.getStringValue().toLowerCase();
        return this.valueIsAcceptable(string, stringBuilder);
    }

    public boolean valueIsAcceptable(String string, StringBuilder stringBuilder) {
        long l;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(string), "java.lang.StringBuilder"));
        int n = string.indexOf(32);
        if (n < 0) {
            stringBuilder.append(MessageHandler.getMessage(3342356, string, this.getName()));
            return false;
        }
        try {
            l = Long.parseLong(string.substring(0, n));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", exception));
            stringBuilder.append(MessageHandler.getMessage(0x33000E, string, this.getName(), String.valueOf(exception)));
            return false;
        }
        String string2 = string.substring(n + 1);
        if (!this.units.containsKey(string2)) {
            stringBuilder.append(MessageHandler.getMessage(0x330013, string2, this.getName()));
            return false;
        }
        double d = this.units.get(string2);
        long l2 = (long)((double)l * d);
        if (this.hasLowerBound && l2 < this.lowerBound) {
            stringBuilder.append(MessageHandler.getMessage(0x33000C, this.getName(), l2, this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && l2 > this.upperBound) {
            stringBuilder.append(MessageHandler.getMessage(0x33000D, this.getName(), l2, this.upperBound));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> list, boolean bl) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "stringsToValues", String.valueOf(list), String.valueOf(bl)));
        if (list == null || list.isEmpty()) {
            if (this.isRequired()) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.getName());
                throw new ConfigException(n, string);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int n = list.size();
        if (!this.isMultiValued() && n > 1) {
            int n2 = 0x330003;
            String string = MessageHandler.getMessage(n2, this.getName());
            throw new ConfigException(n2, string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (String string : list) {
            if (string == null || string.length() == 0) {
                int n3 = 0x330011;
                String string2 = MessageHandler.getMessage(n3, this.getName());
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string2, n3);
                    continue;
                }
                throw new ConfigException(n3, string2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.valueIsAcceptable(string.toLowerCase(), stringBuilder)) {
                int n4 = 3342358;
                String string3 = MessageHandler.getMessage(n4, string, this.getName(), stringBuilder.toString());
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string3, n4);
                    continue;
                }
                throw new ConfigException(n4, string3);
            }
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        }
        if (this.isRequired() && linkedHashSet.isEmpty()) {
            String string;
            int n5 = 0x330001;
            string = MessageHandler.getMessage(n5, this.getName());
            throw new ConfigException(n5, string);
        }
        return linkedHashSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValuesToStrings", new String[0]));
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(this.activeIntValue + " " + this.activeUnit);
        return arrayList;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValuesToStrings", new String[0]));
        if (this.hasPendingValues()) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(this.pendingIntValue + " " + this.pendingUnit);
            return arrayList;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(list)));
        long l = 0L;
        long l2 = 0L;
        String string = null;
        String string2 = null;
        for (Attribute object : list) {
            int exception;
            double n5;
            String string3;
            LinkedHashSet<AttributeValue> n3;
            Object n4;
            if (object.hasOptions()) {
                if (object.hasOption("pending")) {
                    int exception2;
                    if (string2 != null) {
                        int n9 = 0x330040;
                        n4 = MessageHandler.getMessage(n9, object.getName());
                        throw new ConfigException(n9, (String)n4);
                    }
                    n3 = object.getValues();
                    if (n3.isEmpty()) {
                        int n11 = 0x330001;
                        string3 = MessageHandler.getMessage(n11, object.getName());
                        throw new ConfigException(n11, string3);
                    }
                    n4 = n3.iterator();
                    string3 = ((AttributeValue)n4.next()).getStringValue();
                    if (n4.hasNext()) {
                        int n2 = 0x330003;
                        String n6 = MessageHandler.getMessage(n2, object.getName());
                        throw new ConfigException(n2, n6);
                    }
                    try {
                        exception2 = string3.indexOf(32);
                        l2 = Long.parseLong(string3.substring(0, exception2));
                        string2 = string3.substring(exception2 + 1).trim();
                    }
                    catch (Exception n12) {
                        int string6 = 3342357;
                        String n7 = MessageHandler.getMessage(string6, string3, object.getName(), String.valueOf(n12));
                        throw new ConfigException(string6, n7);
                    }
                    if (!this.units.containsKey(string2)) {
                        exception2 = 0x330013;
                        String string9 = MessageHandler.getMessage(exception2, string2, object.getName());
                        throw new ConfigException(exception2, string9);
                    }
                    n5 = this.units.get(string);
                    this.pendingCalculatedValue = (long)(n5 * (double)l2);
                    if (this.hasLowerBound && this.pendingCalculatedValue < this.lowerBound) {
                        int n8 = 0x33000C;
                        String string8 = MessageHandler.getMessage(n8, object.getName(), this.pendingCalculatedValue, this.lowerBound);
                        throw new ConfigException(n8, string8);
                    }
                    if (!this.hasUpperBound || this.pendingCalculatedValue <= this.upperBound) continue;
                    int string10 = 0x33000D;
                    String string12 = MessageHandler.getMessage(string10, object.getName(), this.pendingCalculatedValue, this.upperBound);
                    throw new ConfigException(string10, string12);
                }
                int n10 = 3342366;
                n4 = MessageHandler.getMessage(n10, object.getName());
                throw new ConfigException(n10, (String)n4);
            }
            if (string != null) {
                int n = 3342401;
                n4 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, (String)n4);
            }
            n3 = object.getValues();
            if (n3.isEmpty()) {
                int n = 0x330001;
                string3 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, string3);
            }
            n4 = n3.iterator();
            string3 = ((AttributeValue)n4.next()).getStringValue();
            if (n4.hasNext()) {
                int n = 0x330003;
                String n13 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, n13);
            }
            try {
                exception = string3.indexOf(32);
                l = Long.parseLong(string3.substring(0, exception));
                string = string3.substring(exception + 1).trim();
            }
            catch (Exception exception3) {
                int string11 = 3342357;
                String n14 = MessageHandler.getMessage(string11, string3, object.getName(), String.valueOf(exception3));
                throw new ConfigException(string11, n14);
            }
            if (!this.units.containsKey(string)) {
                exception = 0x330013;
                String string4 = MessageHandler.getMessage(exception, string, object.getName());
                throw new ConfigException(exception, string4);
            }
            n5 = this.units.get(string);
            this.activeCalculatedValue = (long)(n5 * (double)l);
            if (this.hasLowerBound && this.activeCalculatedValue < this.lowerBound) {
                int n15 = 0x33000C;
                String string13 = MessageHandler.getMessage(n15, object.getName(), this.activeCalculatedValue, this.lowerBound);
                throw new ConfigException(n15, string13);
            }
            if (!this.hasUpperBound || this.activeCalculatedValue <= this.upperBound) continue;
            int n = 0x33000D;
            String string5 = MessageHandler.getMessage(n, object.getName(), this.activeCalculatedValue, this.upperBound);
            throw new ConfigException(n, string5);
        }
        if (string == null) {
            int n = 3342402;
            String string6 = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string6);
        }
        if (string2 == null) {
            l2 = l;
            string2 = string;
        }
        return new IntegerWithUnitConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), this.units, this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, l, string, l2, string2);
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", new String[0]));
        return new javax.management.Attribute(this.getName(), this.activeIntValue + " " + this.activeUnit);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributePending", new String[0]));
        return new javax.management.Attribute(this.getName() + ";" + "pending", this.pendingIntValue + " " + this.pendingUnit);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", String.valueOf(attributeList)));
        String string = this.activeIntValue + " " + this.activeUnit;
        attributeList.add(new javax.management.Attribute(this.getName(), string));
        if (this.requiresAdminAction() && this.pendingCalculatedValue != this.activeCalculatedValue) {
            String string2 = this.getName() + ";" + "pending";
            String string3 = this.pendingIntValue + " " + this.pendingUnit;
            attributeList.add(new javax.management.Attribute(string2, string3));
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> list) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributeInfo", String.valueOf(list)));
        list.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), this.getDescription(), true, true, false));
        if (this.requiresAdminAction()) {
            String string = this.getName() + ";" + "pending";
            list.add(new MBeanAttributeInfo(string, String.class.getName(), this.getDescription(), true, false, false));
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXParameterInfo", new String[0]));
        return new MBeanParameterInfo(this.getName(), String.class.getName(), this.getDescription());
    }

    @Override
    public void setValue(javax.management.Attribute attribute) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(attribute)));
        Object object = attribute.getValue();
        if (!(object instanceof String)) {
            int n = 3342408;
            String string = MessageHandler.getMessage(n, String.valueOf(object), this.getName(), object.getClass().getName());
            throw new ConfigException(n, string);
        }
        this.setValue((String)object);
    }

    @Override
    public ConfigAttribute duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        return new IntegerWithUnitConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), this.units, this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, this.activeIntValue, this.activeUnit, this.pendingIntValue, this.pendingUnit);
    }
}

