/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.controls.MatchedValuesFilter;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Control;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchedValuesControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.MatchedValuesControl";
    ArrayList<MatchedValuesFilter> filters;

    public MatchedValuesControl(boolean bl, ArrayList<MatchedValuesFilter> arrayList) {
        super("1.2.826.0.1.3344810.2.3", bl, MatchedValuesControl.encodeValue(arrayList));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bl), String.valueOf(arrayList)));
        this.filters = arrayList;
    }

    public MatchedValuesControl(String string, boolean bl, ArrayList<MatchedValuesFilter> arrayList) {
        super(string, bl, MatchedValuesControl.encodeValue(arrayList));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bl), String.valueOf(arrayList)));
        this.filters = arrayList;
    }

    private MatchedValuesControl(String string, boolean bl, ArrayList<MatchedValuesFilter> arrayList, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bl), String.valueOf(arrayList)));
        this.filters = arrayList;
    }

    private static ASN1OctetString encodeValue(ArrayList<MatchedValuesFilter> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(arrayList)));
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(arrayList.size());
        for (MatchedValuesFilter matchedValuesFilter : arrayList) {
            arrayList2.add(matchedValuesFilter.encode());
        }
        return new ASN1OctetString(new ASN1Sequence(arrayList2).encode());
    }

    public static MatchedValuesControl decodeControl(Control control) throws LDAPException {
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2359635;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            arrayList = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n = 2359636;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n, string);
        }
        if (arrayList.isEmpty()) {
            int n = 2359637;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        ArrayList<MatchedValuesFilter> arrayList2 = new ArrayList<MatchedValuesFilter>(arrayList.size());
        for (ASN1Element aSN1Element : arrayList) {
            arrayList2.add(MatchedValuesFilter.decode(aSN1Element));
        }
        return new MatchedValuesControl(control.getOID(), control.isCritical(), arrayList2, control.getValue());
    }

    public ArrayList<MatchedValuesFilter> getFilters() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilters", new String[0]));
        return this.filters;
    }

    public boolean valueMatches(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "valueMatches", String.valueOf(attributeType), String.valueOf(attributeValue)));
        for (MatchedValuesFilter matchedValuesFilter : this.filters) {
            try {
                if (!matchedValuesFilter.valueMatches(attributeType, attributeValue)) continue;
                return true;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "valueMatches", exception));
            }
        }
        return false;
    }

    @Override
    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        if (this.filters.size() == 1) {
            stringBuilder.append("MatchedValuesControl(filter=\"");
            this.filters.get(0).toString(stringBuilder);
            stringBuilder.append("\")");
        } else {
            stringBuilder.append("MatchedValuesControl(filters=\"(");
            for (MatchedValuesFilter matchedValuesFilter : this.filters) {
                matchedValuesFilter.toString(stringBuilder);
            }
            stringBuilder.append(")\")");
        }
    }
}

