/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.util.StaticUtils;

public class PasswordPolicyResponseControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.PasswordPolicyResponseControl";
    public static final byte TYPE_WARNING_ELEMENT = -96;
    public static final byte TYPE_ERROR_ELEMENT = -127;
    private int warningValue;
    private PasswordPolicyErrorType errorType;
    private PasswordPolicyWarningType warningType;

    public PasswordPolicyResponseControl() {
        super("1.3.6.1.4.1.42.2.27.8.5.1", false, PasswordPolicyResponseControl.encodeValue(null, -1, null));
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.warningType = null;
        this.errorType = null;
        this.warningValue = -1;
    }

    public PasswordPolicyResponseControl(PasswordPolicyWarningType passwordPolicyWarningType, int n, PasswordPolicyErrorType passwordPolicyErrorType) {
        super("1.3.6.1.4.1.42.2.27.8.5.1", false, PasswordPolicyResponseControl.encodeValue(passwordPolicyWarningType, n, passwordPolicyErrorType));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)passwordPolicyWarningType), String.valueOf(n), String.valueOf((Object)passwordPolicyErrorType)));
        this.warningType = passwordPolicyWarningType;
        this.warningValue = n;
        this.errorType = passwordPolicyErrorType;
    }

    public PasswordPolicyResponseControl(String string, boolean bl, PasswordPolicyWarningType passwordPolicyWarningType, int n, PasswordPolicyErrorType passwordPolicyErrorType) {
        super(string, bl, PasswordPolicyResponseControl.encodeValue(passwordPolicyWarningType, n, passwordPolicyErrorType));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf((Object)passwordPolicyWarningType), String.valueOf(n), String.valueOf((Object)passwordPolicyErrorType)));
        this.warningType = passwordPolicyWarningType;
        this.warningValue = n;
        this.errorType = passwordPolicyErrorType;
    }

    private PasswordPolicyResponseControl(String string, boolean bl, PasswordPolicyWarningType passwordPolicyWarningType, int n, PasswordPolicyErrorType passwordPolicyErrorType, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf((Object)passwordPolicyWarningType), String.valueOf(n), String.valueOf((Object)passwordPolicyErrorType)));
        this.warningType = passwordPolicyWarningType;
        this.warningValue = n;
        this.errorType = passwordPolicyErrorType;
    }

    private static ASN1OctetString encodeValue(PasswordPolicyWarningType passwordPolicyWarningType, int n, PasswordPolicyErrorType passwordPolicyErrorType) {
        ASN1Element aSN1Element;
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf((Object)passwordPolicyWarningType), String.valueOf(n), String.valueOf((Object)passwordPolicyErrorType)));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        if (passwordPolicyWarningType != null) {
            aSN1Element = new ASN1Integer(passwordPolicyWarningType.getType(), n);
            arrayList.add(new ASN1Element(-96, aSN1Element.encode()));
        }
        if (passwordPolicyErrorType != null) {
            arrayList.add(new ASN1Enumerated(-127, passwordPolicyErrorType.intValue()));
        }
        aSN1Element = new ASN1Sequence(arrayList);
        return new ASN1OctetString(aSN1Element.encode());
    }

    public static PasswordPolicyResponseControl decodeControl(Control control) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        ASN1OctetString aSN1OctetString = control.getValue();
        if (aSN1OctetString == null) {
            int n = 2359651;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            PasswordPolicyWarningType passwordPolicyWarningType = null;
            PasswordPolicyErrorType passwordPolicyErrorType = null;
            int n = -1;
            ASN1Sequence aSN1Sequence = ASN1Sequence.decodeAsSequence(aSN1OctetString.value());
            block8: for (ASN1Element aSN1Element : aSN1Sequence.elements()) {
                switch (aSN1Element.getType()) {
                    case -96: {
                        ASN1Integer aSN1Integer = ASN1Integer.decodeAsInteger(aSN1Element.value());
                        n = aSN1Integer.intValue();
                        passwordPolicyWarningType = PasswordPolicyWarningType.valueOf(aSN1Integer.getType());
                        if (passwordPolicyWarningType != null) continue block8;
                        int n2 = 2359652;
                        String string = MessageHandler.getMessage(n2, StaticUtils.byteToHex(aSN1Integer.getType()));
                        throw new LDAPException(2, n2, string);
                    }
                    case -127: {
                        int n2 = aSN1Element.decodeAsEnumerated().intValue();
                        passwordPolicyErrorType = PasswordPolicyErrorType.valueOf(n2);
                        if (passwordPolicyErrorType != null) continue block8;
                        int n3 = 2359653;
                        String string = MessageHandler.getMessage(n3, n2);
                        throw new LDAPException(2, n3, string);
                    }
                }
                int n4 = 2359654;
                String string = MessageHandler.getMessage(n4, StaticUtils.byteToHex(aSN1Element.getType()));
                throw new LDAPException(2, n4, string);
            }
            return new PasswordPolicyResponseControl(control.getOID(), control.isCritical(), passwordPolicyWarningType, n, passwordPolicyErrorType, aSN1OctetString);
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (ASN1Exception aSN1Exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", aSN1Exception));
            int n = 2359655;
            String string = MessageHandler.getMessage(n, aSN1Exception.getMessage());
            throw new LDAPException(2, n, string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n = 2359655;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n, string);
        }
    }

    public PasswordPolicyWarningType getWarningType() {
        assert (Debug.debugEnter(CLASS_NAME, "getWarningType", new String[0]));
        return this.warningType;
    }

    public int getWarningValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getWarningValue", new String[0]));
        return this.warningValue;
    }

    public PasswordPolicyErrorType getErrorType() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorType", new String[0]));
        return this.errorType;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("PasswordPolicyResponseControl(");
        if (this.warningType != null) {
            stringBuilder.append(this.warningType.toString());
            stringBuilder.append("=");
            stringBuilder.append(this.warningValue);
            if (this.errorType != null) {
                stringBuilder.append(", ");
            }
        }
        if (this.errorType != null) {
            stringBuilder.append(this.errorType.toString());
        }
        stringBuilder.append(")");
    }
}

