/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Control;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbandonOperation
extends Operation {
    private static final String CLASS_NAME = "org.opends.server.core.AbandonOperation";
    private int idToAbandon;
    private long processingStartTime;
    private long processingStopTime;

    public AbandonOperation(ClientConnection clientConnection, long l, int n, List<Control> list, int n2) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(n2)));
        this.idToAbandon = n2;
    }

    public int getIDToAbandon() {
        assert (Debug.debugEnter(CLASS_NAME, "getIDToAbandon", new String[0]));
        return this.idToAbandon;
    }

    public long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    public long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    public long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.ABANDON;
    }

    @Override
    public String[][] getRequestLogElements() {
        return new String[][]{{"idToAbandon", String.valueOf(this.idToAbandon)}};
    }

    @Override
    public String[][] getResponseLogElements() {
        String string = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string2 = stringBuilder == null ? null : stringBuilder.toString();
        String string3 = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string}, {"errorMessage", string2}, {"processingTime", string3}};
    }

    @Override
    public List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return NO_RESPONSE_CONTROLS;
    }

    @Override
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        this.setResultCode(ResultCode.UNDEFINED);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean bl = false;
        this.processingStartTime = System.currentTimeMillis();
        PreParsePluginResult preParsePluginResult = pluginConfigManager.invokePreParseAbandonPlugins(this);
        if (preParsePluginResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int n = 262368;
            this.appendErrorMessage(MessageHandler.getMessage(n));
            this.processingStopTime = System.currentTimeMillis();
            Access.logAbandonRequest(this);
            Access.logAbandonResult(this);
            return;
        }
        if (preParsePluginResult.sendResponseImmediately()) {
            bl = true;
        } else {
            Access.logAbandonRequest(this);
            Operation operation = this.clientConnection.getOperationInProgress(this.idToAbandon);
            if (operation == null) {
                this.setResultCode(ResultCode.NO_SUCH_OPERATION);
                this.appendErrorMessage(MessageHandler.getMessage(196831, this.idToAbandon));
            } else {
                boolean bl2 = DirectoryServer.notifyAbandonedOperations();
                String string = MessageHandler.getMessage(229, this.messageID);
                StringBuilder stringBuilder = new StringBuilder();
                CancelResult cancelResult = operation.cancel(new CancelRequest(bl2, string, stringBuilder));
                this.setResultCode(cancelResult.getResultCode());
                this.setErrorMessage(stringBuilder);
            }
        }
        if (!bl) {
            pluginConfigManager.invokePostOperationAbandonPlugins(this);
        }
        this.processingStopTime = System.currentTimeMillis();
        Access.logAbandonResult(this);
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        cancelRequest.addResponseMessage(MessageHandler.getMessage(196609));
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return null;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("AbandonOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", idToAbandon=");
        stringBuilder.append(this.idToAbandon);
        stringBuilder.append(")");
    }
}

