/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.AuthorizationIdentityResponseControl;
import org.opends.server.controls.PasswordExpiredControl;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockManager;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindOperation
extends Operation {
    private static final String CLASS_NAME = "org.opends.server.core.BindOperation";
    private ASN1OctetString saslCredentials;
    private ASN1OctetString serverSASLCredentials;
    private AuthenticationType authType;
    private boolean isFirstWarning;
    private boolean isGraceLogin;
    private boolean mustChangePassword;
    private boolean pwPolicyControlRequested;
    private ByteString rawBindDN;
    private ByteString simplePassword;
    private DN bindDN;
    private DN userEntryDN;
    private Entry saslAuthUserEntry;
    private int authFailureID;
    private int pwPolicyWarningValue;
    private List<Control> responseControls;
    private long processingStartTime;
    private long processingStopTime;
    PasswordPolicyErrorType pwPolicyErrorType;
    PasswordPolicyWarningType pwPolicyWarningType;
    private PasswordPolicyState pwPolicyState;
    private String authFailureReason;
    private String saslMechanism;

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, ByteString byteString2) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf(byteString2)));
        this.authType = AuthenticationType.SIMPLE;
        this.rawBindDN = byteString;
        this.simplePassword = byteString2;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.bindDN = null;
        this.userEntryDN = null;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.isFirstWarning = false;
        this.isGraceLogin = false;
        this.mustChangePassword = false;
        this.pwPolicyControlRequested = false;
        this.pwPolicyErrorType = null;
        this.pwPolicyWarningType = null;
        this.pwPolicyWarningValue = -1;
    }

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, String string, ASN1OctetString aSN1OctetString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.authType = AuthenticationType.SASL;
        this.rawBindDN = byteString;
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString;
        this.simplePassword = null;
        this.bindDN = null;
        this.userEntryDN = null;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
    }

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, ByteString byteString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(n), String.valueOf(list), String.valueOf(dN), String.valueOf(byteString)));
        this.authType = AuthenticationType.SIMPLE;
        this.bindDN = dN;
        this.simplePassword = byteString;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.rawBindDN = dN == null ? new ASN1OctetString() : new ASN1OctetString(dN.toString());
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.isFirstWarning = false;
        this.isGraceLogin = false;
        this.mustChangePassword = false;
        this.pwPolicyControlRequested = false;
        this.pwPolicyErrorType = null;
        this.pwPolicyWarningType = null;
        this.pwPolicyWarningValue = -1;
        this.userEntryDN = null;
    }

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, String string, ASN1OctetString aSN1OctetString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(dN), String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.authType = AuthenticationType.SASL;
        this.bindDN = dN;
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString;
        this.simplePassword = null;
        this.rawBindDN = dN == null ? new ASN1OctetString() : new ASN1OctetString(dN.toString());
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.userEntryDN = null;
    }

    public AuthenticationType getAuthenticationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthenticationType", new String[0]));
        return this.authType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthenticationType", String.valueOf((Object)authenticationType)));
        this.authType = authenticationType;
    }

    public ByteString getRawBindDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawBindDN", new String[0]));
        return this.rawBindDN;
    }

    public void setRawBindDN(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawBindDN", String.valueOf(byteString)));
        this.rawBindDN = byteString;
        this.bindDN = null;
    }

    public DN getBindDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getBindDN", new String[0]));
        return this.bindDN;
    }

    public void setBindDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setBindDN", String.valueOf(dN)));
        this.bindDN = dN;
    }

    public ByteString getSimplePassword() {
        assert (Debug.debugEnter(CLASS_NAME, "getSimplePassword", new String[0]));
        return this.simplePassword;
    }

    public void setSimplePassword(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSimplePassword", String.valueOf(byteString)));
        this.simplePassword = byteString;
    }

    public String getSASLMechanism() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLMechanism", new String[0]));
        return this.saslMechanism;
    }

    public void setSASLMechanism(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSASLMechanism", String.valueOf(string)));
        this.saslMechanism = string;
    }

    public ASN1OctetString getSASLCredentials() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLCredentials", new String[0]));
        return this.saslCredentials;
    }

    public void setSASLCredentials(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSASLCredentials", String.valueOf(aSN1OctetString)));
        this.saslCredentials = aSN1OctetString;
    }

    public ASN1OctetString getServerSASLCredentials() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerSASLCredentials", new String[0]));
        return this.serverSASLCredentials;
    }

    public void setServerSASLCredentials(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setServerSASLCredentials", String.valueOf(aSN1OctetString)));
        this.serverSASLCredentials = aSN1OctetString;
    }

    public Entry getSASLAuthUserEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLAuthUserEntry", new String[0]));
        return this.saslAuthUserEntry;
    }

    public void setSASLAuthUserEntry(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "setSASLAuthUserEntry", String.valueOf(entry)));
        this.saslAuthUserEntry = entry;
    }

    public String getAuthFailureReason() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthFailureReason", new String[0]));
        return this.authFailureReason;
    }

    public int getAuthFailureID() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthFailureID", new String[0]));
        return this.authFailureID;
    }

    public void setAuthFailureReason(int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthFailureReason", String.valueOf(n), String.valueOf(string)));
        this.authFailureID = n < 0 ? 0 : n;
        this.authFailureReason = string;
    }

    public DN getUserEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserEntryDN", new String[0]));
        return this.userEntryDN;
    }

    public long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    public long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    public long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.BIND;
    }

    @Override
    public String[][] getRequestLogElements() {
        if (this.authType == AuthenticationType.SASL) {
            return new String[][]{{"bindDN", String.valueOf(this.rawBindDN)}, {"authType", this.authType.toString()}, {"saslMechanism", this.saslMechanism}};
        }
        return new String[][]{{"bindDN", String.valueOf(this.rawBindDN)}, {"authType", this.authType.toString()}};
    }

    @Override
    public String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"processingTime", charSequence}};
    }

    @Override
    public List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block147: {
            block149: {
                block146: {
                    block148: {
                        if (!BindOperation.$assertionsDisabled && !Debug.debugEnter("org.opends.server.core.BindOperation", "run", new String[0])) {
                            throw new AssertionError();
                        }
                        this.processingStartTime = System.currentTimeMillis();
                        this.setResultCode(ResultCode.UNDEFINED);
                        var1_1 = false;
                        var2_2 = DirectoryServer.getSizeLimit();
                        var3_3 = DirectoryServer.getTimeLimit();
                        var4_4 = DirectoryServer.getLookthroughLimit();
                        this.clientConnection.setBindInProgress(true);
                        this.clientConnection.setUnauthenticated();
                        var5_5 = null;
                        var6_6 = MessageHandler.getMessage(217);
                        var7_7 = new CancelRequest(true, var6_6);
                        this.clientConnection.cancelAllOperationsExcept(var7_7, this.getMessageID());
                        var8_8 = DirectoryServer.getPluginConfigManager();
                        var9_9 = false;
                        var10_10 = var8_8.invokePreParseBindPlugins(this);
                        if (var10_10.connectionTerminated()) {
                            this.setResultCode(ResultCode.CANCELED);
                            var11_12 = 262368;
                            this.appendErrorMessage(MessageHandler.getMessage(var11_12));
                            this.processingStopTime = System.currentTimeMillis();
                            Access.logBindRequest(this);
                            Access.logBindResponse(this);
                            return;
                        }
                        if (!var10_10.sendResponseImmediately()) break block148;
                        var9_9 = true;
                        Access.logBindRequest(this);
                        break block147;
                    }
                    Access.logBindRequest(this);
                    try {
                        if (this.bindDN != null) break block146;
                        this.bindDN = DN.decode(this.rawBindDN);
                    }
                    catch (DirectoryException var11_13) {
                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var11_13)) {
                            throw new AssertionError();
                        }
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var11_13.getErrorMessageID(), var11_13.getErrorMessage());
                        break block147;
                    }
                }
                if (AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) break block149;
                this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                var11_14 = 262653;
                this.appendErrorMessage(MessageHandler.getMessage(var11_14, new Object[]{String.valueOf(this.bindDN)}));
                var9_9 = true;
                break block147;
            }
            var11_15 = this.getRequestControls();
            if (var11_15 != null && !var11_15.isEmpty()) {
                for (var12_17 = 0; var12_17 < var11_15.size(); ++var12_17) {
                    var13_19 = var11_15.get(var12_17);
                    var14_20 = var13_19.getOID();
                    if (var14_20.equals("2.16.840.1.113730.3.4.16")) {
                        var1_1 = true;
                        continue;
                    }
                    if (var14_20.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                        this.pwPolicyControlRequested = true;
                        continue;
                    }
                    if (!var13_19.isCritical()) continue;
                    this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                    var15_25 = 262538;
                    this.appendErrorMessage(MessageHandler.getMessage(var15_25, new Object[]{String.valueOf(var14_20)}));
                    break block147;
                }
            }
            switch (1.$SwitchMap$org$opends$server$types$AuthenticationType[this.authType.ordinal()]) {
                case 1: {
                    if (this.simplePassword == null || this.simplePassword.value().length == 0) {
                        if (DirectoryServer.bindWithDNRequiresPassword() && this.bindDN != null && !this.bindDN.isNullDN()) {
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            var12_17 = 262565;
                            var13_19 = MessageHandler.getMessage(var12_17);
                            this.setAuthFailureReason(var12_17, (String)var13_19);
                            break;
                        }
                        this.setResultCode(ResultCode.SUCCESS);
                        var5_5 = new AuthenticationInfo();
                        break;
                    }
                    var12_18 = DirectoryServer.getActualRootBindDN(this.bindDN);
                    if (var12_18 != null) {
                        this.bindDN = var12_18;
                    }
                    var13_19 = null;
                    for (var14_21 = 0; var14_21 < 3 && (var13_19 = LockManager.lockRead(this.bindDN)) == null; ++var14_21) {
                    }
                    if (var13_19 == null) {
                        var14_21 = 262363;
                        var15_26 = MessageHandler.getMessage(var14_21, new Object[]{String.valueOf(this.bindDN)});
                        this.setResultCode(DirectoryServer.getServerErrorResultCode());
                        this.setAuthFailureReason(var14_21, var15_26);
                        break;
                    }
                    try {
                        try {
                            var14_22 = DirectoryServer.getEntry(this.bindDN);
                        }
                        catch (DirectoryException var15_27) {
                            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var15_27)) {
                                throw new AssertionError();
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var15_27.getErrorMessageID(), var15_27.getErrorMessage());
                            var14_23 = null;
                            LockManager.unlock(this.bindDN, (Lock)var13_19);
                            break;
                        }
                        if (var14_22 == null) {
                            var15_28 = 196826;
                            var16_33 = MessageHandler.getMessage(var15_28, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var15_28, var16_33);
                            break;
                        }
                        this.userEntryDN = var14_22.getDN();
                        this.pwPolicyState = new PasswordPolicyState(var14_22, false, false);
                        var15_29 = this.pwPolicyState.getPasswordAttribute();
                        var16_34 = var14_22.getAttribute(var15_29);
                        if (var16_34 == null || var16_34.isEmpty()) {
                            var17_38 = 196829;
                            var18_56 = MessageHandler.getMessage(var17_38, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_38, var18_56);
                            break;
                        }
                        if (this.pwPolicyState.requireSecureAuthentication() && !this.clientConnection.isSecure()) {
                            var17_39 = 197124;
                            var18_57 = MessageHandler.getMessage(var17_39, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_39, var18_57);
                            break;
                        }
                        if (this.pwPolicyState.isDisabled()) {
                            var17_40 = 197125;
                            var18_58 = MessageHandler.getMessage(var17_40, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_40, var18_58);
                            break;
                        }
                        if (this.pwPolicyState.isAccountExpired()) {
                            var17_41 = 197139;
                            var18_59 = MessageHandler.getMessage(var17_41, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_41, var18_59);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, this.bindDN, var17_41, var18_59);
                            break;
                        }
                        if (this.pwPolicyState.lockedDueToFailures()) {
                            var17_42 = 197126;
                            var18_60 = MessageHandler.getMessage(var17_42, new Object[]{String.valueOf(this.bindDN)});
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_42, var18_60);
                            break;
                        }
                        if (this.pwPolicyState.lockedDueToMaximumResetAge()) {
                            var17_43 = 197127;
                            var18_61 = MessageHandler.getMessage(var17_43, new Object[]{String.valueOf(this.bindDN)});
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_43, var18_61);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, this.bindDN, var17_43, var18_61);
                            break;
                        }
                        if (this.pwPolicyState.lockedDueToIdleInterval()) {
                            var17_44 = 197128;
                            var18_62 = MessageHandler.getMessage(var17_44, new Object[]{String.valueOf(this.bindDN)});
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_44, var18_62);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, this.bindDN, var17_44, var18_62);
                            break;
                        }
                        if (!this.pwPolicyState.isPasswordExpired()) ** GOTO lbl187
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                        }
                        if ((var17_45 = this.pwPolicyState.getMaxAllowedGraceLogins()) <= 0 || !this.pwPolicyState.mayUseGraceLogin()) ** GOTO lbl181
                        var18_63 = this.pwPolicyState.getGraceLoginTimes();
                        if (var18_63 == null || var18_63.size() < var17_45) {
                            this.isGraceLogin = true;
                            this.mustChangePassword = true;
                            if (this.pwPolicyWarningType == null) {
                                this.pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                                this.pwPolicyWarningValue = var17_45 - (var18_63.size() + 1);
                            }
                        } else {
                            var19_76 = 197129;
                            var20_87 = MessageHandler.getMessage(var19_76, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var19_76, var20_87);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var19_76, var20_87);
                            break;
lbl181:
                            // 1 sources

                            var18_64 = 197129;
                            var19_77 = MessageHandler.getMessage(var18_64, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var18_64, var19_77);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var18_64, var19_77);
                            break;
lbl187:
                            // 1 sources

                            if (this.pwPolicyState.shouldWarn()) {
                                var17_45 = this.pwPolicyState.getSecondsUntilExpiration();
                                var18_63 = StaticUtils.secondsToTimeString(var17_45);
                                var19_78 = 66083;
                                var20_88 = MessageHandler.getMessage(var19_78, new Object[]{var18_63});
                                this.appendErrorMessage((String)var20_88);
                                if (this.pwPolicyWarningType == null) {
                                    this.pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                    this.pwPolicyWarningValue = var17_45;
                                }
                                this.isFirstWarning = this.pwPolicyState.isFirstWarning();
                            }
                        }
                        if (this.pwPolicyState.mustChangePassword()) {
                            this.mustChangePassword = true;
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                            }
                        }
                        if ((var17_46 = var8_8.invokePreOperationBindPlugins(this)).connectionTerminated()) {
                            this.setResultCode(ResultCode.CANCELED);
                            var18_65 = 262369;
                            this.appendErrorMessage(MessageHandler.getMessage(var18_65));
                            this.processingStopTime = System.currentTimeMillis();
                            Access.logBindResponse(this);
                            return;
                        }
                        if (var17_46.sendResponseImmediately()) {
                            var9_9 = true;
                            break;
                        }
                        if (this.pwPolicyState.passwordMatches(this.simplePassword)) {
                            this.setResultCode(ResultCode.SUCCESS);
                            var18_66 = DirectoryServer.isRootDN(var14_22.getDN());
                            var5_5 = new AuthenticationInfo(var14_22.getDN(), this.simplePassword, var18_66);
                            var19_79 = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                            var20_88 = var14_22.getAttribute(var19_79);
                            if (var20_88 != null && var20_88.size() == 1 && (var23_106 = (var22_102 = (var21_97 = (Attribute)var20_88.get(0)).getValues()).iterator()).hasNext()) {
                                var24_109 = (AttributeValue)var23_106.next();
                                if (var23_106.hasNext()) {
                                    var25_116 = 131467;
                                    var26_127 = MessageHandler.getMessage(var25_116, new Object[]{String.valueOf(var14_22.getDN())});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_127, var25_116);
                                } else {
                                    try {
                                        var2_2 = Integer.parseInt(var24_109.getStringValue());
                                    }
                                    catch (Exception var25_117) {
                                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var25_117)) {
                                            throw new AssertionError();
                                        }
                                        var26_128 = 131468;
                                        var27_133 = MessageHandler.getMessage(var26_128, new Object[]{var24_109.getStringValue(), String.valueOf(var14_22.getDN())});
                                        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var27_133, var26_128);
                                    }
                                }
                            }
                            if ((var20_88 = var14_22.getAttribute(var19_79 = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && var20_88.size() == 1 && (var23_106 = (var22_102 = (var21_97 = var20_88.get(0)).getValues()).iterator()).hasNext()) {
                                var24_109 = (AttributeValue)var23_106.next();
                                if (var23_106.hasNext()) {
                                    var25_116 = 131469;
                                    var26_127 = MessageHandler.getMessage(var25_116, new Object[]{String.valueOf(var14_22.getDN())});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_127, var25_116);
                                } else {
                                    try {
                                        var3_3 = Integer.parseInt(var24_109.getStringValue());
                                    }
                                    catch (Exception var25_118) {
                                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var25_118)) {
                                            throw new AssertionError();
                                        }
                                        var26_129 = 131470;
                                        var27_133 = MessageHandler.getMessage(var26_129, new Object[]{var24_109.getStringValue(), String.valueOf(var14_22.getDN())});
                                        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var27_133, var26_129);
                                    }
                                }
                            }
                            if ((var20_88 = var14_22.getAttribute(var19_79 = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) != null && var20_88.size() == 1 && (var23_106 = (var22_102 = (var21_97 = var20_88.get(0)).getValues()).iterator()).hasNext()) {
                                var24_109 = (AttributeValue)var23_106.next();
                                if (var23_106.hasNext()) {
                                    var25_119 = 131629;
                                    var26_130 = MessageHandler.getMessage(var25_119, new Object[]{String.valueOf(var14_22.getDN())});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_130, var25_119);
                                } else {
                                    try {
                                        var4_4 = Integer.parseInt(var24_109.getStringValue());
                                    }
                                    catch (Exception var25_120) {
                                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var25_120)) {
                                            throw new AssertionError();
                                        }
                                        var26_131 = 131630;
                                        var27_133 = MessageHandler.getMessage(var26_131, new Object[]{var24_109.getStringValue(), String.valueOf(var14_22.getDN())});
                                        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var27_133, var26_131);
                                    }
                                }
                            }
                            this.pwPolicyState.handleDeprecatedStorageSchemes(this.simplePassword);
                            this.pwPolicyState.clearAuthFailureTimes();
                            if (this.isFirstWarning) {
                                this.pwPolicyState.setWarnedTime();
                                var21_98 = this.pwPolicyState.getSecondsUntilExpiration();
                                var22_102 = StaticUtils.secondsToTimeString(var21_98);
                                var23_107 = 66083;
                                var24_109 = MessageHandler.getMessage(var23_107, new Object[]{var22_102});
                                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, this.bindDN, var23_107, (String)var24_109);
                            }
                            if (this.isGraceLogin) {
                                this.pwPolicyState.updateGraceLoginTimes();
                            }
                            this.pwPolicyState.setLastLoginTime();
                            break;
                        }
                        var18_67 = 196887;
                        var19_80 = MessageHandler.getMessage(var18_67);
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var18_67, var19_80);
                        var20_89 = this.pwPolicyState.getMaxAllowedFailures();
                        if (var20_89 <= 0) break;
                        this.pwPolicyState.updateAuthFailureTimes();
                        if (this.pwPolicyState.getAuthFailureTimes().size() < var20_89) break;
                        this.pwPolicyState.lockDueToFailures();
                        var22_103 = this.pwPolicyState.getLockoutDuration();
                        if (var22_103 > 0) {
                            var21_99 = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                            var18_67 = 197156;
                            var19_80 = MessageHandler.getMessage(var18_67, new Object[]{StaticUtils.secondsToTimeString(var22_103)});
                        } else {
                            var21_99 = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                            var18_67 = 197157;
                            var19_80 = MessageHandler.getMessage(var18_67);
                        }
                        this.pwPolicyState.generateAccountStatusNotification(var21_99, this.userEntryDN, var18_67, var19_80);
                        break;
                    }
                    catch (Exception var14_24) {
                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var14_24)) {
                            throw new AssertionError();
                        }
                        var15_30 = 196888;
                        var16_34 = MessageHandler.getMessage(var15_30, new Object[]{StaticUtils.stackTraceToSingleLineString(var14_24)});
                        this.setResultCode(DirectoryServer.getServerErrorResultCode());
                        this.setAuthFailureReason(var15_30, (String)var16_34);
                        break;
                    }
                    finally {
                        LockManager.unlock(this.bindDN, (Lock)var13_19);
                    }
                }
                case 2: {
                    var14_20 = DirectoryServer.getSASLMechanismHandler(this.saslMechanism);
                    if (var14_20 == null) {
                        this.setResultCode(ResultCode.AUTH_METHOD_NOT_SUPPORTED);
                        var15_31 = 196830;
                        var16_35 = MessageHandler.getMessage(var15_31, new Object[]{this.saslMechanism});
                        this.appendErrorMessage(var16_35);
                        this.setAuthFailureReason(var15_31, var16_35);
                        break;
                    }
                    var15_32 = var8_8.invokePreOperationBindPlugins(this);
                    if (var15_32.connectionTerminated()) {
                        this.setResultCode(ResultCode.CANCELED);
                        var16_36 = 262369;
                        this.appendErrorMessage(MessageHandler.getMessage(var16_36));
                        this.processingStopTime = System.currentTimeMillis();
                        Access.logBindResponse(this);
                        return;
                    }
                    if (var15_32.sendResponseImmediately()) {
                        var9_9 = true;
                        break;
                    }
                    var14_20.processSASLBind(this);
                    if (this.saslAuthUserEntry == null) {
                        this.pwPolicyState = null;
                        var16_37 = null;
                    } else {
                        try {
                            this.pwPolicyState = new PasswordPolicyState(this.saslAuthUserEntry, false, false);
                            this.userEntryDN = this.saslAuthUserEntry.getDN();
                            var16_37 = String.valueOf(this.userEntryDN);
                        }
                        catch (DirectoryException var17_47) {
                            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var17_47)) {
                                throw new AssertionError();
                            }
                            this.setResponseData(var17_47);
                            break;
                        }
                    }
                    if (this.pwPolicyState == null) ** GOTO lbl422
                    if (this.pwPolicyState.isDisabled()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        var17_48 = 197125;
                        this.appendErrorMessage(MessageHandler.getMessage(var17_48, new Object[]{var16_37}));
                        break;
                    }
                    if (this.pwPolicyState.isAccountExpired()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        var17_49 = 197139;
                        var18_68 = MessageHandler.getMessage(var17_49, new Object[]{var16_37});
                        this.appendErrorMessage(var18_68);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, this.bindDN, var17_49, var18_68);
                        break;
                    }
                    if (this.pwPolicyState.requireSecureAuthentication() && !this.clientConnection.isSecure() && !var14_20.isSecure(this.saslMechanism)) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        var17_50 = 197131;
                        this.appendErrorMessage(MessageHandler.getMessage(var17_50, new Object[]{this.saslMechanism, var16_37}));
                        break;
                    }
                    if (this.pwPolicyState.lockedDueToFailures()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        var17_51 = 197126;
                        this.appendErrorMessage(MessageHandler.getMessage(var17_51, new Object[]{var16_37}));
                        break;
                    }
                    if (this.pwPolicyState.lockedDueToIdleInterval()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        var17_52 = 197128;
                        var18_69 = MessageHandler.getMessage(var17_52, new Object[]{var16_37});
                        this.appendErrorMessage(var18_69);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, this.bindDN, var17_52, var18_69);
                        break;
                    }
                    if (!var14_20.isPasswordBased(this.saslMechanism)) ** GOTO lbl422
                    if (this.pwPolicyState.lockedDueToMaximumResetAge()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        var17_53 = 197127;
                        var18_70 = MessageHandler.getMessage(var17_53, new Object[]{var16_37});
                        this.appendErrorMessage(var18_70);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, this.bindDN, var17_53, var18_70);
                        break;
                    }
                    if (!this.pwPolicyState.isPasswordExpired()) ** GOTO lbl412
                    if (this.pwPolicyErrorType == null) {
                        this.pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                    }
                    if ((var17_54 = this.pwPolicyState.getMaxAllowedGraceLogins()) <= 0 || !this.pwPolicyState.mayUseGraceLogin()) ** GOTO lbl406
                    var18_71 = this.pwPolicyState.getGraceLoginTimes();
                    if (var18_71 == null || var18_71.size() < var17_54) {
                        this.isGraceLogin = true;
                        this.mustChangePassword = true;
                        if (this.pwPolicyWarningType == null) {
                            this.pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                            this.pwPolicyWarningValue = var17_54 - (var18_71.size() + 1);
                        }
                    } else {
                        var19_81 = 197129;
                        var20_90 = MessageHandler.getMessage(var19_81, new Object[]{String.valueOf(this.bindDN)});
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var19_81, var20_90);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var19_81, var20_90);
                        break;
lbl406:
                        // 1 sources

                        var18_72 = 197129;
                        var19_82 = MessageHandler.getMessage(var18_72, new Object[]{String.valueOf(this.bindDN)});
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var18_72, var19_82);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var18_72, var19_82);
                        break;
lbl412:
                        // 1 sources

                        if (this.pwPolicyState.shouldWarn()) {
                            var17_54 = this.pwPolicyState.getSecondsUntilExpiration();
                            var18_71 = StaticUtils.secondsToTimeString(var17_54);
                            var19_83 = 66083;
                            var20_91 = MessageHandler.getMessage(var19_83, new Object[]{var18_71});
                            this.appendErrorMessage(var20_91);
                            if (this.pwPolicyWarningType == null) {
                                this.pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                this.pwPolicyWarningValue = var17_54;
                            }
                            this.isFirstWarning = this.pwPolicyState.isFirstWarning();
                        }
                    }
lbl422:
                    // 6 sources

                    if ((var17_55 = this.getResultCode()) == ResultCode.SUCCESS) {
                        if (this.pwPolicyState == null) break;
                        if (var14_20.isPasswordBased(this.saslMechanism) && this.pwPolicyState.mustChangePassword()) {
                            this.mustChangePassword = true;
                        }
                        if (this.isFirstWarning) {
                            this.pwPolicyState.setWarnedTime();
                            var18_73 = this.pwPolicyState.getSecondsUntilExpiration();
                            var19_84 = StaticUtils.secondsToTimeString(var18_73);
                            var20_92 = 66083;
                            var21_100 = MessageHandler.getMessage(var20_92, new Object[]{var19_84});
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, this.bindDN, var20_92, (String)var21_100);
                        }
                        if (this.isGraceLogin) {
                            this.pwPolicyState.updateGraceLoginTimes();
                        }
                        this.pwPolicyState.setLastLoginTime();
                        var18_74 = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                        var19_85 = this.saslAuthUserEntry.getAttribute(var18_74);
                        if (var19_85 != null && var19_85.size() == 1 && (var22_104 = (var21_100 = (var20_93 = var19_85.get(0)).getValues()).iterator()).hasNext()) {
                            var23_108 = (AttributeValue)var22_104.next();
                            if (var22_104.hasNext()) {
                                var24_110 = 131467;
                                var25_121 = MessageHandler.getMessage(var24_110, new Object[]{var16_37});
                                Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var25_121, var24_110);
                            } else {
                                try {
                                    var2_2 = Integer.parseInt(var23_108.getStringValue());
                                }
                                catch (Exception var24_111) {
                                    if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var24_111)) {
                                        throw new AssertionError();
                                    }
                                    var25_122 = 131468;
                                    var26_132 = MessageHandler.getMessage(var25_122, new Object[]{var23_108.getStringValue(), var16_37});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_132, var25_122);
                                }
                            }
                        }
                        if ((var19_85 = this.saslAuthUserEntry.getAttribute(var18_74 = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && var19_85.size() == 1 && (var22_104 = (var21_100 = (var20_94 = var19_85.get(0)).getValues()).iterator()).hasNext()) {
                            var23_108 = (AttributeValue)var22_104.next();
                            if (var22_104.hasNext()) {
                                var24_112 = 131469;
                                var25_123 = MessageHandler.getMessage(var24_112, new Object[]{var16_37});
                                Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var25_123, var24_112);
                            } else {
                                try {
                                    var3_3 = Integer.parseInt(var23_108.getStringValue());
                                }
                                catch (Exception var24_113) {
                                    if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var24_113)) {
                                        throw new AssertionError();
                                    }
                                    var25_124 = 131470;
                                    var26_132 = MessageHandler.getMessage(var25_124, new Object[]{var23_108.getStringValue(), var16_37});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_132, var25_124);
                                }
                            }
                        }
                        if ((var19_85 = this.saslAuthUserEntry.getAttribute(var18_74 = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) == null || var19_85.size() != 1 || !(var22_104 = (var21_100 = (var20_95 = var19_85.get(0)).getValues()).iterator()).hasNext()) break;
                        var23_108 = (AttributeValue)var22_104.next();
                        if (var22_104.hasNext()) {
                            var24_114 = 131629;
                            var25_125 = MessageHandler.getMessage(var24_114, new Object[]{var16_37});
                            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var25_125, var24_114);
                            break;
                        }
                        try {
                            var4_4 = Integer.parseInt(var23_108.getStringValue());
                        }
                        catch (Exception var24_115) {
                            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var24_115)) {
                                throw new AssertionError();
                            }
                            var25_126 = 131630;
                            var26_132 = MessageHandler.getMessage(var25_126, new Object[]{var23_108.getStringValue(), var16_37});
                            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_132, var25_126);
                        }
                        break;
                    }
                    if (var17_55 == ResultCode.SASL_BIND_IN_PROGRESS || this.pwPolicyState == null || !var14_20.isPasswordBased(this.saslMechanism) || (var18_75 = this.pwPolicyState.getMaxAllowedFailures()) <= 0) break;
                    this.pwPolicyState.updateAuthFailureTimes();
                    if (this.pwPolicyState.getAuthFailureTimes().size() < var18_75) break;
                    this.pwPolicyState.lockDueToFailures();
                    var22_105 = this.pwPolicyState.getLockoutDuration();
                    if (var22_105 > 0) {
                        var19_86 = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                        var20_96 = 197156;
                        var21_101 = MessageHandler.getMessage(var20_96, new Object[]{StaticUtils.secondsToTimeString(var22_105)});
                    } else {
                        var19_86 = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                        var20_96 = 197157;
                        var21_101 = MessageHandler.getMessage(var20_96);
                    }
                    this.pwPolicyState.generateAccountStatusNotification(var19_86, this.userEntryDN, var20_96, var21_101);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        try {
            if (this.pwPolicyState != null) {
                this.pwPolicyState.updateUserEntry();
            }
        }
        catch (DirectoryException var10_11) {
            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var10_11)) {
                throw new AssertionError();
            }
            this.setResponseData(var10_11);
        }
        if (!var9_9 && (var10_10 = var8_8.invokePostOperationBindPlugins(this)).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            var11_16 = 262369;
            this.appendErrorMessage(MessageHandler.getMessage(var11_16));
            this.processingStopTime = System.currentTimeMillis();
            Access.logBindResponse(this);
            return;
        }
        if (this.getResultCode() == ResultCode.SUCCESS && var5_5 != null) {
            this.clientConnection.setAuthenticationInfo(var5_5);
            this.clientConnection.setSizeLimit(var2_2);
            this.clientConnection.setTimeLimit(var3_3);
            this.clientConnection.setLookthroughLimit(var4_4);
            this.clientConnection.setMustChangePassword(this.mustChangePassword);
            if (var1_1) {
                this.responseControls.add(new AuthorizationIdentityResponseControl(var5_5.getAuthorizationDN()));
            }
        }
        if (this.getResultCode() == ResultCode.SUCCESS) {
            if (this.pwPolicyControlRequested) {
                var10_10 = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
                this.responseControls.add((Control)var10_10);
            } else if (this.pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
                this.responseControls.add(new PasswordExpiredControl());
            } else if (this.pwPolicyWarningType == PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION) {
                this.responseControls.add(new PasswordExpiringControl(this.pwPolicyWarningValue));
            }
        } else if (this.pwPolicyControlRequested) {
            var10_10 = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
            this.responseControls.add((Control)var10_10);
        } else if (this.pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
            this.responseControls.add(new PasswordExpiredControl());
        }
        this.clientConnection.setBindInProgress(false);
        this.processingStopTime = System.currentTimeMillis();
        this.clientConnection.sendResponse(this);
        Access.logBindResponse(this);
        var8_8.invokePostResponseBindPlugins(this);
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        cancelRequest.addResponseMessage(MessageHandler.getMessage(196610));
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return null;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("BindOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", dn=");
        stringBuilder.append(this.rawBindDN);
        stringBuilder.append(", authType=");
        stringBuilder.append((Object)this.authType);
        stringBuilder.append(")");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$types$AuthenticationType;

        static {
            $SwitchMap$org$opends$server$types$AuthenticationType = new int[AuthenticationType.values().length];
            try {
                1.$SwitchMap$org$opends$server$types$AuthenticationType[AuthenticationType.SIMPLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$AuthenticationType[AuthenticationType.SASL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

