/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

public class ConnectionHandlerConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.ConnectionHandlerConfigManager";
    private ConcurrentHashMap<DN, ConnectionHandler> connectionHandlers;
    private DN configEntryDN;

    public ConnectionHandlerConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeConnectionHandlerConfig() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeConnectionHandlerConfig", new String[0]));
        this.connectionHandlers = new ConcurrentHashMap();
        try {
            this.configEntryDN = DN.decode("cn=Connection Handlers,cn=config");
            configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            int n = 3408014;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3408015;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n;
            DN dN;
            block22: {
                Object object5;
                dN = configEntry2.getDN();
                configEntry2.registerChangeListener(this);
                if (!configEntry2.hasObjectClass("ds-cfg-connection-handler")) {
                    n = 3276944;
                    object5 = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object5, n);
                    continue;
                }
                n = 3145874;
                object5 = new BooleanConfigAttribute("ds-cfg-connection-handler-enabled", MessageHandler.getMessage(n), false);
                try {
                    object4 = (BooleanConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object5);
                    if (object4 == null) {
                        n = 3276948;
                        object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object3, n);
                        continue;
                    }
                    if (!((BooleanConfigAttribute)object4).activeValue()) {
                        n = 3145877;
                        object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, (String)object3, n);
                    }
                    break block22;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
                    n = 3408022;
                    object3 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n);
                }
                continue;
            }
            n = 0x300093;
            object3 = new StringConfigAttribute("ds-cfg-connection-handler-class", MessageHandler.getMessage(n), true, false, true);
            try {
                object2 = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (object2 == null) {
                    n = 3408023;
                    object = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                    continue;
                }
                object4 = ((StringConfigAttribute)object2).activeValue();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
                n = 3408024;
                object = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                continue;
            }
            try {
                object = Class.forName((String)object4);
                object2 = (ConnectionHandler)((Class)object).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
                n = 3408025;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            try {
                ((ConnectionHandler)object2).initializeConnectionHandler(configEntry2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
                n = 3408026;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            this.connectionHandlers.put(dN, (ConnectionHandler)object2);
            DirectoryServer.registerConnectionHandler((ConnectionHandler)object2);
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        configEntry.registerChangeListener(this);
        try {
            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-connection-handler)");
            if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                int n = 3276944;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            int n = 3408017;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        int n = 3145874;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-connection-handler-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3276948;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408022;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 0x300093;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-connection-handler-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408023;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                stringBuilder.append(string);
                return false;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408024;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object2);
            ConnectionHandler connectionHandler = (ConnectionHandler)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408025;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        Object object;
        Object object2;
        int n;
        boolean bl;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        ConnectionHandler connectionHandler;
        DN dN;
        block21: {
            assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
            dN = configEntry.getDN();
            connectionHandler = this.connectionHandlers.get(dN);
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            if (!configEntry.hasObjectClass("ds-cfg-connection-handler")) {
                int n2 = 3276944;
                arrayList.add(MessageHandler.getMessage(n2, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            bl = false;
            n = 3145874;
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-connection-handler-enabled", MessageHandler.getMessage(n), false);
            try {
                object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
                if (object2 == null) {
                    n = 3276948;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                if (((BooleanConfigAttribute)object2).activeValue()) {
                    if (connectionHandler == null) {
                        bl = true;
                    }
                    break block21;
                }
                if (connectionHandler != null) {
                    DirectoryServer.deregisterConnectionHandler(connectionHandler);
                    this.connectionHandlers.remove(dN);
                    int n3 = 273;
                    connectionHandler.finalizeConnectionHandler(MessageHandler.getMessage(n3), false);
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                n = 3408022;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
        }
        n = 0x300093;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-connection-handler-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408023;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408024;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (connectionHandler != null) {
            if (!((String)object2).equals(connectionHandler.getClass().getName())) {
                bl2 = true;
            }
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (bl) {
            try {
                object = Class.forName((String)object2);
                connectionHandler = (ConnectionHandler)((Class)object).newInstance();
            }
            catch (Exception exception) {
                n = 3408031;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN)));
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            try {
                connectionHandler.initializeConnectionHandler(configEntry);
                connectionHandler.start();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                n = 3408026;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            this.connectionHandlers.put(dN, connectionHandler);
            DirectoryServer.registerConnectionHandler(connectionHandler);
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        LinkedList<String> linkedList;
        Object object;
        Object object2;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        configEntry.registerChangeListener(this);
        try {
            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-connection-handler)");
            if (!searchFilter.matchesEntry(configEntry.getEntry())) {
                int n = 3276944;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            int n = 3408017;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        int n = 3145874;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-connection-handler-enabled", MessageHandler.getMessage(n), false);
        try {
            object3 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object3 == null) {
                n = 3276948;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408022;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 0x300093;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-connection-handler-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object2 == null) {
                n = 3408023;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                stringBuilder.append(string);
                return false;
            }
            object3 = ((StringConfigAttribute)object2).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408024;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object3);
            object2 = (ConnectionHandler)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408025;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object3), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        if (object2 instanceof ConfigurableComponent && !(object = (ConfigurableComponent)object2).hasAcceptableConfiguration(configEntry, linkedList = new LinkedList<String>())) {
            if (linkedList.isEmpty()) {
                n = 3408027;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
            } else {
                Iterator iterator = linkedList.iterator();
                stringBuilder.append((String)iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append("  ");
                    stringBuilder.append((String)iterator.next());
                }
            }
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        configEntry.registerChangeListener(this);
        if (!configEntry.hasObjectClass("ds-cfg-connection-handler")) {
            int n = 3276944;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        int n = 3145874;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-connection-handler-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3276948;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!((BooleanConfigAttribute)object2).activeValue()) {
                n = 3145877;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408022;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        n = 0x300093;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-connection-handler-class", MessageHandler.getMessage(n), true, false, true);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408023;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408024;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            Class<?> clazz = Class.forName((String)object2);
            object = (ConnectionHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408025;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            ((ConnectionHandler)object).initializeConnectionHandler(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandlerConfig", exception));
            n = 3408026;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        this.connectionHandlers.put(dN, (ConnectionHandler)object);
        DirectoryServer.registerConnectionHandler((ConnectionHandler)object);
        ((Thread)object).start();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ConnectionHandler connectionHandler = this.connectionHandlers.get(dN);
        if (connectionHandler != null) {
            DirectoryServer.deregisterConnectionHandler(connectionHandler);
            int n = 274;
            connectionHandler.finalizeConnectionHandler(MessageHandler.getMessage(n), false);
        }
        return new ConfigChangeResult(resultCode, bl);
    }
}

