/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.types.WritabilityMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreConfigManager
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.core.CoreConfigManager";
    private static final LinkedHashMap<String, Double> timeUnits = new LinkedHashMap();
    private DN configEntryDN;

    public CoreConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeCoreConfig() throws ConfigException, InitializationException {
        ConfigAttribute configAttribute;
        ConfigAttribute configAttribute2;
        Object object;
        ConfigAttribute configAttribute3;
        ConfigAttribute configAttribute4;
        ConfigAttribute configAttribute5;
        ConfigAttribute configAttribute6;
        Object object2;
        Object object3;
        Object object4;
        assert (Debug.debugEnter(CLASS_NAME, "initializeCoreConfig", new String[0]));
        ConfigEntry configEntry = DirectoryServer.getConfigHandler().getConfigRootEntry();
        this.configEntryDN = configEntry.getDN();
        boolean bl = true;
        int n = 3145926;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-check-schema", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 == null) {
                DirectoryServer.setCheckSchema(bl);
            } else {
                DirectoryServer.setCheckSchema(booleanConfigAttribute2.pendingValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408071, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setCheckSchema(bl);
        }
        boolean bl2 = false;
        n = 0x30003C;
        BooleanConfigAttribute booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-allow-attribute-name-exceptions", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute4 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
            if (booleanConfigAttribute4 == null) {
                DirectoryServer.setAllowAttributeNameExceptions(bl2);
            } else {
                DirectoryServer.setAllowAttributeNameExceptions(booleanConfigAttribute4.pendingValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3407933, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setAllowAttributeNameExceptions(bl2);
        }
        boolean bl3 = false;
        n = 3146153;
        BooleanConfigAttribute booleanConfigAttribute5 = new BooleanConfigAttribute("ds-cfg-add-missing-rdn-attributes", MessageHandler.getMessage(n), false);
        try {
            object4 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute5);
            if (object4 == null) {
                DirectoryServer.setAddMissingRDNAttributes(bl3);
            } else {
                DirectoryServer.setAddMissingRDNAttributes(object4.pendingValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408298, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setAddMissingRDNAttributes(bl3);
        }
        object4 = ResultCode.OTHER;
        n = 3146155;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-server-error-result-code", MessageHandler.getMessage(n), false, false, false, true, 1L, false, 0L);
        try {
            object3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (object3 == null) {
                DirectoryServer.setServerErrorResultCode((ResultCode)((Object)object4));
            } else {
                int n2 = object3.pendingIntValue();
                object4 = ResultCode.valueOf(n2);
                DirectoryServer.setServerErrorResultCode((ResultCode)((Object)object4));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408300, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setServerErrorResultCode((ResultCode)((Object)object4));
        }
        object3 = AcceptRejectWarn.WARN;
        HashSet<String> hashSet = new HashSet<String>(3);
        hashSet.add(AcceptRejectWarn.ACCEPT.toString());
        hashSet.add(AcceptRejectWarn.REJECT.toString());
        hashSet.add(AcceptRejectWarn.WARN.toString());
        n = 0x30003E;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-invalid-attribute-syntax-behavior", MessageHandler.getMessage(n), true, false, false, hashSet);
        try {
            object2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (object2 == null) {
                DirectoryServer.setSyntaxEnforcementPolicy((AcceptRejectWarn)((Object)object3));
            } else {
                object3 = AcceptRejectWarn.policyForName(object2.pendingValue());
                if (object3 == null) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3407935, String.valueOf(configEntry.getDN()), String.valueOf(object2.pendingValue()));
                    object3 = AcceptRejectWarn.WARN;
                }
                DirectoryServer.setSyntaxEnforcementPolicy((AcceptRejectWarn)((Object)object3));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3407935, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setSyntaxEnforcementPolicy((AcceptRejectWarn)((Object)object3));
        }
        object2 = AcceptRejectWarn.WARN;
        HashSet<String> hashSet2 = new HashSet<String>(3);
        hashSet2.add(AcceptRejectWarn.ACCEPT.toString());
        hashSet2.add(AcceptRejectWarn.REJECT.toString());
        hashSet2.add(AcceptRejectWarn.WARN.toString());
        n = 3145924;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = new MultiChoiceConfigAttribute("ds-cfg-single-structural-objectclass-behavior", MessageHandler.getMessage(n), true, false, false, hashSet2);
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute3 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute2);
            if (multiChoiceConfigAttribute3 == null) {
                DirectoryServer.setSingleStructuralObjectClassPolicy((AcceptRejectWarn)((Object)object2));
            } else {
                object2 = AcceptRejectWarn.policyForName(multiChoiceConfigAttribute3.pendingValue());
                if (object2 == null) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408069, String.valueOf(configEntry.getDN()), String.valueOf(multiChoiceConfigAttribute3.pendingValue()));
                    object2 = AcceptRejectWarn.WARN;
                }
                DirectoryServer.setSingleStructuralObjectClassPolicy((AcceptRejectWarn)((Object)object2));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408069, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setSingleStructuralObjectClassPolicy((AcceptRejectWarn)((Object)object2));
        }
        long l = -1L;
        n = 3145848;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-max-allowed-client-connections", MessageHandler.getMessage(n), true, false, false, true, -1L, false, 0L);
        try {
            IntegerConfigAttribute integerConfigAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
            if (integerConfigAttribute3 == null) {
                DirectoryServer.setMaxAllowedConnections(l);
            } else {
                DirectoryServer.setMaxAllowedConnections(integerConfigAttribute3.activeValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3407993, configEntry.getDN(), String.valueOf(exception));
            DirectoryServer.setMaxAllowedConnections(l);
        }
        boolean bl4 = false;
        n = 3145974;
        BooleanConfigAttribute booleanConfigAttribute6 = new BooleanConfigAttribute("ds-cfg-notify-abandoned-operations", MessageHandler.getMessage(n), false);
        try {
            configAttribute6 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute6);
            if (configAttribute6 == null) {
                DirectoryServer.setNotifyAbandonedOperations(bl4);
            } else {
                DirectoryServer.setNotifyAbandonedOperations(configAttribute6.activeValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408119, configEntry.getDN(), String.valueOf(exception));
            DirectoryServer.setNotifyAbandonedOperations(bl4);
        }
        n = 3146173;
        configAttribute6 = new DNConfigAttribute("ds-cfg-proxied-authorization-identity-mapper-dn", MessageHandler.getMessage(n), false, false, false);
        try {
            configAttribute5 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute6);
            if (configAttribute5 == null) {
                DirectoryServer.setProxiedAuthorizationIdentityMapperDN(null);
            } else {
                DirectoryServer.setProxiedAuthorizationIdentityMapperDN(configAttribute5.activeValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408318, configEntry.getDN(), String.valueOf(exception));
            DirectoryServer.setProxiedAuthorizationIdentityMapperDN(null);
        }
        n = 3146178;
        configAttribute5 = new IntegerConfigAttribute("ds-cfg-size-limit", MessageHandler.getMessage(n), false, false, false, true, -1L, true, Integer.MAX_VALUE);
        try {
            configAttribute4 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute5);
            if (configAttribute4 == null) {
                DirectoryServer.setSizeLimit(1000);
            } else {
                DirectoryServer.setSizeLimit(configAttribute4.activeIntValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408323, configEntry.getDN(), String.valueOf(exception));
            DirectoryServer.setSizeLimit(1000);
        }
        n = 3146178;
        configAttribute4 = new IntegerWithUnitConfigAttribute("ds-cfg-time-limit", MessageHandler.getMessage(n), false, timeUnits, true, -1L, true, Integer.MAX_VALUE);
        try {
            configAttribute3 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute4);
            if (configAttribute3 == null) {
                DirectoryServer.setTimeLimit(60);
            } else {
                DirectoryServer.setTimeLimit((int)configAttribute3.activeCalculatedValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408323, configEntry.getDN(), String.valueOf(exception));
            DirectoryServer.setTimeLimit(60);
        }
        n = 3146289;
        configAttribute3 = new IntegerConfigAttribute("ds-cfg-lookthrough-limit", MessageHandler.getMessage(n), false, false, false, true, -1L, true, Integer.MAX_VALUE);
        try {
            object = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute3);
            if (object == null) {
                DirectoryServer.setLookthroughLimit(5000);
            } else {
                DirectoryServer.setLookthroughLimit(object.activeIntValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408434, configEntry.getDN(), String.valueOf(exception));
            DirectoryServer.setLookthroughLimit(5000);
        }
        object = WritabilityMode.ENABLED;
        HashSet<String> hashSet3 = new HashSet<String>(3);
        hashSet3.add(WritabilityMode.ENABLED.toString());
        hashSet3.add(WritabilityMode.DISABLED.toString());
        hashSet3.add(WritabilityMode.INTERNAL_ONLY.toString());
        n = 3146200;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute4 = new MultiChoiceConfigAttribute("ds-cfg-writability-mode", MessageHandler.getMessage(n), true, false, false, hashSet3);
        try {
            configAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute4);
            if (configAttribute2 == null) {
                DirectoryServer.setWritabilityMode((WritabilityMode)((Object)object));
            } else {
                object = WritabilityMode.modeForName(((MultiChoiceConfigAttribute)configAttribute2).pendingValue());
                if (object == null) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408345, String.valueOf(configEntry.getDN()), String.valueOf(((MultiChoiceConfigAttribute)configAttribute2).pendingValue()));
                    object = WritabilityMode.DISABLED;
                }
                DirectoryServer.setWritabilityMode((WritabilityMode)((Object)object));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408345, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setWritabilityMode((WritabilityMode)((Object)object));
        }
        n = 3146202;
        configAttribute2 = new BooleanConfigAttribute("ds-cfg-bind-with-dn-requires-password", MessageHandler.getMessage(n), false);
        try {
            configAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
            if (configAttribute == null) {
                DirectoryServer.setBindWithDNRequiresPassword(true);
            } else {
                DirectoryServer.setBindWithDNRequiresPassword(configAttribute.activeValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408347, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setBindWithDNRequiresPassword(true);
        }
        n = 3146236;
        configAttribute = new DNConfigAttribute("ds-cfg-default-password-policy", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (dNConfigAttribute == null) {
                n = 3408381;
                String string = MessageHandler.getMessage(n, configEntry.getDN());
                throw new ConfigException(n, string);
            }
            DirectoryServer.setDefaultPasswordPolicyDN(dNConfigAttribute.activeValue());
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCoreConfig", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408382, String.valueOf(configEntry.getDN()), String.valueOf(exception));
            DirectoryServer.setBindWithDNRequiresPassword(true);
        }
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        ConfigAttribute configAttribute;
        ConfigAttribute configAttribute2;
        Object object;
        ConfigAttribute configAttribute3;
        ConfigAttribute configAttribute4;
        ConfigAttribute configAttribute5;
        ConfigAttribute configAttribute6;
        ConfigAttribute configAttribute7;
        Object object2;
        Object object3;
        ConfigAttribute configAttribute8;
        BooleanConfigAttribute booleanConfigAttribute;
        BooleanConfigAttribute booleanConfigAttribute2;
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        try {
            configEntry = DirectoryServer.getConfigHandler().getConfigEntry(this.configEntryDN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3342415, this.configEntryDN.toString(), String.valueOf(exception));
            return linkedList;
        }
        int n = 3145926;
        BooleanConfigAttribute booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-check-schema", MessageHandler.getMessage(n), false);
        try {
            booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
            if (booleanConfigAttribute2 == null) {
                booleanConfigAttribute3.setValue(DirectoryServer.checkSchema());
                booleanConfigAttribute2 = booleanConfigAttribute3;
            }
            linkedList.add(booleanConfigAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408071, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 0x30003C;
        booleanConfigAttribute2 = new BooleanConfigAttribute("ds-cfg-allow-attribute-name-exceptions", MessageHandler.getMessage(n), false);
        try {
            booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute2);
            if (booleanConfigAttribute == null) {
                booleanConfigAttribute2.setValue(DirectoryServer.allowAttributeNameExceptions());
                booleanConfigAttribute = booleanConfigAttribute2;
            }
            linkedList.add(booleanConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3407933, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3146153;
        booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-add-missing-rdn-attributes", MessageHandler.getMessage(n), false);
        try {
            configAttribute8 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (configAttribute8 == null) {
                booleanConfigAttribute.setValue(DirectoryServer.addMissingRDNAttributes());
                configAttribute8 = booleanConfigAttribute2;
            }
            linkedList.add(configAttribute8);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408298, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3146155;
        configAttribute8 = new IntegerConfigAttribute("ds-cfg-server-error-result-code", MessageHandler.getMessage(n), false, false, false, true, 1L, false, 0L);
        try {
            object3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute8);
            if (object3 == null) {
                int n2 = DirectoryServer.getServerErrorResultCode().getIntValue();
                ((IntegerConfigAttribute)configAttribute8).setValue(n2);
                object3 = configAttribute8;
            }
            linkedList.add((ConfigAttribute)object3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408300, this.configEntryDN.toString(), String.valueOf(exception));
        }
        object3 = new HashSet(3);
        ((HashSet)object3).add(AcceptRejectWarn.ACCEPT.toString());
        ((HashSet)object3).add(AcceptRejectWarn.REJECT.toString());
        ((HashSet)object3).add(AcceptRejectWarn.WARN.toString());
        n = 0x30003E;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-invalid-attribute-syntax-behavior", MessageHandler.getMessage(n), true, false, false, (Set<String>)object3);
        try {
            object2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (object2 == null) {
                multiChoiceConfigAttribute.setValue(String.valueOf((Object)DirectoryServer.getSyntaxEnforcementPolicy()));
                object2 = multiChoiceConfigAttribute;
            }
            linkedList.add((ConfigAttribute)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3407935, this.configEntryDN.toString(), String.valueOf(exception));
        }
        object2 = new HashSet(3);
        ((HashSet)object2).add(AcceptRejectWarn.ACCEPT.toString());
        ((HashSet)object2).add(AcceptRejectWarn.REJECT.toString());
        ((HashSet)object2).add(AcceptRejectWarn.WARN.toString());
        n = 3145924;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = new MultiChoiceConfigAttribute("ds-cfg-single-structural-objectclass-behavior", MessageHandler.getMessage(n), true, false, false, (Set<String>)object2);
        try {
            configAttribute7 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute2);
            if (configAttribute7 == null) {
                multiChoiceConfigAttribute2.setValue(String.valueOf((Object)DirectoryServer.getSingleStructuralObjectClassPolicy()));
                configAttribute7 = multiChoiceConfigAttribute2;
            }
            linkedList.add(configAttribute7);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408069, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3145848;
        configAttribute7 = new IntegerConfigAttribute("ds-cfg-max-allowed-client-connections", MessageHandler.getMessage(n), true, false, false, true, -1L, false, 0L);
        try {
            configAttribute6 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute7);
            if (configAttribute6 == null) {
                ((IntegerConfigAttribute)configAttribute7).setValue(DirectoryServer.getMaxAllowedConnections());
                configAttribute6 = configAttribute7;
            }
            linkedList.add(configAttribute6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3407993, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3145974;
        configAttribute6 = new BooleanConfigAttribute("ds-cfg-notify-abandoned-operations", MessageHandler.getMessage(n), false);
        try {
            configAttribute5 = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute6);
            if (configAttribute5 == null) {
                ((BooleanConfigAttribute)configAttribute6).setValue(DirectoryServer.notifyAbandonedOperations());
                configAttribute5 = configAttribute6;
            }
            linkedList.add(configAttribute5);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408119, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3146173;
        configAttribute5 = new DNConfigAttribute("ds-cfg-proxied-authorization-identity-mapper-dn", MessageHandler.getMessage(n), false, false, false);
        try {
            configAttribute4 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute5);
            if (configAttribute4 == null) {
                ((DNConfigAttribute)configAttribute5).setValue(DirectoryServer.getProxiedAuthorizationIdentityMapperDN());
                configAttribute4 = configAttribute5;
            }
            linkedList.add(configAttribute4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408318, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3146178;
        configAttribute4 = new IntegerConfigAttribute("ds-cfg-size-limit", MessageHandler.getMessage(n), false, false, false, true, 0L, true, Integer.MAX_VALUE);
        try {
            configAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute4);
            if (configAttribute3 == null) {
                ((IntegerConfigAttribute)configAttribute4).setValue(DirectoryServer.getSizeLimit());
                configAttribute3 = configAttribute4;
            }
            linkedList.add(configAttribute3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408323, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3146178;
        configAttribute3 = new IntegerWithUnitConfigAttribute("ds-cfg-time-limit", MessageHandler.getMessage(n), false, timeUnits, true, 0L, true, Integer.MAX_VALUE);
        try {
            object = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute3);
            if (object == null) {
                ((IntegerWithUnitConfigAttribute)configAttribute3).setValue(DirectoryServer.getTimeLimit(), "seconds");
                object = configAttribute3;
            }
            linkedList.add((ConfigAttribute)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408323, this.configEntryDN.toString(), String.valueOf(exception));
        }
        object = new HashSet(3);
        ((HashSet)object).add(WritabilityMode.ENABLED.toString());
        ((HashSet)object).add(WritabilityMode.DISABLED.toString());
        ((HashSet)object).add(WritabilityMode.INTERNAL_ONLY.toString());
        n = 3146200;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute3 = new MultiChoiceConfigAttribute("ds-cfg-writability-mode", MessageHandler.getMessage(n), true, false, false, (Set<String>)object);
        try {
            configAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute3);
            if (configAttribute2 == null) {
                multiChoiceConfigAttribute3.setValue(String.valueOf((Object)DirectoryServer.getWritabilityMode()));
                configAttribute2 = multiChoiceConfigAttribute3;
            }
            linkedList.add(configAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408345, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3146202;
        configAttribute2 = new BooleanConfigAttribute("ds-cfg-bind-with-dn-requires-password", MessageHandler.getMessage(n), false);
        try {
            configAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
            if (configAttribute == null) {
                ((BooleanConfigAttribute)configAttribute2).setValue(DirectoryServer.bindWithDNRequiresPassword());
                configAttribute = configAttribute2;
            }
            linkedList.add(configAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408347, this.configEntryDN.toString(), String.valueOf(exception));
        }
        n = 3146236;
        configAttribute = new DNConfigAttribute("ds-cfg-default-password-policy", MessageHandler.getMessage(n), true, false, false);
        try {
            ConfigAttribute configAttribute9 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (configAttribute9 == null) {
                ((DNConfigAttribute)configAttribute).setValue(DirectoryServer.getDefaultPasswordPolicyDN());
                configAttribute9 = configAttribute;
            }
            linkedList.add(configAttribute9);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getConfigurationAttributes", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3408382, this.configEntryDN.toString(), String.valueOf(exception));
        }
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        ConfigAttribute configAttribute;
        ConfigAttribute configAttribute2;
        Object object;
        HashSet<String> hashSet;
        ConfigAttribute configAttribute3;
        ConfigAttribute configAttribute4;
        ConfigAttribute configAttribute5;
        ConfigAttribute configAttribute6;
        Object object2;
        Object object3;
        ConfigAttribute configAttribute7;
        BooleanConfigAttribute booleanConfigAttribute;
        BooleanConfigAttribute booleanConfigAttribute2;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), String.valueOf(list)));
        boolean bl = true;
        int n = 3145926;
        BooleanConfigAttribute booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-check-schema", MessageHandler.getMessage(n), false);
        try {
            booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408071;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 0x30003C;
        booleanConfigAttribute2 = new BooleanConfigAttribute("ds-cfg-allow-attribute-name-exceptions", MessageHandler.getMessage(n), false);
        try {
            booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3407933;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3146153;
        booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-add-missing-rdn-attributes", MessageHandler.getMessage(n), false);
        try {
            configAttribute7 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408298;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3146155;
        configAttribute7 = new IntegerConfigAttribute("ds-cfg-server-error-result-code", MessageHandler.getMessage(n), false, false, false, true, 1L, false, 0L);
        try {
            object3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute7);
            if (object3 != null) {
                ((IntegerConfigAttribute)object3).pendingIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408300;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        object3 = new HashSet(3);
        ((HashSet)object3).add(AcceptRejectWarn.ACCEPT.toString());
        ((HashSet)object3).add(AcceptRejectWarn.REJECT.toString());
        ((HashSet)object3).add(AcceptRejectWarn.WARN.toString());
        n = 0x30003E;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-invalid-attribute-syntax-behavior", MessageHandler.getMessage(n), true, false, false, (Set<String>)object3);
        try {
            object2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3407935;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        object2 = new HashSet(3);
        ((HashSet)object2).add(AcceptRejectWarn.ACCEPT.toString());
        ((HashSet)object2).add(AcceptRejectWarn.REJECT.toString());
        ((HashSet)object2).add(AcceptRejectWarn.WARN.toString());
        n = 3145924;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = new MultiChoiceConfigAttribute("ds-cfg-single-structural-objectclass-behavior", MessageHandler.getMessage(n), true, false, false, (Set<String>)object2);
        try {
            configAttribute6 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408069;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3145848;
        configAttribute6 = new IntegerConfigAttribute("ds-cfg-max-allowed-client-connections", MessageHandler.getMessage(n), true, false, false, true, -1L, false, 0L);
        try {
            configAttribute5 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3407993;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3145974;
        configAttribute5 = new BooleanConfigAttribute("ds-cfg-notify-abandoned-operations", MessageHandler.getMessage(n), false);
        try {
            configAttribute4 = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute5);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408119;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3146173;
        configAttribute4 = new DNConfigAttribute("ds-cfg-proxied-authorization-identity-mapper-dn", MessageHandler.getMessage(n), false, false, false);
        try {
            configAttribute3 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute4);
            if (configAttribute3 != null && (hashSet = DirectoryServer.getIdentityMapper((DN)(object = configAttribute3.pendingValue()))) == null) {
                n = 3408319;
                list.add(MessageHandler.getMessage(n, String.valueOf(object), String.valueOf(this.configEntryDN)));
                bl = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408318;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3146178;
        configAttribute3 = new IntegerConfigAttribute("ds-cfg-size-limit", MessageHandler.getMessage(n), false, false, false, true, 0L, true, Integer.MAX_VALUE);
        try {
            object = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408323;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3146178;
        object = new IntegerWithUnitConfigAttribute("ds-cfg-time-limit", MessageHandler.getMessage(n), false, timeUnits, true, 0L, true, Integer.MAX_VALUE);
        try {
            hashSet = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408323;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        hashSet = new HashSet<String>(3);
        hashSet.add(WritabilityMode.ENABLED.toString());
        hashSet.add(WritabilityMode.DISABLED.toString());
        hashSet.add(WritabilityMode.INTERNAL_ONLY.toString());
        n = 3146200;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute3 = new MultiChoiceConfigAttribute("ds-cfg-writability-mode", MessageHandler.getMessage(n), true, false, false, hashSet);
        try {
            configAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408345;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3146202;
        configAttribute2 = new BooleanConfigAttribute("ds-cfg-bind-with-dn-requires-password", MessageHandler.getMessage(n), false);
        try {
            configAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408347;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        n = 3146236;
        configAttribute = new DNConfigAttribute("ds-cfg-default-password-policy", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (dNConfigAttribute == null) {
                n = 3408381;
                list.add(MessageHandler.getMessage(n, configEntry.getDN()));
                bl = false;
            } else {
                PasswordPolicy passwordPolicy = DirectoryServer.getPasswordPolicy(dNConfigAttribute.pendingValue());
                if (passwordPolicy == null) {
                    n = 3408383;
                    list.add(MessageHandler.getMessage(n, String.valueOf(dNConfigAttribute.pendingValue())));
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 3408382;
            list.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl3 = true;
        int n = 3145926;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-check-schema", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 != null) {
                bl3 = booleanConfigAttribute2.pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            arrayList.add(MessageHandler.getMessage(3408071, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        boolean bl4 = false;
        n = 0x30003C;
        BooleanConfigAttribute booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-allow-attribute-name-exceptions", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute4 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
            if (booleanConfigAttribute4 != null) {
                bl4 = booleanConfigAttribute4.pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            arrayList.add(MessageHandler.getMessage(3407933, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        boolean bl5 = false;
        n = 3146153;
        BooleanConfigAttribute booleanConfigAttribute5 = new BooleanConfigAttribute("ds-cfg-add-missing-rdn-attributes", MessageHandler.getMessage(n), false);
        try {
            object6 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute5);
            if (object6 != null) {
                bl5 = object6.pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            arrayList.add(MessageHandler.getMessage(3408298, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        object6 = ResultCode.OTHER;
        n = 3146155;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-server-error-result-code", MessageHandler.getMessage(n), false, false, false, true, 1L, false, 0L);
        try {
            object5 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (object5 == null) {
                DirectoryServer.setServerErrorResultCode((ResultCode)((Object)object6));
            } else {
                int n2 = object5.pendingIntValue();
                object6 = ResultCode.valueOf(n2);
                DirectoryServer.setServerErrorResultCode((ResultCode)((Object)object6));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            arrayList.add(MessageHandler.getMessage(3408300, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        object5 = AcceptRejectWarn.WARN;
        HashSet<String> hashSet = new HashSet<String>(3);
        hashSet.add(AcceptRejectWarn.ACCEPT.toString());
        hashSet.add(AcceptRejectWarn.REJECT.toString());
        hashSet.add(AcceptRejectWarn.WARN.toString());
        n = 0x30003E;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-invalid-attribute-syntax-behavior", MessageHandler.getMessage(n), true, false, false, hashSet);
        try {
            object4 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (object4 != null && (object5 = AcceptRejectWarn.policyForName(object4.pendingValue())) == null) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                arrayList.add(MessageHandler.getMessage(3407935, String.valueOf(configEntry.getDN()), String.valueOf(object4.pendingValue())));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            arrayList.add(MessageHandler.getMessage(3407935, String.valueOf(configEntry.getDN()), String.valueOf(exception)));
        }
        object4 = AcceptRejectWarn.WARN;
        HashSet<String> hashSet2 = new HashSet<String>(3);
        hashSet2.add(AcceptRejectWarn.ACCEPT.toString());
        hashSet2.add(AcceptRejectWarn.REJECT.toString());
        hashSet2.add(AcceptRejectWarn.WARN.toString());
        n = 3145924;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = new MultiChoiceConfigAttribute("ds-cfg-single-structural-objectclass-behavior", MessageHandler.getMessage(n), true, false, false, hashSet2);
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute3 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute2);
            if (multiChoiceConfigAttribute3 != null && (object4 = AcceptRejectWarn.policyForName(multiChoiceConfigAttribute3.pendingValue())) == null) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                arrayList.add(MessageHandler.getMessage(3408069, String.valueOf(configEntry.getDN()), String.valueOf(multiChoiceConfigAttribute3.pendingValue())));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            arrayList.add(MessageHandler.getMessage(3408069, String.valueOf(configEntry.getDN()), String.valueOf(exception)));
        }
        long l = -1L;
        n = 3145848;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-max-allowed-client-connections", MessageHandler.getMessage(n), true, false, false, true, -1L, false, 0L);
        try {
            IntegerConfigAttribute integerConfigAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
            if (integerConfigAttribute3 != null) {
                l = integerConfigAttribute3.activeValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            arrayList.add(MessageHandler.getMessage(3407993, configEntry.getDN(), String.valueOf(exception)));
        }
        boolean bl6 = false;
        n = 3145974;
        BooleanConfigAttribute booleanConfigAttribute6 = new BooleanConfigAttribute("ds-cfg-notify-abandoned-operations", MessageHandler.getMessage(n), false);
        try {
            object3 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute6);
            if (object3 != null) {
                bl6 = ((BooleanConfigAttribute)object3).pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            arrayList.add(MessageHandler.getMessage(3408119, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        object3 = DirectoryServer.getProxiedAuthorizationIdentityMapperDN();
        n = 3146173;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-proxied-authorization-identity-mapper-dn", MessageHandler.getMessage(n), false, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            object3 = dNConfigAttribute2 == null ? null : dNConfigAttribute2.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n = 3408318;
            arrayList.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        int n3 = 1000;
        n = 3146178;
        IntegerConfigAttribute integerConfigAttribute4 = new IntegerConfigAttribute("ds-cfg-size-limit", MessageHandler.getMessage(n), false, false, false, true, 0L, true, Integer.MAX_VALUE);
        try {
            IntegerConfigAttribute integerConfigAttribute5 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute4);
            if (integerConfigAttribute5 != null) {
                n3 = integerConfigAttribute5.pendingIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n = 3408323;
            arrayList.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        int n4 = 60;
        n = 3146178;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-time-limit", MessageHandler.getMessage(n), false, timeUnits, true, 0L, true, Integer.MAX_VALUE);
        try {
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
            if (integerWithUnitConfigAttribute2 != null) {
                n4 = (int)integerWithUnitConfigAttribute2.pendingCalculatedValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n = 3408323;
            arrayList.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        int n5 = 5000;
        n = 3146289;
        IntegerConfigAttribute integerConfigAttribute6 = new IntegerConfigAttribute("ds-cfg-lookthrough-limit", MessageHandler.getMessage(n), false, false, false, true, -1L, true, Integer.MAX_VALUE);
        try {
            object2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute6);
            if (object2 != null) {
                n5 = ((IntegerConfigAttribute)object2).pendingIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n = 3408434;
            arrayList.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        object2 = new HashSet(3);
        ((HashSet)object2).add(WritabilityMode.ENABLED.toString());
        ((HashSet)object2).add(WritabilityMode.DISABLED.toString());
        ((HashSet)object2).add(WritabilityMode.INTERNAL_ONLY.toString());
        WritabilityMode writabilityMode = WritabilityMode.ENABLED;
        n = 3146200;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute4 = new MultiChoiceConfigAttribute("ds-cfg-writability-mode", MessageHandler.getMessage(n), true, false, false, (Set<String>)object2);
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute5 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute4);
            if (multiChoiceConfigAttribute5 != null && (writabilityMode = WritabilityMode.modeForName(multiChoiceConfigAttribute5.pendingValue())) == null) {
                n = 3408345;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), multiChoiceConfigAttribute5.pendingValue()));
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n = 3408345;
            arrayList.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        boolean bl7 = true;
        n = 3146202;
        BooleanConfigAttribute booleanConfigAttribute7 = new BooleanConfigAttribute("ds-cfg-bind-with-dn-requires-password", MessageHandler.getMessage(n), false);
        try {
            object = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute7);
            if (object != null) {
                bl7 = ((BooleanConfigAttribute)object).pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n = 3408347;
            arrayList.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        object = null;
        n = 3146236;
        DNConfigAttribute dNConfigAttribute3 = new DNConfigAttribute("ds-cfg-default-password-policy", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute4 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute3);
            if (dNConfigAttribute4 == null) {
                n = 3408381;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                }
            } else {
                object = dNConfigAttribute4.pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n = 3408382;
            arrayList.add(MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            DirectoryServer.setCheckSchema(bl3);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-check-schema", String.valueOf(bl3), this.configEntryDN.toString()));
            }
            DirectoryServer.setAllowAttributeNameExceptions(bl4);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-allow-attribute-name-exceptions", String.valueOf(bl4), this.configEntryDN.toString()));
            }
            DirectoryServer.setAddMissingRDNAttributes(bl5);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-add-missing-rdn-attributes", String.valueOf(bl5), this.configEntryDN.toString()));
            }
            DirectoryServer.setServerErrorResultCode((ResultCode)((Object)object6));
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-server-error-result-code", String.valueOf(object6), this.configEntryDN.toString()));
            }
            DirectoryServer.setSyntaxEnforcementPolicy((AcceptRejectWarn)((Object)object5));
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-invalid-attribute-syntax-behavior", String.valueOf(object5), this.configEntryDN.toString()));
            }
            DirectoryServer.setSingleStructuralObjectClassPolicy((AcceptRejectWarn)((Object)object4));
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-single-structural-objectclass-behavior", String.valueOf(object4), this.configEntryDN.toString()));
            }
            DirectoryServer.setMaxAllowedConnections(l);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-max-allowed-client-connections", String.valueOf(l), this.configEntryDN.toString()));
            }
            DirectoryServer.setNotifyAbandonedOperations(bl6);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-notify-abandoned-operations", String.valueOf(bl6), this.configEntryDN.toString()));
            }
            DirectoryServer.setProxiedAuthorizationIdentityMapperDN((DN)object3);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-proxied-authorization-identity-mapper-dn", String.valueOf(object3), this.configEntryDN.toString()));
            }
            DirectoryServer.setSizeLimit(n3);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-size-limit", String.valueOf(n3), this.configEntryDN.toString()));
            }
            DirectoryServer.setTimeLimit(n4);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-time-limit", String.valueOf(n4), this.configEntryDN.toString()));
            }
            DirectoryServer.setLookthroughLimit(n5);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-lookthrough-limit", String.valueOf(n5), this.configEntryDN.toString()));
            }
            DirectoryServer.setWritabilityMode(writabilityMode);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-writability-mode", String.valueOf((Object)writabilityMode), this.configEntryDN.toString()));
            }
            DirectoryServer.setBindWithDNRequiresPassword(bl7);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-bind-with-dn-requires-password", String.valueOf(bl7), this.configEntryDN.toString()));
            }
            DirectoryServer.setDefaultPasswordPolicyDN((DN)object);
            if (bl) {
                arrayList.add(MessageHandler.getMessage(0x300050, "ds-cfg-default-password-policy", String.valueOf(object), this.configEntryDN.toString()));
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    static {
        timeUnits.put("s", 1.0);
        timeUnits.put("seconds", 1.0);
        timeUnits.put("m", 60.0);
        timeUnits.put("minutes", 60.0);
        timeUnits.put("h", 3600.0);
        timeUnits.put("hours", 3600.0);
        timeUnits.put("d", 86400.0);
        timeUnits.put("days", 86400.0);
        timeUnits.put("w", 604800.0);
        timeUnits.put("weeks", 604800.0);
    }
}

