/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryException
extends Exception {
    private static final String CLASS_NAME = "org.opends.server.core.DirectoryException";
    private static final long serialVersionUID = 2615453139798417203L;
    private DN matchedDN;
    private int errorMessageID;
    private List<String> referralURLs;
    private ResultCode resultCode;
    private String errorMessage;

    public DirectoryException(ResultCode resultCode, String string, int n) {
        super(string);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)resultCode), String.valueOf(string), String.valueOf(n)));
        this.resultCode = resultCode;
        this.errorMessage = string;
        this.errorMessageID = n;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, String string, int n, Throwable throwable) {
        super(string, throwable);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)resultCode), String.valueOf(string), String.valueOf(n), String.valueOf(throwable)));
        this.resultCode = resultCode;
        this.errorMessage = string;
        this.errorMessageID = n;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, String string, int n, DN dN, Throwable throwable) {
        super(string, throwable);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)resultCode), String.valueOf(string), String.valueOf(n), String.valueOf(dN), String.valueOf(throwable)));
        this.resultCode = resultCode;
        this.errorMessage = string;
        this.errorMessageID = n;
        this.matchedDN = dN;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, String string, int n, DN dN, List<String> list, Throwable throwable) {
        super(string, throwable);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)resultCode), String.valueOf(string), String.valueOf(n), String.valueOf(dN), String.valueOf(list), String.valueOf(throwable)));
        this.resultCode = resultCode;
        this.errorMessage = string;
        this.errorMessageID = n;
        this.matchedDN = dN;
        this.referralURLs = list;
    }

    public ResultCode getResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getResultCode", new String[0]));
        return this.resultCode;
    }

    public String getErrorMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorMessage", new String[0]));
        return this.errorMessage;
    }

    public int getErrorMessageID() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorMessageID", new String[0]));
        return this.errorMessageID;
    }

    public DN getMatchedDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchedDN", new String[0]));
        return this.matchedDN;
    }

    public List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }
}

