/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.Backend;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;

public class LockFileManager {
    private static final String CLASS_NAME = "org.opends.server.core.LockFileManager";
    private static HashMap<String, FileLock> exclusiveLocks = new HashMap();
    private static HashMap<String, FileLock> sharedLocks = new HashMap();
    private static HashMap<String, Integer> sharedLockReferences = new HashMap();
    private static ReentrantLock mapLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquireSharedLock(String string, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "acquireSharedLock", String.valueOf(string)));
        mapLock.lock();
        try {
            FileChannel fileChannel;
            AutoCloseable autoCloseable;
            if (exclusiveLocks.containsKey(string)) {
                int n = 196919;
                stringBuilder.append(MessageHandler.getMessage(n, string));
                boolean bl = false;
                return bl;
            }
            FileLock fileLock = sharedLocks.get(string);
            if (fileLock != null) {
                int n = sharedLockReferences.get(string);
                sharedLockReferences.put(string, ++n);
                boolean bl = true;
                return bl;
            }
            File file = StaticUtils.getFileForPath(string);
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "acquireSharedLock", exception));
                int n = 196920;
                stringBuilder.append(MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            try {
                autoCloseable = new RandomAccessFile(string, "r");
                fileChannel = autoCloseable.getChannel();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "acquireSharedLock", exception));
                int n = 196921;
                stringBuilder.append(MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            try {
                autoCloseable = fileChannel.tryLock(0L, Long.MAX_VALUE, true);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "acquireSharedLock", exception));
                int n = 196922;
                stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            if (autoCloseable == null) {
                int n = 196923;
                stringBuilder.append(MessageHandler.getMessage(n, string));
                boolean bl = false;
                return bl;
            }
            sharedLocks.put(string, (FileLock)autoCloseable);
            sharedLockReferences.put(string, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            mapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquireExclusiveLock(String string, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "acquireExclusiveLock", String.valueOf(string)));
        mapLock.lock();
        try {
            FileChannel fileChannel;
            AutoCloseable autoCloseable;
            if (exclusiveLocks.containsKey(string)) {
                int n = 196924;
                stringBuilder.append(MessageHandler.getMessage(n, string));
                boolean bl = false;
                return bl;
            }
            if (sharedLocks.containsKey(string)) {
                int n = 196925;
                stringBuilder.append(MessageHandler.getMessage(n, string));
                boolean bl = false;
                return bl;
            }
            File file = StaticUtils.getFileForPath(string);
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "acquireExclusiveLock", exception));
                int n = 196926;
                stringBuilder.append(MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            try {
                autoCloseable = new RandomAccessFile(string, "rw");
                fileChannel = autoCloseable.getChannel();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "acquireExclusiveLock", exception));
                int n = 196927;
                stringBuilder.append(MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            try {
                autoCloseable = fileChannel.tryLock(0L, Long.MAX_VALUE, false);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "acquireExclusiveLock", exception));
                int n = 196928;
                stringBuilder.append(MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            if (autoCloseable == null) {
                int n = 196929;
                stringBuilder.append(MessageHandler.getMessage(n, string));
                boolean bl = false;
                return bl;
            }
            exclusiveLocks.put(string, (FileLock)autoCloseable);
            boolean bl = true;
            return bl;
        }
        finally {
            mapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseLock(String string, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "releaseLock", String.valueOf(string)));
        mapLock.lock();
        try {
            FileLock fileLock = exclusiveLocks.remove(string);
            if (fileLock != null) {
                block23: {
                    try {
                        fileLock.release();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "releaseLock", exception));
                        int n = 196930;
                        stringBuilder.append(MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception)));
                        boolean bl = false;
                        mapLock.unlock();
                        return bl;
                    }
                    try {
                        fileLock.channel().close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "releaseLock", exception)) break block23;
                        throw new AssertionError();
                    }
                }
                boolean bl = true;
                return bl;
            }
            fileLock = sharedLocks.get(string);
            if (fileLock != null) {
                int n = sharedLockReferences.get(string);
                if (--n <= 0) {
                    sharedLocks.remove(string);
                    sharedLockReferences.remove(string);
                    try {
                        fileLock.release();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "releaseLock", exception));
                        int n2 = 196931;
                        stringBuilder.append(MessageHandler.getMessage(n2, string, StaticUtils.stackTraceToSingleLineString(exception)));
                        boolean bl = false;
                        mapLock.unlock();
                        return bl;
                    }
                    try {
                        fileLock.channel().close();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "releaseLock", exception));
                    }
                } else {
                    sharedLockReferences.put(string, n);
                }
                boolean bl = true;
                return bl;
            }
            int n = 196932;
            stringBuilder.append(MessageHandler.getMessage(n, string));
            boolean bl = false;
            return bl;
        }
        finally {
            mapLock.unlock();
        }
    }

    public static String getServerLockFileName() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerLockFileName", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DirectoryServer.getServerRoot());
        stringBuilder.append(File.separator);
        stringBuilder.append("locks");
        stringBuilder.append(File.separator);
        stringBuilder.append("server");
        stringBuilder.append(".lock");
        return stringBuilder.toString();
    }

    public static String getBackendLockFileName(Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "getBackendLockFileName", String.valueOf(backend)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DirectoryServer.getServerRoot());
        stringBuilder.append(File.separator);
        stringBuilder.append("locks");
        stringBuilder.append(File.separator);
        stringBuilder.append("backend-");
        stringBuilder.append(backend.getBackendID());
        stringBuilder.append(".lock");
        return stringBuilder.toString();
    }
}

