/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.util.StaticUtils;

public class LockManager {
    private static final String CLASS_NAME = "org.opends.server.core.LockManager";
    public static final int NUM_GLOBAL_DN_LOCKS = 10 * Runtime.getRuntime().availableProcessors();
    public static final int DN_TABLE_INITIAL_SIZE = 50;
    public static final float DN_TABLE_LOAD_FACTOR = 0.75f;
    public static final long DEFAULT_TIMEOUT = 3000L;
    private static ReentrantLock[] globalDNLocks = new ReentrantLock[NUM_GLOBAL_DN_LOCKS];
    private static ConcurrentHashMap<DN, ReentrantReadWriteLock> entryLocks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock tryLockRead(DN dN) {
        ReentrantLock reentrantLock;
        assert (Debug.debugEnter(CLASS_NAME, "tryLockRead", String.valueOf(dN)));
        int n = dN.hashCode() & Integer.MAX_VALUE;
        try {
            reentrantLock = globalDNLocks[n % NUM_GLOBAL_DN_LOCKS];
            if (!reentrantLock.tryLock()) {
                return null;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockRead", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockRead", "Unexpected exception while trying to obtain the global lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            return null;
        }
        try {
            ReentrantReadWriteLock reentrantReadWriteLock = entryLocks.get(dN);
            if (reentrantReadWriteLock == null) {
                reentrantReadWriteLock = new ReentrantReadWriteLock();
                if (reentrantReadWriteLock.readLock().tryLock()) {
                    entryLocks.put(dN, reentrantReadWriteLock);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    return readLock;
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockRead", "Unable to acquire read lock on newly-created lock for entry " + dN.toString()));
                Lock lock = null;
                return lock;
            }
            if (reentrantReadWriteLock.readLock().tryLock()) {
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                return readLock;
            }
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "lockRead", "Unable to acquire a read lock for entry " + dN.toString() + " that was already " + "present in the lock table."));
            Lock lock = null;
            return lock;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockRead", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockRead", "Unexpected exception while trying to obtain a read lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            Lock lock = null;
            return lock;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static Lock lockRead(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "lockRead", String.valueOf(dN)));
        return LockManager.lockRead(dN, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock lockRead(DN dN, long l) {
        ReentrantLock reentrantLock;
        assert (Debug.debugEnter(CLASS_NAME, "lockRead", String.valueOf(dN), String.valueOf(l)));
        int n = dN.hashCode() & Integer.MAX_VALUE;
        try {
            reentrantLock = globalDNLocks[n % NUM_GLOBAL_DN_LOCKS];
            if (!reentrantLock.tryLock(l, TimeUnit.MILLISECONDS)) {
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            assert (Debug.debugException(CLASS_NAME, "lockRead", interruptedException));
            return null;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockRead", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockRead", "Unexpected exception while trying to obtain the global lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            return null;
        }
        try {
            ReentrantReadWriteLock reentrantReadWriteLock = entryLocks.get(dN);
            if (reentrantReadWriteLock == null) {
                reentrantReadWriteLock = new ReentrantReadWriteLock();
                if (reentrantReadWriteLock.readLock().tryLock(l, TimeUnit.MILLISECONDS)) {
                    entryLocks.put(dN, reentrantReadWriteLock);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    return readLock;
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockRead", "Unable to acquire read lock on newly-created lock for entry " + dN.toString()));
                Lock lock = null;
                return lock;
            }
            if (reentrantReadWriteLock.readLock().tryLock(l, TimeUnit.MILLISECONDS)) {
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                return readLock;
            }
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "lockRead", "Unable to acquire a read lock for entry " + dN.toString() + " that was already " + "present in the lock table."));
            Lock lock = null;
            return lock;
        }
        catch (InterruptedException interruptedException) {
            assert (Debug.debugException(CLASS_NAME, "lockRead", interruptedException));
            Lock lock = null;
            return lock;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockRead", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockRead", "Unexpected exception while trying to obtain a read lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            Lock lock = null;
            return lock;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock tryLockWrite(DN dN) {
        ReentrantLock reentrantLock;
        assert (Debug.debugEnter(CLASS_NAME, "lockWrite", String.valueOf(dN)));
        int n = dN.hashCode() & Integer.MAX_VALUE;
        try {
            reentrantLock = globalDNLocks[n % NUM_GLOBAL_DN_LOCKS];
            if (!reentrantLock.tryLock()) {
                return null;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockWrite", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockWrite", "Unexpected exception while trying to obtain the global lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            return null;
        }
        try {
            ReentrantReadWriteLock reentrantReadWriteLock = entryLocks.get(dN);
            if (reentrantReadWriteLock == null) {
                reentrantReadWriteLock = new ReentrantReadWriteLock();
                if (reentrantReadWriteLock.writeLock().tryLock()) {
                    entryLocks.put(dN, reentrantReadWriteLock);
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    return writeLock;
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockWrite", "Unable to acquire write lock on newly-created lock for entry " + dN.toString()));
                Lock lock = null;
                return lock;
            }
            if (reentrantReadWriteLock.writeLock().tryLock()) {
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                return writeLock;
            }
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "lockWrite", "Unable to acquire the write lock for entry " + dN.toString() + " that was already " + "present in the lock table."));
            Lock lock = null;
            return lock;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockWrite", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockWrite", "Unexpected exception while trying to obtain the write lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            Lock lock = null;
            return lock;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static Lock lockWrite(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "lockRead", String.valueOf(dN)));
        return LockManager.lockWrite(dN, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock lockWrite(DN dN, long l) {
        ReentrantLock reentrantLock;
        assert (Debug.debugEnter(CLASS_NAME, "lockWrite", String.valueOf(dN), String.valueOf(l)));
        int n = dN.hashCode() & Integer.MAX_VALUE;
        try {
            reentrantLock = globalDNLocks[n % NUM_GLOBAL_DN_LOCKS];
            if (!reentrantLock.tryLock(l, TimeUnit.MILLISECONDS)) {
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            assert (Debug.debugException(CLASS_NAME, "lockWrite", interruptedException));
            return null;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockWrite", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockWrite", "Unexpected exception while trying to obtain the global lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            return null;
        }
        try {
            ReentrantReadWriteLock reentrantReadWriteLock = entryLocks.get(dN);
            if (reentrantReadWriteLock == null) {
                reentrantReadWriteLock = new ReentrantReadWriteLock();
                if (reentrantReadWriteLock.writeLock().tryLock(l, TimeUnit.MILLISECONDS)) {
                    entryLocks.put(dN, reentrantReadWriteLock);
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    return writeLock;
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockWrite", "Unable to acquire write lock on newly-created lock for entry " + dN.toString()));
                Lock lock = null;
                return lock;
            }
            if (reentrantReadWriteLock.writeLock().tryLock(l, TimeUnit.MILLISECONDS)) {
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                return writeLock;
            }
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.WARNING, CLASS_NAME, "lockWrite", "Unable to acquire the write lock for entry " + dN.toString() + " that was already " + "present in the lock table."));
            Lock lock = null;
            return lock;
        }
        catch (InterruptedException interruptedException) {
            assert (Debug.debugException(CLASS_NAME, "lockWrite", interruptedException));
            Lock lock = null;
            return lock;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lockWrite", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "lockWrite", "Unexpected exception while trying to obtain the write lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            Lock lock = null;
            return lock;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlock(DN dN, Lock lock) {
        ReentrantLock reentrantLock;
        block17: {
            assert (Debug.debugEnter(CLASS_NAME, "unlock", String.valueOf(dN)));
            try {
                lock.unlock();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "unlock", exception)) break block17;
                throw new AssertionError();
            }
        }
        int n = dN.hashCode() & Integer.MAX_VALUE;
        try {
            reentrantLock = globalDNLocks[n % NUM_GLOBAL_DN_LOCKS];
            reentrantLock.lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            assert (Debug.debugException(CLASS_NAME, "unlock", interruptedException));
            return;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "unlock", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "unlock", "Unexpected exception while trying to obtain the global lock for entry " + dN.toString() + ":  " + StaticUtils.stackTraceToSingleLineString(exception)));
            return;
        }
        try {
            ReentrantReadWriteLock reentrantReadWriteLock = entryLocks.get(dN);
            if (reentrantReadWriteLock != null && reentrantReadWriteLock.getReadLockCount() == 0 && !reentrantReadWriteLock.isWriteLocked()) {
                entryLocks.remove(dN);
            }
            return;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "unlock", exception));
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "unlock", "Unexpected exception while trying to determine whether the lock for entry " + dN.toString() + " can be removed:  " + StaticUtils.stackTraceToSingleLineString(exception)));
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static ReentrantReadWriteLock destroyLock(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "destroyLock", String.valueOf(dN)));
        return entryLocks.remove(dN);
    }

    public static int lockTableSize() {
        assert (Debug.debugEnter(CLASS_NAME, "lockTableSize", new String[0]));
        return entryLocks.size();
    }

    static {
        for (int i = 0; i < NUM_GLOBAL_DN_LOCKS; ++i) {
            LockManager.globalDNLocks[i] = new ReentrantLock();
        }
        entryLocks = new ConcurrentHashMap(50, 0.75f, NUM_GLOBAL_DN_LOCKS);
    }
}

