/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RDN;
import org.opends.server.types.WritabilityMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDNOperation
extends Operation {
    private static final String CLASS_NAME = "org.opends.server.core.ModifyDNOperation";
    private boolean deleteOldRDN;
    private ByteString rawEntryDN;
    private ByteString rawNewRDN;
    private ByteString rawNewSuperior;
    private CancelRequest cancelRequest;
    private DN entryDN;
    private DN newSuperior;
    private Entry currentEntry;
    private Entry newEntry;
    private List<Control> responseControls;
    private List<Modification> modifications;
    private long changeNumber;
    private long processingStartTime;
    private long processingStopTime;
    private RDN newRDN;

    public ModifyDNOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, ByteString byteString2, boolean bl, ByteString byteString3) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf(byteString2), String.valueOf(bl), String.valueOf(byteString3)));
        this.rawEntryDN = byteString;
        this.rawNewRDN = byteString2;
        this.deleteOldRDN = bl;
        this.rawNewSuperior = byteString3;
        this.entryDN = null;
        this.newRDN = null;
        this.newSuperior = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.modifications = null;
        this.changeNumber = -1L;
        this.currentEntry = null;
        this.newEntry = null;
    }

    public ModifyDNOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, RDN rDN, boolean bl, DN dN2) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(dN), String.valueOf(rDN), String.valueOf(bl), String.valueOf(dN2)));
        this.entryDN = dN;
        this.newRDN = rDN;
        this.deleteOldRDN = bl;
        this.newSuperior = dN2;
        this.rawEntryDN = new ASN1OctetString(dN.toString());
        this.rawNewRDN = new ASN1OctetString(rDN.toString());
        this.rawNewSuperior = dN2 == null ? null : new ASN1OctetString(dN2.toString());
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.modifications = null;
        this.changeNumber = -1L;
        this.currentEntry = null;
        this.newEntry = null;
    }

    public ByteString getRawEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawEntryDN", new String[0]));
        return this.rawEntryDN;
    }

    public void setRawEntryDN(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawEntryDN", new String[0]));
        this.rawEntryDN = byteString;
        this.entryDN = null;
    }

    public DN getEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryDN", new String[0]));
        return this.entryDN;
    }

    public void setEntryDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setEntryDN", String.valueOf(dN)));
        this.entryDN = dN;
    }

    public ByteString getRawNewRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawNewRDN", new String[0]));
        return this.rawNewRDN;
    }

    public void setRawNewRDN(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawNewRDN", String.valueOf(byteString)));
        this.rawNewRDN = byteString;
        this.newRDN = null;
    }

    public RDN getNewRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getNewRDN", new String[0]));
        return this.newRDN;
    }

    public void setNewRDN(RDN rDN) {
        assert (Debug.debugEnter(CLASS_NAME, "setNewRDN", String.valueOf(rDN)));
        this.newRDN = rDN;
    }

    public boolean deleteOldRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "deleteOldRDN", new String[0]));
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setDeleteOldRDN", String.valueOf(bl)));
        this.deleteOldRDN = bl;
    }

    public ByteString getRawNewSuperior() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawNewSuperior", new String[0]));
        return this.rawNewSuperior;
    }

    public void setRawNewSuperior(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawNewSuperior", String.valueOf(byteString)));
        this.rawNewSuperior = byteString;
        this.newSuperior = null;
    }

    public DN getNewSuperior() {
        assert (Debug.debugEnter(CLASS_NAME, "getNewSuperior", new String[0]));
        return this.newSuperior;
    }

    public void setNewSuperior(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setNewSuperior", String.valueOf(dN)));
        this.newSuperior = dN;
    }

    public List<Modification> getModifications() {
        assert (Debug.debugEnter(CLASS_NAME, "getModifications", new String[0]));
        return this.modifications;
    }

    public Entry getOriginalEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getOriginalEntry", new String[0]));
        return this.currentEntry;
    }

    public Entry getUpdatedEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpdatedEntry", new String[0]));
        return this.newEntry;
    }

    public long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    public long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    public long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    public long getChangeNumber() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeNumber", new String[0]));
        return this.changeNumber;
    }

    public void setChangeNumber(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setChangeNumber", String.valueOf(l)));
        this.changeNumber = l;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.MODIFY_DN;
    }

    @Override
    public String[][] getRequestLogElements() {
        String string = this.rawNewSuperior == null ? null : this.rawNewSuperior.stringValue();
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}, {"newRDN", String.valueOf(this.newRDN)}, {"deleteOldRDN", String.valueOf(this.deleteOldRDN)}, {"newSuperior", string}};
    }

    @Override
    public String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"processingTime", charSequence}};
    }

    @Override
    public List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 248[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long l = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < l) {
            block5: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cancel", exception)) break block5;
                    throw new AssertionError();
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return this.cancelRequest;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ModifyDNOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", dn=");
        stringBuilder.append(this.rawEntryDN);
        stringBuilder.append(", newRDN=");
        stringBuilder.append(this.rawNewRDN);
        stringBuilder.append(", deleteOldRDN=");
        stringBuilder.append(this.deleteOldRDN);
        if (this.rawNewSuperior != null) {
            stringBuilder.append(", newSuperior=");
            stringBuilder.append(this.rawNewSuperior);
        }
        stringBuilder.append(")");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$types$ModificationType;
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$types$WritabilityMode;

        static {
            $SwitchMap$org$opends$server$types$WritabilityMode = new int[WritabilityMode.values().length];
            try {
                1.$SwitchMap$org$opends$server$types$WritabilityMode[WritabilityMode.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$WritabilityMode[WritabilityMode.INTERNAL_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$org$opends$server$types$ModificationType = new int[ModificationType.values().length];
            try {
                1.$SwitchMap$org$opends$server$types$ModificationType[ModificationType.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$ModificationType[ModificationType.DELETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$ModificationType[ModificationType.REPLACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$ModificationType[ModificationType.INCREMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

