/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.OperationType;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
implements Runnable {
    private static final String CLASS_NAME = "org.opends.server.core.Operation";
    protected static final List<Control> NO_RESPONSE_CONTROLS = new ArrayList<Control>(0);
    protected ClientConnection clientConnection;
    protected int messageID;
    protected long operationID;
    private boolean isInternalOperation;
    private boolean isSynchronizationOperation;
    private CancelResult cancelResult;
    private DN authorizationDN;
    private DN matchedDN;
    private Map<String, Object> attachments;
    private List<Control> requestControls;
    private List<String> referralURLs;
    private ResultCode resultCode;
    private StringBuilder additionalLogMessage;
    private StringBuilder errorMessage;

    protected Operation(ClientConnection clientConnection, long l, int n, List<Control> list) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(n), String.valueOf(list)));
        this.clientConnection = clientConnection;
        this.operationID = l;
        this.messageID = n;
        this.requestControls = list;
        this.resultCode = ResultCode.UNDEFINED;
        this.additionalLogMessage = new StringBuilder();
        this.errorMessage = new StringBuilder();
        this.attachments = new HashMap<String, Object>();
        this.matchedDN = null;
        this.referralURLs = null;
        this.cancelResult = null;
        this.isInternalOperation = false;
        this.isSynchronizationOperation = false;
        this.authorizationDN = clientConnection.getAuthenticationInfo().getAuthorizationDN();
    }

    public abstract OperationType getOperationType();

    public String[][] getCommonLogElements() {
        return new String[][]{{"connID", String.valueOf(this.getConnectionID())}, {"opID", String.valueOf(this.operationID)}, {"messageID", String.valueOf(this.messageID)}};
    }

    public abstract String[][] getRequestLogElements();

    public abstract String[][] getResponseLogElements();

    public final ClientConnection getClientConnection() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientConnection", new String[0]));
        return this.clientConnection;
    }

    public final long getConnectionID() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionID", new String[0]));
        return this.clientConnection.getConnectionID();
    }

    public final long getOperationID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationID", new String[0]));
        return this.operationID;
    }

    public final int getMessageID() {
        assert (Debug.debugEnter(CLASS_NAME, "getMessageID", new String[0]));
        return this.messageID;
    }

    public List<Control> getRequestControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestControls", new String[0]));
        return this.requestControls;
    }

    public abstract List<Control> getResponseControls();

    public ResultCode getResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getResultCode", new String[0]));
        return this.resultCode;
    }

    public void setResultCode(ResultCode resultCode) {
        assert (Debug.debugEnter(CLASS_NAME, "setResultCode", String.valueOf((Object)resultCode)));
        this.resultCode = resultCode;
    }

    public StringBuilder getErrorMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorMessage", new String[0]));
        return this.errorMessage;
    }

    public void setErrorMessage(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "setErrorMessage", String.valueOf(stringBuilder)));
        this.errorMessage = stringBuilder == null ? new StringBuilder() : stringBuilder;
    }

    public void appendErrorMessage(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "appendErrorMessage", String.valueOf(string)));
        if (this.errorMessage == null) {
            this.errorMessage = new StringBuilder(string);
        } else {
            if (this.errorMessage.length() > 0) {
                this.errorMessage.append("  ");
            }
            this.errorMessage.append(string);
        }
    }

    public StringBuilder getAdditionalLogMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getAdditionalLogMessage", new String[0]));
        return this.additionalLogMessage;
    }

    public void setAdditionalLogMessage(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "setAdditionalLogMessage", String.valueOf(stringBuilder)));
        this.additionalLogMessage = stringBuilder == null ? new StringBuilder() : stringBuilder;
    }

    public void appendAdditionalLogMessage(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "appendAdditionalLogMessage", String.valueOf(string)));
        if (this.additionalLogMessage == null) {
            this.additionalLogMessage = new StringBuilder(string);
        } else {
            this.additionalLogMessage.append(string);
        }
    }

    public DN getMatchedDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchedDN", new String[0]));
        return this.matchedDN;
    }

    public void setMatchedDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchedDN", String.valueOf(dN)));
        this.matchedDN = dN;
    }

    public List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }

    public void setReferralURLs(List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setReferralURLs", String.valueOf(list)));
        this.referralURLs = list;
    }

    public void setResponseData(DirectoryException directoryException) {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseData", new String[0]));
        this.resultCode = directoryException.getResultCode();
        this.matchedDN = directoryException.getMatchedDN();
        this.referralURLs = directoryException.getReferralURLs();
        this.appendErrorMessage(directoryException.getErrorMessage());
    }

    public boolean isInternalOperation() {
        assert (Debug.debugEnter(CLASS_NAME, "isInternalOperation", new String[0]));
        return this.isInternalOperation;
    }

    public void setInternalOperation(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setInternalOperation", String.valueOf(bl)));
        this.isInternalOperation = bl;
    }

    public boolean isSynchronizationOperation() {
        assert (Debug.debugEnter(CLASS_NAME, "isSynchronizationOperation", new String[0]));
        return this.isSynchronizationOperation;
    }

    public void setSynchronizationOperation(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setSynchronizationOperation", String.valueOf(bl)));
        this.isSynchronizationOperation = bl;
    }

    public DN getAuthorizationDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthorizationDN", new String[0]));
        if (this.authorizationDN == null) {
            AuthenticationInfo authenticationInfo = this.clientConnection.getAuthenticationInfo();
            if (authenticationInfo == null) {
                return new DN(new RDN[0]);
            }
            return authenticationInfo.getAuthorizationDN();
        }
        return this.authorizationDN;
    }

    public void setAuthorizationDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthorizationDN", String.valueOf(dN)));
        this.authorizationDN = dN;
    }

    public Map<String, Object> getAttachments() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttachments", new String[0]));
        return this.attachments;
    }

    public Object getAttachment(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttachment", String.valueOf(string)));
        return this.attachments.get(string);
    }

    public Object removeAttachment(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeAttachment", String.valueOf(string)));
        return this.attachments.remove(string);
    }

    public Object setAttachment(String string, Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "putAttachment", String.valueOf(string), String.valueOf(object)));
        return this.attachments.put(string, object);
    }

    @Override
    public abstract void run();

    public void operationCompleted() {
        assert (Debug.debugEnter(CLASS_NAME, "operationCompleted", new String[0]));
        this.clientConnection.removeOperationInProgress(this.messageID);
    }

    public abstract CancelResult cancel(CancelRequest var1);

    public abstract CancelRequest getCancelRequest();

    public CancelResult getCancelResult() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelResult", new String[0]));
        return this.cancelResult;
    }

    public void setCancelResult(CancelResult cancelResult) {
        assert (Debug.debugEnter(CLASS_NAME, "setCancelResult", String.valueOf((Object)cancelResult)));
        this.cancelResult = cancelResult;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public abstract void toString(StringBuilder var1);
}

