/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class PasswordPolicyConfigManager
implements ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.PasswordPolicyConfigManager";

    public PasswordPolicyConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializePasswordPolicies() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordPolicies", new String[0]));
        try {
            dN = DN.decode("cn=Password Policies,cn=config");
            configEntry = DirectoryServer.getConfigHandler().getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicies", exception));
            int n = 3473920;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3408385;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        if (!configEntry.hasChildren()) {
            int n = 3408386;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        dN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (dN == null) {
            int n = 3408386;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        boolean bl = false;
        for (ConfigEntry object : configEntry.getChildren().values()) {
            boolean bl2 = dN.equals(object.getDN());
            if (bl2) {
                bl = true;
            }
            try {
                PasswordPolicy configException = new PasswordPolicy(object);
                DirectoryServer.registerPasswordPolicy(object.getDN(), configException);
                if (!bl2) continue;
                DirectoryServer.setDefaultPasswordPolicy(configException);
            }
            catch (ConfigException initializationException) {
                int n = 3408387;
                String string = MessageHandler.getMessage(n, String.valueOf(object.getDN()), initializationException.getMessage());
                throw new ConfigException(n, string, initializationException);
            }
            catch (InitializationException exception) {
                int n = 3408387;
                String string = MessageHandler.getMessage(n, String.valueOf(object.getDN()), exception.getMessage());
                throw new InitializationException(n, string, exception);
            }
            catch (Exception exception) {
                int n = 3408387;
                String string = MessageHandler.getMessage(n, String.valueOf(object.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
        }
        if (!bl) {
            int n = 3408388;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new ConfigException(n, string);
        }
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        try {
            PasswordPolicy passwordPolicy = new PasswordPolicy(configEntry);
        }
        catch (ConfigException configException) {
            int n = 3408387;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), configException.getMessage());
            stringBuilder.append(string);
            return false;
        }
        catch (InitializationException initializationException) {
            int n = 3408387;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), initializationException.getMessage());
            stringBuilder.append(string);
            return false;
        }
        catch (Exception exception) {
            int n = 3408387;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            PasswordPolicy passwordPolicy = new PasswordPolicy(configEntry);
            DirectoryServer.registerPasswordPolicy(dN, passwordPolicy);
            return new ConfigChangeResult(ResultCode.SUCCESS, false, arrayList);
        }
        catch (ConfigException configException) {
            int n = 3408387;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), configException.getMessage()));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, arrayList);
        }
        catch (InitializationException initializationException) {
            int n = 3408387;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), initializationException.getMessage()));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, arrayList);
        }
        catch (Exception exception) {
            int n = 3408387;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception)));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, arrayList);
        }
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (dN != null && dN.equals(configEntry.getDN())) {
            int n = 3277317;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        ArrayList<String> arrayList = new ArrayList<String>(1);
        DN dN = configEntry.getDN();
        DN dN2 = DirectoryServer.getDefaultPasswordPolicyDN();
        if (dN2 != null && dN2.equals(dN)) {
            int n = 3277317;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN2)));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, arrayList);
        }
        DirectoryServer.deregisterPasswordPolicy(dN);
        int n = 3146246;
        arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
        return new ConfigChangeResult(ResultCode.SUCCESS, false, arrayList);
    }
}

