/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private static final String CLASS_NAME = "org.opends.server.core.Schema";
    private ConcurrentHashMap<String, AttributeType> attributeTypes;
    private ConcurrentHashMap<String, ObjectClass> objectClasses;
    private ConcurrentHashMap<String, AttributeSyntax> syntaxes;
    private ConcurrentHashMap<String, MatchingRule> matchingRules;
    private ConcurrentHashMap<String, ApproximateMatchingRule> approximateMatchingRules;
    private ConcurrentHashMap<String, EqualityMatchingRule> equalityMatchingRules;
    private ConcurrentHashMap<String, OrderingMatchingRule> orderingMatchingRules;
    private ConcurrentHashMap<String, SubstringMatchingRule> substringMatchingRules;
    private ConcurrentHashMap<MatchingRule, MatchingRuleUse> matchingRuleUses;
    private ConcurrentHashMap<ObjectClass, DITContentRule> ditContentRules;
    private ConcurrentHashMap<Integer, DITStructureRule> ditStructureRulesByID;
    private ConcurrentHashMap<NameForm, DITStructureRule> ditStructureRulesByNameForm;
    private ConcurrentHashMap<ObjectClass, NameForm> nameFormsByOC;
    private ConcurrentHashMap<String, NameForm> nameFormsByName;
    private LinkedHashSet<AttributeValue> syntaxSet;
    private LinkedHashSet<AttributeValue> attributeTypeSet;
    private LinkedHashSet<AttributeValue> ditContentRuleSet;
    private LinkedHashSet<AttributeValue> ditStructureRuleSet;
    private LinkedHashSet<AttributeValue> matchingRuleSet;
    private LinkedHashSet<AttributeValue> matchingRuleUseSet;
    private LinkedHashSet<AttributeValue> nameFormSet;
    private LinkedHashSet<AttributeValue> objectClassSet;

    public Schema() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.attributeTypes = new ConcurrentHashMap();
        this.objectClasses = new ConcurrentHashMap();
        this.syntaxes = new ConcurrentHashMap();
        this.matchingRules = new ConcurrentHashMap();
        this.approximateMatchingRules = new ConcurrentHashMap();
        this.equalityMatchingRules = new ConcurrentHashMap();
        this.orderingMatchingRules = new ConcurrentHashMap();
        this.substringMatchingRules = new ConcurrentHashMap();
        this.matchingRuleUses = new ConcurrentHashMap();
        this.ditContentRules = new ConcurrentHashMap();
        this.ditStructureRulesByID = new ConcurrentHashMap();
        this.ditStructureRulesByNameForm = new ConcurrentHashMap();
        this.nameFormsByOC = new ConcurrentHashMap();
        this.nameFormsByName = new ConcurrentHashMap();
        this.syntaxSet = new LinkedHashSet();
        this.attributeTypeSet = new LinkedHashSet();
        this.ditContentRuleSet = new LinkedHashSet();
        this.ditStructureRuleSet = new LinkedHashSet();
        this.matchingRuleSet = new LinkedHashSet();
        this.matchingRuleUseSet = new LinkedHashSet();
        this.nameFormSet = new LinkedHashSet();
        this.objectClassSet = new LinkedHashSet();
    }

    public ConcurrentHashMap<String, AttributeType> getAttributeTypes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeTypes", new String[0]));
        return this.attributeTypes;
    }

    public LinkedHashSet<AttributeValue> getAttributeTypeSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeTypeSet", new String[0]));
        return this.attributeTypeSet;
    }

    public AttributeType getAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", String.valueOf(string)));
        return this.attributeTypes.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAttributeType(AttributeType attributeType, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerAttributeType", String.valueOf(attributeType), String.valueOf(bl)));
        ConcurrentHashMap<String, AttributeType> concurrentHashMap = this.attributeTypes;
        synchronized (concurrentHashMap) {
            Object object3;
            if (!bl) {
                object3 = StaticUtils.toLowerCase(attributeType.getOID());
                if (this.attributeTypes.containsKey(object3)) {
                    AttributeType attributeType2 = this.attributeTypes.get(object3);
                    int n = 196792;
                    String string = MessageHandler.getMessage(n, attributeType.getNameOrOID(), object3, attributeType2.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                for (String string : attributeType.getNormalizedNames()) {
                    if (!this.attributeTypes.containsKey(string)) continue;
                    AttributeType attributeType2 = this.attributeTypes.get(string);
                    int n = 196793;
                    String string2 = MessageHandler.getMessage(n, attributeType.getNameOrOID(), string, attributeType2.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string2, n);
                }
            }
            this.attributeTypes.put(StaticUtils.toLowerCase(attributeType.getOID()), attributeType);
            for (String string : attributeType.getNormalizedNames()) {
                this.attributeTypes.put(string, attributeType);
            }
            object3 = attributeType.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString((String)object3);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase((String)object3));
            this.attributeTypeSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAttributeType(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAttributeType", String.valueOf(attributeType)));
        ConcurrentHashMap<String, AttributeType> concurrentHashMap = this.attributeTypes;
        synchronized (concurrentHashMap) {
            this.attributeTypes.remove(StaticUtils.toLowerCase(attributeType.getOID()), attributeType);
            for (String object2 : attributeType.getNormalizedNames()) {
                this.attributeTypes.remove(object2, attributeType);
            }
            String string = attributeType.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.attributeTypeSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public ConcurrentHashMap<String, ObjectClass> getObjectClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClasses", new String[0]));
        return this.objectClasses;
    }

    public LinkedHashSet<AttributeValue> getObjectClassSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClassSet", new String[0]));
        return this.objectClassSet;
    }

    public ObjectClass getObjectClass(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClass", String.valueOf(string)));
        return this.objectClasses.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObjectClass(ObjectClass objectClass, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerObjectClass", String.valueOf(objectClass), String.valueOf(bl)));
        ConcurrentHashMap<String, ObjectClass> concurrentHashMap = this.objectClasses;
        synchronized (concurrentHashMap) {
            Object object4;
            Object object22;
            Object object3;
            if (!bl) {
                object3 = StaticUtils.toLowerCase(objectClass.getOID());
                if (this.objectClasses.containsKey(object3)) {
                    ObjectClass objectClass2 = this.objectClasses.get(object3);
                    int n = 196794;
                    String string = MessageHandler.getMessage(n, objectClass.getNameOrOID(), object3, objectClass2.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                for (Object object22 : objectClass.getNames().keySet()) {
                    if (!this.objectClasses.containsKey(object22)) continue;
                    ObjectClass objectClass3 = this.objectClasses.get(object22);
                    int n = 196795;
                    String string = MessageHandler.getMessage(n, objectClass.getNameOrOID(), object22, objectClass3.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
            }
            this.objectClasses.put(StaticUtils.toLowerCase(objectClass.getOID()), objectClass);
            for (Object object4 : objectClass.getNames().keySet()) {
                this.objectClasses.put((String)object4, objectClass);
            }
            object3 = objectClass.toString();
            object4 = new ASN1OctetString((String)object3);
            object22 = new ASN1OctetString(StaticUtils.toLowerCase((String)object3));
            this.objectClassSet.add(new AttributeValue((ByteString)object4, (ByteString)object22));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObjectClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterObjectClass", String.valueOf(objectClass)));
        ConcurrentHashMap<String, ObjectClass> concurrentHashMap = this.objectClasses;
        synchronized (concurrentHashMap) {
            Object object2;
            this.objectClasses.remove(StaticUtils.toLowerCase(objectClass.getOID()), objectClass);
            for (Object object2 : objectClass.getNames().keySet()) {
                this.objectClasses.remove(object2, objectClass);
            }
            String string = objectClass.toString();
            object2 = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.objectClassSet.remove(new AttributeValue((ByteString)object2, (ByteString)aSN1OctetString));
        }
    }

    public ConcurrentHashMap<String, AttributeSyntax> getSyntaxes() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxes", new String[0]));
        return this.syntaxes;
    }

    public LinkedHashSet<AttributeValue> getSyntaxSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxSet", new String[0]));
        return this.syntaxSet;
    }

    public AttributeSyntax getSyntax(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", String.valueOf(string)));
        return this.syntaxes.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSyntax(AttributeSyntax attributeSyntax, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerSyntax", String.valueOf(attributeSyntax), String.valueOf(bl)));
        ConcurrentHashMap<String, AttributeSyntax> concurrentHashMap = this.syntaxes;
        synchronized (concurrentHashMap) {
            String string;
            if (!bl && this.syntaxes.containsKey(string = StaticUtils.toLowerCase(attributeSyntax.getOID()))) {
                AttributeSyntax attributeSyntax2 = this.syntaxes.get(string);
                int n = 196796;
                String string2 = MessageHandler.getMessage(n, attributeSyntax.getSyntaxName(), string, attributeSyntax2.getSyntaxName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string2, n);
            }
            this.syntaxes.put(StaticUtils.toLowerCase(attributeSyntax.getOID()), attributeSyntax);
            string = attributeSyntax.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.syntaxSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSyntax(AttributeSyntax attributeSyntax) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSyntax", String.valueOf(attributeSyntax)));
        ConcurrentHashMap<String, AttributeSyntax> concurrentHashMap = this.syntaxes;
        synchronized (concurrentHashMap) {
            this.syntaxes.remove(StaticUtils.toLowerCase(attributeSyntax.getOID()), attributeSyntax);
            String string = attributeSyntax.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.syntaxSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public ConcurrentHashMap<String, MatchingRule> getMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRules", new String[0]));
        return this.matchingRules;
    }

    public LinkedHashSet<AttributeValue> getMatchingRuleSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleSet", new String[0]));
        return this.matchingRuleSet;
    }

    public MatchingRule getMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRule", String.valueOf(string)));
        return this.matchingRules.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMatchingRule(MatchingRule matchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerMatchingRule", String.valueOf(matchingRule), String.valueOf(bl)));
        if (matchingRule instanceof ApproximateMatchingRule) {
            this.registerApproximateMatchingRule((ApproximateMatchingRule)matchingRule, bl);
        } else if (matchingRule instanceof EqualityMatchingRule) {
            this.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, bl);
        } else if (matchingRule instanceof OrderingMatchingRule) {
            this.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, bl);
        } else if (matchingRule instanceof SubstringMatchingRule) {
            this.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, bl);
        } else {
            ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
            synchronized (concurrentHashMap) {
                String string;
                String string2;
                if (!bl) {
                    string2 = StaticUtils.toLowerCase(matchingRule.getOID());
                    if (this.matchingRules.containsKey(string2)) {
                        MatchingRule matchingRule2 = this.matchingRules.get(string2);
                        int n = 196797;
                        String string3 = MessageHandler.getMessage(n, matchingRule.getNameOrOID(), string2, matchingRule2.getNameOrOID());
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n);
                    }
                    string = matchingRule.getName();
                    if (string != null && this.matchingRules.containsKey(string = StaticUtils.toLowerCase(string))) {
                        MatchingRule matchingRule3 = this.matchingRules.get(string);
                        int n = 196798;
                        String string4 = MessageHandler.getMessage(n, matchingRule.getOID(), string, matchingRule3.getOID());
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string4, n);
                    }
                }
                this.matchingRules.put(StaticUtils.toLowerCase(matchingRule.getOID()), matchingRule);
                string2 = matchingRule.getName();
                if (string2 != null) {
                    this.matchingRules.put(StaticUtils.toLowerCase(string2), matchingRule);
                }
                string = matchingRule.toString();
                ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
                ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
                this.matchingRuleSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMatchingRule(MatchingRule matchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterMatchingRule", String.valueOf(matchingRule)));
        if (matchingRule instanceof ApproximateMatchingRule) {
            this.deregisterApproximateMatchingRule((ApproximateMatchingRule)matchingRule);
        } else if (matchingRule instanceof EqualityMatchingRule) {
            this.deregisterEqualityMatchingRule((EqualityMatchingRule)matchingRule);
        } else if (matchingRule instanceof OrderingMatchingRule) {
            this.deregisterOrderingMatchingRule((OrderingMatchingRule)matchingRule);
        } else if (matchingRule instanceof SubstringMatchingRule) {
            this.deregisterSubstringMatchingRule((SubstringMatchingRule)matchingRule);
        } else {
            ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
            synchronized (concurrentHashMap) {
                this.matchingRules.remove(StaticUtils.toLowerCase(matchingRule.getOID()), matchingRule);
                String string = matchingRule.getName();
                if (string != null) {
                    this.matchingRules.remove(StaticUtils.toLowerCase(string), matchingRule);
                }
                String string2 = matchingRule.toString();
                ASN1OctetString aSN1OctetString = new ASN1OctetString(string2);
                ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string2));
                this.matchingRuleSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
            }
        }
    }

    public ConcurrentHashMap<String, ApproximateMatchingRule> getApproximateMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRules", new String[0]));
        return this.approximateMatchingRules;
    }

    public ApproximateMatchingRule getApproximateMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", String.valueOf(string)));
        return this.approximateMatchingRules.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerApproximateMatchingRule(ApproximateMatchingRule approximateMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerApproximateMatchingRule", String.valueOf(approximateMatchingRule), String.valueOf(bl)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string;
            String string2;
            if (!bl) {
                string2 = StaticUtils.toLowerCase(approximateMatchingRule.getOID());
                if (this.matchingRules.containsKey(string2)) {
                    MatchingRule matchingRule = this.matchingRules.get(string2);
                    int n = 196797;
                    String string3 = MessageHandler.getMessage(n, approximateMatchingRule.getNameOrOID(), string2, matchingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n);
                }
                string = approximateMatchingRule.getName();
                if (string != null && this.matchingRules.containsKey(string = StaticUtils.toLowerCase(string))) {
                    MatchingRule matchingRule = this.matchingRules.get(string);
                    int n = 196798;
                    String string4 = MessageHandler.getMessage(n, approximateMatchingRule.getOID(), string, matchingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string4, n);
                }
            }
            string2 = StaticUtils.toLowerCase(approximateMatchingRule.getOID());
            this.approximateMatchingRules.put(string2, approximateMatchingRule);
            this.matchingRules.put(string2, approximateMatchingRule);
            string = approximateMatchingRule.getName();
            if (string != null) {
                string = StaticUtils.toLowerCase(string);
                this.approximateMatchingRules.put(string, approximateMatchingRule);
                this.matchingRules.put(string, approximateMatchingRule);
            }
            String string5 = approximateMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string5);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string5));
            this.matchingRuleSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterApproximateMatchingRule(ApproximateMatchingRule approximateMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterApproximateMatchingRule", String.valueOf(approximateMatchingRule)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string = approximateMatchingRule.getOID();
            this.approximateMatchingRules.remove(string, approximateMatchingRule);
            this.matchingRules.remove(string, approximateMatchingRule);
            String string2 = approximateMatchingRule.getName();
            if (string2 != null) {
                string2 = StaticUtils.toLowerCase(string2);
                this.approximateMatchingRules.remove(string2, approximateMatchingRule);
                this.matchingRules.remove(string2, approximateMatchingRule);
            }
            String string3 = approximateMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string3);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string3));
            this.matchingRuleSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public ConcurrentHashMap<String, EqualityMatchingRule> getEqualityMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRules", new String[0]));
        return this.equalityMatchingRules;
    }

    public EqualityMatchingRule getEqualityMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", String.valueOf(string)));
        return this.equalityMatchingRules.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEqualityMatchingRule(EqualityMatchingRule equalityMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerEqualityMatchingRule", String.valueOf(equalityMatchingRule), String.valueOf(bl)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string;
            String string2;
            if (!bl) {
                string2 = StaticUtils.toLowerCase(equalityMatchingRule.getOID());
                if (this.matchingRules.containsKey(string2)) {
                    MatchingRule matchingRule = this.matchingRules.get(string2);
                    int n = 196797;
                    String string3 = MessageHandler.getMessage(n, equalityMatchingRule.getNameOrOID(), string2, matchingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n);
                }
                string = equalityMatchingRule.getName();
                if (string != null && this.matchingRules.containsKey(string = StaticUtils.toLowerCase(string))) {
                    MatchingRule matchingRule = this.matchingRules.get(string);
                    int n = 196798;
                    String string4 = MessageHandler.getMessage(n, equalityMatchingRule.getOID(), string, matchingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string4, n);
                }
            }
            string2 = StaticUtils.toLowerCase(equalityMatchingRule.getOID());
            this.equalityMatchingRules.put(string2, equalityMatchingRule);
            this.matchingRules.put(string2, equalityMatchingRule);
            string = equalityMatchingRule.getName();
            if (string != null) {
                string = StaticUtils.toLowerCase(string);
                this.equalityMatchingRules.put(string, equalityMatchingRule);
                this.matchingRules.put(string, equalityMatchingRule);
            }
            String string5 = equalityMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string5);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string5));
            this.matchingRuleSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterEqualityMatchingRule(EqualityMatchingRule equalityMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterEqualityMatchingRule", String.valueOf(equalityMatchingRule)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string = equalityMatchingRule.getOID();
            this.equalityMatchingRules.remove(string, equalityMatchingRule);
            this.matchingRules.remove(string, equalityMatchingRule);
            String string2 = equalityMatchingRule.getName();
            if (string2 != null) {
                string2 = StaticUtils.toLowerCase(string2);
                this.equalityMatchingRules.remove(string2, equalityMatchingRule);
                this.matchingRules.remove(string2, equalityMatchingRule);
            }
            String string3 = equalityMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string3);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string3));
            this.matchingRuleSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public ConcurrentHashMap<String, OrderingMatchingRule> getOrderingMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRules", new String[0]));
        return this.orderingMatchingRules;
    }

    public OrderingMatchingRule getOrderingMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", String.valueOf(string)));
        return this.orderingMatchingRules.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOrderingMatchingRule(OrderingMatchingRule orderingMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerOrderingMatchingRule", String.valueOf(orderingMatchingRule), String.valueOf(bl)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string;
            String string2;
            if (!bl) {
                string2 = StaticUtils.toLowerCase(orderingMatchingRule.getOID());
                if (this.matchingRules.containsKey(string2)) {
                    MatchingRule matchingRule = this.matchingRules.get(string2);
                    int n = 196797;
                    String string3 = MessageHandler.getMessage(n, orderingMatchingRule.getNameOrOID(), string2, matchingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n);
                }
                string = orderingMatchingRule.getName();
                if (string != null && this.matchingRules.containsKey(string = StaticUtils.toLowerCase(string))) {
                    MatchingRule matchingRule = this.matchingRules.get(string);
                    int n = 196798;
                    String string4 = MessageHandler.getMessage(n, orderingMatchingRule.getOID(), string, matchingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string4, n);
                }
            }
            string2 = StaticUtils.toLowerCase(orderingMatchingRule.getOID());
            this.orderingMatchingRules.put(string2, orderingMatchingRule);
            this.matchingRules.put(string2, orderingMatchingRule);
            string = orderingMatchingRule.getName();
            if (string != null) {
                string = StaticUtils.toLowerCase(string);
                this.orderingMatchingRules.put(string, orderingMatchingRule);
                this.matchingRules.put(string, orderingMatchingRule);
            }
            String string5 = orderingMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string5);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string5));
            this.matchingRuleSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterOrderingMatchingRule(OrderingMatchingRule orderingMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterOrderingMatchingRule", String.valueOf(orderingMatchingRule)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string = orderingMatchingRule.getOID();
            this.orderingMatchingRules.remove(string, orderingMatchingRule);
            this.matchingRules.remove(string, orderingMatchingRule);
            String string2 = orderingMatchingRule.getName();
            if (string2 != null) {
                string2 = StaticUtils.toLowerCase(string2);
                this.orderingMatchingRules.remove(string2, orderingMatchingRule);
                this.matchingRules.remove(string2, orderingMatchingRule);
            }
            String string3 = orderingMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string3);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string3));
            this.matchingRuleSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public ConcurrentHashMap<String, SubstringMatchingRule> getSubstringMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRules", new String[0]));
        return this.substringMatchingRules;
    }

    public SubstringMatchingRule getSubstringMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", String.valueOf(string)));
        return this.substringMatchingRules.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubstringMatchingRule(SubstringMatchingRule substringMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerSubstringMatchingRule", String.valueOf(substringMatchingRule), String.valueOf(bl)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string;
            String string2;
            if (!bl) {
                string2 = StaticUtils.toLowerCase(substringMatchingRule.getOID());
                if (this.matchingRules.containsKey(string2)) {
                    MatchingRule matchingRule = this.matchingRules.get(string2);
                    int n = 196797;
                    String string3 = MessageHandler.getMessage(n, substringMatchingRule.getNameOrOID(), string2, matchingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n);
                }
                string = substringMatchingRule.getName();
                if (string != null && this.matchingRules.containsKey(string = StaticUtils.toLowerCase(string))) {
                    MatchingRule matchingRule = this.matchingRules.get(string);
                    int n = 196798;
                    String string4 = MessageHandler.getMessage(n, substringMatchingRule.getOID(), string, matchingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string4, n);
                }
            }
            string2 = StaticUtils.toLowerCase(substringMatchingRule.getOID());
            this.substringMatchingRules.put(string2, substringMatchingRule);
            this.matchingRules.put(string2, substringMatchingRule);
            string = substringMatchingRule.getName();
            if (string != null) {
                string = StaticUtils.toLowerCase(string);
                this.substringMatchingRules.put(string, substringMatchingRule);
                this.matchingRules.put(string, substringMatchingRule);
            }
            String string5 = substringMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string5);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string5));
            this.matchingRuleSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubstringMatchingRule(SubstringMatchingRule substringMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSubstringMatchingRule", String.valueOf(substringMatchingRule)));
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String string = substringMatchingRule.getOID();
            this.substringMatchingRules.remove(string, substringMatchingRule);
            this.matchingRules.remove(string, substringMatchingRule);
            String string2 = substringMatchingRule.getName();
            if (string2 != null) {
                string2 = StaticUtils.toLowerCase(string2);
                this.substringMatchingRules.remove(string2, substringMatchingRule);
                this.matchingRules.remove(string2, substringMatchingRule);
            }
            String string3 = substringMatchingRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string3);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string3));
            this.matchingRuleSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public ConcurrentHashMap<MatchingRule, MatchingRuleUse> getMatchingRuleUses() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUses", new String[0]));
        return this.matchingRuleUses;
    }

    public LinkedHashSet<AttributeValue> getMatchingRuleUseSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUseSet", new String[0]));
        return this.matchingRuleUseSet;
    }

    public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUse", String.valueOf(matchingRule)));
        return this.matchingRuleUses.get(matchingRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMatchingRuleUse(MatchingRuleUse matchingRuleUse, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerMatchingRuleUse", String.valueOf(matchingRuleUse), String.valueOf(bl)));
        ConcurrentHashMap<MatchingRule, MatchingRuleUse> concurrentHashMap = this.matchingRuleUses;
        synchronized (concurrentHashMap) {
            MatchingRule matchingRule = matchingRuleUse.getMatchingRule();
            if (!bl && this.matchingRuleUses.containsKey(matchingRule)) {
                MatchingRuleUse matchingRuleUse2 = this.matchingRuleUses.get(matchingRule);
                int n = 196799;
                String string = MessageHandler.getMessage(n, matchingRuleUse.getName(), matchingRule.getNameOrOID(), matchingRuleUse2.getName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
            }
            this.matchingRuleUses.put(matchingRule, matchingRuleUse);
            String string = matchingRuleUse.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.matchingRuleUseSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMatchingRuleUse(MatchingRuleUse matchingRuleUse) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterMatchingRuleUse", String.valueOf(matchingRuleUse)));
        ConcurrentHashMap<MatchingRule, MatchingRuleUse> concurrentHashMap = this.matchingRuleUses;
        synchronized (concurrentHashMap) {
            this.matchingRuleUses.remove(matchingRuleUse.getMatchingRule(), matchingRuleUse);
            String string = matchingRuleUse.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.matchingRuleUseSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public ConcurrentHashMap<ObjectClass, DITContentRule> getDITContentRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRules", new String[0]));
        return this.ditContentRules;
    }

    public LinkedHashSet<AttributeValue> getDITContentRuleSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRuleSet", new String[0]));
        return this.ditContentRuleSet;
    }

    public DITContentRule getDITContentRule(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRule", String.valueOf(objectClass)));
        return this.ditContentRules.get(objectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDITContentRule(DITContentRule dITContentRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerDITContentRule", String.valueOf(dITContentRule), String.valueOf(bl)));
        ConcurrentHashMap<ObjectClass, DITContentRule> concurrentHashMap = this.ditContentRules;
        synchronized (concurrentHashMap) {
            ObjectClass objectClass = dITContentRule.getStructuralClass();
            if (!bl && this.ditContentRules.containsKey(objectClass)) {
                DITContentRule dITContentRule2 = this.ditContentRules.get(objectClass);
                int n = 196800;
                String string = MessageHandler.getMessage(n, dITContentRule.getName(), objectClass.getNameOrOID(), dITContentRule2.getName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
            }
            this.ditContentRules.put(objectClass, dITContentRule);
            String string = dITContentRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.ditContentRuleSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDITContentRule(DITContentRule dITContentRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterDITContentRule", String.valueOf(dITContentRule)));
        ConcurrentHashMap<ObjectClass, DITContentRule> concurrentHashMap = this.ditContentRules;
        synchronized (concurrentHashMap) {
            this.ditContentRules.remove(dITContentRule.getStructuralClass(), dITContentRule);
            String string = dITContentRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.ditContentRuleSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public LinkedHashSet<AttributeValue> getDITStructureRuleSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRuleSet", new String[0]));
        return this.ditStructureRuleSet;
    }

    public ConcurrentHashMap<Integer, DITStructureRule> getDITStructureRulesByID() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRulesByID", new String[0]));
        return this.ditStructureRulesByID;
    }

    public ConcurrentHashMap<NameForm, DITStructureRule> getDITStructureRulesByNameForm() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRulesByNameForm", new String[0]));
        return this.ditStructureRulesByNameForm;
    }

    public DITStructureRule getDITStructureRule(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRule", String.valueOf(n)));
        return this.ditStructureRulesByID.get(n);
    }

    public DITStructureRule getDITStructureRule(NameForm nameForm) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRule", String.valueOf(nameForm)));
        return this.ditStructureRulesByNameForm.get(nameForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDITStructureRule(DITStructureRule dITStructureRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "ditStructureRule", String.valueOf(dITStructureRule), String.valueOf(bl)));
        ConcurrentHashMap<NameForm, DITStructureRule> concurrentHashMap = this.ditStructureRulesByNameForm;
        synchronized (concurrentHashMap) {
            NameForm nameForm = dITStructureRule.getNameForm();
            int n = dITStructureRule.getRuleID();
            if (!bl) {
                if (this.ditStructureRulesByNameForm.containsKey(nameForm)) {
                    DITStructureRule dITStructureRule2 = this.ditStructureRulesByNameForm.get(nameForm);
                    int n2 = 196801;
                    String string = MessageHandler.getMessage(n2, dITStructureRule.getNameOrRuleID(), nameForm.getNameOrOID(), dITStructureRule2.getNameOrRuleID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n2);
                }
                if (this.ditStructureRulesByID.containsKey(n)) {
                    DITStructureRule dITStructureRule3 = this.ditStructureRulesByID.get(n);
                    int n3 = 196802;
                    String string = MessageHandler.getMessage(n3, dITStructureRule.getNameOrRuleID(), n, dITStructureRule3.getNameOrRuleID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n3);
                }
            }
            this.ditStructureRulesByNameForm.put(nameForm, dITStructureRule);
            this.ditStructureRulesByID.put(n, dITStructureRule);
            String string = dITStructureRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.ditStructureRuleSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDITStructureRule(DITStructureRule dITStructureRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterDITStructureRule", String.valueOf(dITStructureRule)));
        ConcurrentHashMap<NameForm, DITStructureRule> concurrentHashMap = this.ditStructureRulesByNameForm;
        synchronized (concurrentHashMap) {
            this.ditStructureRulesByNameForm.remove(dITStructureRule.getNameForm(), dITStructureRule);
            this.ditStructureRulesByID.remove(dITStructureRule.getRuleID(), dITStructureRule);
            String string = dITStructureRule.toString();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.ditStructureRuleSet.remove(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString2));
        }
    }

    public LinkedHashSet<AttributeValue> getNameFormSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameFormSet", new String[0]));
        return this.nameFormSet;
    }

    public ConcurrentHashMap<ObjectClass, NameForm> getNameFormsByObjectClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForms", new String[0]));
        return this.nameFormsByOC;
    }

    public ConcurrentHashMap<String, NameForm> getNameFormsByNameOrOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForms", new String[0]));
        return this.nameFormsByName;
    }

    public NameForm getNameForm(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForm", String.valueOf(objectClass)));
        return this.nameFormsByOC.get(objectClass);
    }

    public NameForm getNameForm(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForm", String.valueOf(string)));
        return this.nameFormsByName.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNameForm(NameForm nameForm, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerNameForm", String.valueOf(nameForm), String.valueOf(bl)));
        ConcurrentHashMap<ObjectClass, NameForm> concurrentHashMap = this.nameFormsByOC;
        synchronized (concurrentHashMap) {
            Object object4;
            Object object22;
            Object object3;
            ObjectClass objectClass = nameForm.getStructuralClass();
            if (!bl) {
                if (this.nameFormsByOC.containsKey(objectClass)) {
                    NameForm nameForm2 = this.nameFormsByOC.get(objectClass);
                    int n = 196803;
                    String string = MessageHandler.getMessage(n, nameForm.getNameOrOID(), objectClass.getNameOrOID(), nameForm2.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                object3 = StaticUtils.toLowerCase(nameForm.getOID());
                if (this.nameFormsByName.containsKey(object3)) {
                    NameForm nameForm3 = this.nameFormsByName.get(object3);
                    int n = 196804;
                    String string = MessageHandler.getMessage(n, nameForm.getNameOrOID(), object3, nameForm3.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                for (Object object22 : nameForm.getNames().keySet()) {
                    if (!this.nameFormsByName.containsKey(object22)) continue;
                    NameForm nameForm4 = this.nameFormsByName.get(object22);
                    int n = 196805;
                    String string = MessageHandler.getMessage(n, nameForm.getNameOrOID(), object3, nameForm4.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
            }
            this.nameFormsByOC.put(objectClass, nameForm);
            this.nameFormsByName.put(StaticUtils.toLowerCase(nameForm.getOID()), nameForm);
            for (Object object4 : nameForm.getNames().keySet()) {
                this.nameFormsByName.put((String)object4, nameForm);
            }
            object3 = nameForm.toString();
            object4 = new ASN1OctetString((String)object3);
            object22 = new ASN1OctetString(StaticUtils.toLowerCase((String)object3));
            this.nameFormSet.add(new AttributeValue((ByteString)object4, (ByteString)object22));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterNameForm(NameForm nameForm) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterNameForm", String.valueOf(nameForm)));
        ConcurrentHashMap<ObjectClass, NameForm> concurrentHashMap = this.nameFormsByOC;
        synchronized (concurrentHashMap) {
            Object object2;
            this.nameFormsByOC.remove(nameForm.getStructuralClass(), nameForm);
            this.nameFormsByName.remove(StaticUtils.toLowerCase(nameForm.getOID()), nameForm);
            for (Object object2 : nameForm.getNames().keySet()) {
                this.nameFormsByName.remove(object2, nameForm);
            }
            String string = nameForm.toString();
            object2 = new ASN1OctetString(string);
            ASN1OctetString aSN1OctetString = new ASN1OctetString(StaticUtils.toLowerCase(string));
            this.nameFormSet.remove(new AttributeValue((ByteString)object2, (ByteString)aSN1OctetString));
        }
    }

    public Schema duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        Schema schema = new Schema();
        schema.attributeTypes.putAll(this.attributeTypes);
        schema.objectClasses.putAll(this.objectClasses);
        schema.syntaxes.putAll(this.syntaxes);
        schema.matchingRules.putAll(this.matchingRules);
        schema.approximateMatchingRules.putAll(this.approximateMatchingRules);
        schema.equalityMatchingRules.putAll(this.equalityMatchingRules);
        schema.orderingMatchingRules.putAll(this.orderingMatchingRules);
        schema.substringMatchingRules.putAll(this.substringMatchingRules);
        schema.matchingRuleUses.putAll(this.matchingRuleUses);
        schema.ditContentRules.putAll(this.ditContentRules);
        schema.ditStructureRulesByID.putAll(this.ditStructureRulesByID);
        schema.ditStructureRulesByNameForm.putAll(this.ditStructureRulesByNameForm);
        schema.nameFormsByOC.putAll(this.nameFormsByOC);
        schema.nameFormsByName.putAll(this.nameFormsByName);
        schema.syntaxSet.addAll(this.syntaxSet);
        schema.attributeTypeSet.addAll(this.attributeTypeSet);
        schema.ditContentRuleSet.addAll(this.ditContentRuleSet);
        schema.ditStructureRuleSet.addAll(this.ditStructureRuleSet);
        schema.matchingRuleSet.addAll(this.matchingRuleSet);
        schema.matchingRuleUseSet.addAll(this.matchingRuleUseSet);
        schema.nameFormSet.addAll(this.nameFormSet);
        schema.objectClassSet.addAll(this.objectClassSet);
        return schema;
    }
}

