/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Iterator;
import java.util.LinkedList;
import org.opends.server.core.DirectoryServer;

public class ServerShutdownMonitor
extends Thread {
    private boolean monitorDone;
    private LinkedList<Thread> threadList;

    public ServerShutdownMonitor() {
        this.setName("Directory Server Shutdown Monitor");
        this.setDaemon(true);
        long l = Thread.currentThread().getId();
        this.threadList = new LinkedList();
        ThreadGroup threadGroup = DirectoryServer.getDirectoryThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount() * 2];
        int n = threadGroup.enumerate(threadArray, true);
        for (int i = 0; i < n; ++i) {
            Thread thread = threadArray[i];
            if (!thread.isAlive() || thread.isDaemon() || thread.getId() == l) continue;
            this.threadList.add(thread);
        }
        this.monitorDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.monitorDone = false;
        try {
            Thread thread3;
            Iterator iterator = this.threadList.iterator();
            while (iterator.hasNext()) {
                Thread thread2 = (Thread)iterator.next();
                if (thread2.isAlive()) continue;
                iterator.remove();
            }
            if (this.threadList.isEmpty()) {
                return;
            }
            long l = System.currentTimeMillis() + 30000L;
            while (System.currentTimeMillis() < l) {
                iterator = this.threadList.iterator();
                while (iterator.hasNext()) {
                    thread3 = (Thread)iterator.next();
                    if (thread3.isAlive()) continue;
                    iterator.remove();
                }
                if (this.threadList.isEmpty()) {
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            for (Thread thread3 : this.threadList) {
                try {
                    if (!thread3.isAlive()) continue;
                    thread3.interrupt();
                }
                catch (Exception exception) {}
            }
            if (this.threadList.isEmpty()) {
                return;
            }
            l = System.currentTimeMillis() + 30000L;
            while (System.currentTimeMillis() < l) {
                iterator = this.threadList.iterator();
                while (iterator.hasNext()) {
                    thread3 = (Thread)iterator.next();
                    if (thread3.isAlive()) continue;
                    iterator.remove();
                }
                if (this.threadList.isEmpty()) {
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            System.err.println("WARNING:  The following threads were still active after waiting up to 60 seconds for them to stop:");
            for (Thread thread3 : this.threadList) {
                System.err.println("Thread Name:  " + thread3.getName());
                System.err.println("Stack Trace:");
                for (StackTraceElement stackTraceElement : thread3.getStackTrace()) {
                    System.err.print("              " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":");
                    if (stackTraceElement.isNativeMethod()) {
                        System.err.print("native method");
                    } else {
                        System.err.print(stackTraceElement.getLineNumber());
                    }
                    System.err.println(")");
                    System.err.println();
                }
            }
        }
        finally {
            this.monitorDone = true;
        }
    }

    public void waitForMonitor() {
        while (!this.monitorDone) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }
}

