/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class AnonymousSASLMechanismHandler
extends SASLMechanismHandler {
    private static final String CLASS_NAME = "org.opends.server.extensions.AnonymousSASLMechanismHandler";

    public AnonymousSASLMechanismHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSASLMechanismHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSASLMechanismHandler", String.valueOf(configEntry)));
        DirectoryServer.registerSASLMechanismHandler("ANONYMOUS", this);
    }

    public void finalizeSASLMechanismHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSASLMechanismHandler", new String[0]));
        DirectoryServer.deregisterSASLMechanismHandler("ANONYMOUS");
    }

    public void processSASLBind(BindOperation bindOperation) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(bindOperation)));
        ASN1OctetString aSN1OctetString = bindOperation.getSASLCredentials();
        if (aSN1OctetString != null && ((String)(object = aSN1OctetString.stringValue())).length() > 0) {
            Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.INFORMATIONAL, 1048741, bindOperation.getConnectionID(), bindOperation.getOperationID(), object);
        }
        object = new AuthenticationInfo();
        bindOperation.getClientConnection().setAuthenticationInfo((AuthenticationInfo)object);
        bindOperation.setResultCode(ResultCode.SUCCESS);
    }

    public boolean isPasswordBased(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isPasswordBased", String.valueOf(string)));
        return false;
    }

    public boolean isSecure(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", String.valueOf(string)));
        return false;
    }
}

