/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.LockManager;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.extensions.DigestMD5StateInfo;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestMD5SASLMechanismHandler
extends SASLMechanismHandler
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.DigestMD5SASLMechanismHandler";
    private DN configEntryDN;
    private DN identityMapperDN;
    private IdentityMapper identityMapper;
    private MessageDigest md5Digest;
    private ReentrantLock digestLock;
    private SecureRandom randomGenerator;
    private String realm;

    public DigestMD5SASLMechanismHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSASLMechanismHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializeSASLMechanismHandler", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        this.digestLock = new ReentrantLock();
        this.randomGenerator = new SecureRandom();
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            int n = 1310912;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        int n = 1048891;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            configAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (configAttribute == null) {
                n = 1245500;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            this.identityMapperDN = configAttribute.activeValue();
            this.identityMapper = DirectoryServer.getIdentityMapper(this.identityMapperDN);
            if (this.identityMapper == null) {
                n = 1245501;
                String string = MessageHandler.getMessage(n, String.valueOf(this.identityMapperDN), String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1245502;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.realm = null;
        n = 1048774;
        configAttribute = new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false);
        try {
            StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (stringConfigAttribute != null) {
                this.realm = stringConfigAttribute.activeValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1310919;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        DirectoryServer.registerSASLMechanismHandler("DIGEST-MD5", this);
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSASLMechanismHandler", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
        DirectoryServer.deregisterSASLMechanismHandler("DIGEST-MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Object object;
        Object object2;
        Object object4;
        String string;
        List<ByteString> list;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(bindOperation)));
        ASN1OctetString aSN1OctetString = bindOperation.getSASLCredentials();
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (aSN1OctetString == null || aSN1OctetString.value().length == 0) {
            Object object5;
            LinkedHashMap<DN, Backend> linkedHashMap;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.realm == null) {
                linkedHashMap = DirectoryServer.getSuffixes();
                if (!linkedHashMap.isEmpty()) {
                    object5 = linkedHashMap.keySet().iterator();
                    stringBuilder.append("realm=\"");
                    stringBuilder.append(object5.next().toNormalizedString());
                    stringBuilder.append("\"");
                    while (object5.hasNext()) {
                        stringBuilder.append(",realm=\"");
                        stringBuilder.append(object5.next().toNormalizedString());
                        stringBuilder.append("\"");
                    }
                }
            } else {
                stringBuilder.append("realm=\"");
                stringBuilder.append(this.realm);
                stringBuilder.append("\"");
            }
            linkedHashMap = this.generateNonce();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("nonce=\"");
            stringBuilder.append((String)((Object)linkedHashMap));
            stringBuilder.append("\"");
            stringBuilder.append(",qop=\"auth\"");
            stringBuilder.append(",charset=utf-8");
            stringBuilder.append(",algorithm=md5-sess");
            object5 = new ASN1OctetString(stringBuilder.toString());
            if (((ASN1Element)object5).value().length >= 2048) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n2 = 1179848;
                String string2 = MessageHandler.getMessage(n2, ((ASN1Element)object5).value().length);
                bindOperation.setAuthFailureReason(n2, string2);
                Error.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.SEVERE_WARNING, string2, n2);
                return;
            }
            DigestMD5StateInfo digestMD5StateInfo = new DigestMD5StateInfo((String)((Object)linkedHashMap), "00000000");
            clientConnection.setSASLAuthStateInfo(digestMD5StateInfo);
            bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
            bindOperation.setServerSASLCredentials((ASN1OctetString)object5);
            return;
        }
        Object object6 = clientConnection.getSASLAuthStateInfo();
        if (object6 == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n3 = 1245385;
            String string3 = MessageHandler.getMessage(n3);
            bindOperation.setAuthFailureReason(n3, string3);
            return;
        }
        if (!(object6 instanceof DigestMD5StateInfo)) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n4 = 1245386;
            String string4 = MessageHandler.getMessage(n4);
            bindOperation.setAuthFailureReason(n4, string4);
            return;
        }
        DigestMD5StateInfo digestMD5StateInfo = (DigestMD5StateInfo)object6;
        Object object7 = null;
        Object object8 = null;
        List<ByteString> list2 = null;
        List<ByteString> list3 = null;
        int n5 = -1;
        List<ByteString> list4 = null;
        List<ByteString> list5 = "auth";
        List<ByteString> list6 = null;
        byte[] byArray = null;
        String string5 = "ISO-8859-1";
        List<ByteString> list7 = null;
        byte[] byArray2 = aSN1OctetString.value();
        String string6 = null;
        String string7 = null;
        try {
            string6 = new String(byArray2, string5);
            string7 = StaticUtils.toLowerCase(string6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
            Error.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.SEVERE_WARNING, 1179851, string5, StaticUtils.stackTraceToSingleLineString(exception));
        }
        if (string6 == null || string7.indexOf("charset=utf-8") >= 0) {
            try {
                string6 = new String(byArray2, "UTF-8");
                string7 = StaticUtils.toLowerCase(string6);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n6 = 1179852;
                String string8 = MessageHandler.getMessage(n6, StaticUtils.stackTraceToSingleLineString(exception));
                bindOperation.setAuthFailureReason(n6, string8);
                return;
            }
        }
        int n7 = 0;
        int n8 = string6.length();
        while (n7 < n8) {
            CharSequence charSequence;
            n = string6.indexOf(61, n7 + 1);
            if (n < 0) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n9 = 1245389;
                list = MessageHandler.getMessage(n9, n7);
                bindOperation.setAuthFailureReason(n9, (String)((Object)list));
                return;
            }
            string = string7.substring(n7, n);
            try {
                charSequence = new StringBuilder();
                n7 = this.readToken(string6, n + 1, n8, (StringBuilder)charSequence);
                list = charSequence.toString();
            }
            catch (DirectoryException directoryException) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                bindOperation.setAuthFailureReason(directoryException.getErrorMessageID(), directoryException.getErrorMessage());
                return;
            }
            if (string.equals("charset")) {
                if (((String)((Object)list)).equalsIgnoreCase("utf-8")) continue;
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n10 = 1245390;
                String string9 = MessageHandler.getMessage(n10, list);
                bindOperation.setAuthFailureReason(n10, string9);
                return;
            }
            if (string.equals("username")) {
                object7 = list;
                continue;
            }
            if (string.equals("realm")) {
                object8 = list;
                if (this.realm == null || ((String)object8).equals(this.realm)) continue;
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n11 = 1245392;
                String string10 = MessageHandler.getMessage(n11, object8);
                bindOperation.setAuthFailureReason(n11, string10);
                return;
            }
            if (string.equals("nonce")) {
                list2 = list;
                charSequence = digestMD5StateInfo.getNonce();
                if (((String)((Object)list2)).equals(charSequence)) continue;
                int n12 = 1310929;
                String string11 = MessageHandler.getMessage(n12);
                clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, n12, string11);
                return;
            }
            if (string.equals("cnonce")) {
                list3 = list;
                continue;
            }
            if (string.equals("nc")) {
                int n13;
                try {
                    list4 = list;
                    n5 = Integer.parseInt(list4, 16);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int n14 = 1245394;
                    String string12 = MessageHandler.getMessage(n14, list);
                    bindOperation.setAuthFailureReason(n14, string12);
                    return;
                }
                try {
                    n13 = Integer.parseInt(digestMD5StateInfo.getNonceCount(), 16);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int n15 = 1310931;
                    String string13 = MessageHandler.getMessage(n15, StaticUtils.stackTraceToSingleLineString(exception));
                    bindOperation.setAuthFailureReason(n15, string13);
                    return;
                }
                if (n5 == n13 + 1) continue;
                int n16 = 1310932;
                String string14 = MessageHandler.getMessage(n16);
                clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, n16, string14);
                return;
            }
            if (string.equals("qop")) {
                list5 = list;
                if (((String)((Object)list5)).equals("auth")) continue;
                if (((String)((Object)list5)).equals("auth-int")) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int n17 = 1245397;
                    String string15 = MessageHandler.getMessage(n17);
                    bindOperation.setAuthFailureReason(n17, string15);
                    return;
                }
                if (((String)((Object)list5)).equals("auth-conf")) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int n18 = 1245398;
                    String string16 = MessageHandler.getMessage(n18);
                    bindOperation.setAuthFailureReason(n18, string16);
                    return;
                }
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n19 = 1245399;
                String string17 = MessageHandler.getMessage(n19, list5);
                bindOperation.setAuthFailureReason(n19, string17);
                return;
            }
            if (string.equals("digest-uri")) {
                list6 = list;
                continue;
            }
            if (string.equals("response")) {
                try {
                    byArray = StaticUtils.hexStringToByteArray(list);
                    continue;
                }
                catch (ParseException parseException) {
                    assert (Debug.debugException(CLASS_NAME, "processSASLBind", parseException));
                    int n20 = 1245400;
                    String string18 = MessageHandler.getMessage(n20, StaticUtils.stackTraceToSingleLineString(parseException));
                    bindOperation.setAuthFailureReason(n20, string18);
                    return;
                }
            }
            if (string.equals("authzid")) {
                list7 = list;
                continue;
            }
            if (string.equals("maxbuf") || string.equals("cipher")) continue;
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n21 = 1245401;
            String string19 = MessageHandler.getMessage(n21, string);
            bindOperation.setAuthFailureReason(n21, string19);
            return;
        }
        if (object7 == null || ((String)object7).length() == 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            n = 1245402;
            string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (list2 == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            n = 1245403;
            string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (list3 == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            n = 1245404;
            string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (n5 < 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            n = 1245405;
            string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (list6 == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            n = 1245406;
            string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (byArray == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            n = 1245407;
            string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (object8 == null) {
            object8 = "";
        }
        Entry entry = null;
        string = StaticUtils.toLowerCase((String)object7);
        if (string.startsWith("dn:")) {
            int n22;
            try {
                list = DN.decode(((String)object7).substring(3));
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", directoryException));
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n23 = 1245408;
                String string20 = MessageHandler.getMessage(n23, object7, directoryException.getErrorMessage());
                bindOperation.setAuthFailureReason(n23, string20);
                return;
            }
            if (((DN)((Object)list)).isNullDN()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n24 = 1245409;
                String string21 = MessageHandler.getMessage(n24);
                bindOperation.setAuthFailureReason(n24, string21);
                return;
            }
            DN dN = DirectoryServer.getActualRootBindDN((DN)((Object)list));
            if (dN != null) {
                list = dN;
            }
            object4 = null;
            for (n22 = 0; n22 < 3 && (object4 = LockManager.lockRead((DN)((Object)list))) == null; ++n22) {
            }
            if (object4 == null) {
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                n22 = 1048802;
                String string22 = MessageHandler.getMessage(n22, String.valueOf(list));
                bindOperation.setAuthFailureReason(n22, string22);
                return;
            }
            try {
                entry = DirectoryServer.getEntry((DN)((Object)list));
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", directoryException));
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n25 = 1245411;
                String n32 = MessageHandler.getMessage(n25, String.valueOf(list), directoryException.getErrorMessage());
                bindOperation.setAuthFailureReason(n25, n32);
                return;
            }
            finally {
                LockManager.unlock(list, (Lock)object4);
            }
        }
        list = object7;
        if (string.startsWith("u:")) {
            if (string.equals("u:")) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n26 = 1245412;
                String string24 = MessageHandler.getMessage(n26);
                bindOperation.setAuthFailureReason(n26, string24);
                return;
            }
            list = ((String)object7).substring(2);
        }
        try {
            entry = this.identityMapper.getEntryForID((String)((Object)list));
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", directoryException));
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n27 = 1245503;
            String string25 = MessageHandler.getMessage(n27, String.valueOf(object7), directoryException.getErrorMessage());
            bindOperation.setAuthFailureReason(n27, string25);
            return;
        }
        if (entry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n28 = 1245415;
            String string26 = MessageHandler.getMessage(n28, object7);
            bindOperation.setAuthFailureReason(n28, string26);
            return;
        }
        bindOperation.setSASLAuthUserEntry(entry);
        try {
            PasswordPolicyState passwordPolicyState = new PasswordPolicyState(entry, false, false);
            list = passwordPolicyState.getClearPasswords();
            if (list == null || list.isEmpty()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                int n29 = 1245420;
                String string27 = MessageHandler.getMessage(n29, String.valueOf(entry.getDN()));
                bindOperation.setAuthFailureReason(n29, string27);
                return;
            }
        }
        catch (Exception exception) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n30 = 1245560;
            String string28 = MessageHandler.getMessage(n30, String.valueOf(entry.getDN()), String.valueOf(exception));
            bindOperation.setAuthFailureReason(n30, string28);
            return;
        }
        boolean bl = false;
        object4 = null;
        for (ByteString object32 : list) {
            try {
                object2 = this.generateResponseDigest((String)object7, (String)((Object)list7), object32.value(), (String)object8, (String)((Object)list2), (String)((Object)list3), (String)((Object)list4), (String)((Object)list6), (String)((Object)list5), string5);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
                Error.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.SEVERE_WARNING, 1179885, StaticUtils.stackTraceToSingleLineString(exception));
                continue;
            }
            if (!Arrays.equals(byArray, object2)) continue;
            bl = true;
            object4 = object32.value();
            break;
        }
        if (!bl) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n31 = 1245419;
            String exception = MessageHandler.getMessage(n31);
            bindOperation.setAuthFailureReason(n31, exception);
            return;
        }
        try {
            object = this.generateResponseAuthDigest((String)object7, (String)((Object)list7), (byte[])object4, (String)object8, (String)((Object)list2), (String)((Object)list3), (String)((Object)list4), (String)((Object)list6), (String)((Object)list5), string5);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n2 = 1310958;
            String string2 = MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(exception));
            bindOperation.setAuthFailureReason(n2, string2);
            return;
        }
        ASN1OctetString aSN1OctetString2 = new ASN1OctetString("rspauth=" + this.getHexString((byte[])object));
        digestMD5StateInfo.setNonceCount((String)((Object)list4));
        bindOperation.setResultCode(ResultCode.SUCCESS);
        bindOperation.setServerSASLCredentials(aSN1OctetString2);
        object2 = new AuthenticationInfo(entry.getDN(), "DIGEST-MD5", DirectoryServer.isRootDN(entry.getDN()));
        bindOperation.getClientConnection().setAuthenticationInfo((AuthenticationInfo)object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateNonce() {
        assert (Debug.debugEnter(CLASS_NAME, "generateNonce", new String[0]));
        byte[] byArray = new byte[16];
        this.digestLock.lock();
        try {
            this.randomGenerator.nextBytes(byArray);
        }
        finally {
            this.digestLock.unlock();
        }
        return Base64.encode(byArray);
    }

    private int readToken(String string, int n, int n2, StringBuilder stringBuilder) throws DirectoryException {
        char c;
        assert (Debug.debugEnter(CLASS_NAME, "readToken", String.valueOf(string), String.valueOf(n), String.valueOf(n2), "java.lang.StringBuilder"));
        if (n >= n2) {
            return n;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n;
        if ((c = string.charAt(n3++)) == ',') {
            return n3;
        }
        if (c == '\"') {
            bl2 = true;
        } else if (c == '\\') {
            bl = true;
        } else {
            stringBuilder.append(c);
        }
        while (n3 < n2) {
            c = string.charAt(n3++);
            if (bl) {
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            if (c == ',') {
                if (!bl2) break;
                stringBuilder.append(c);
                continue;
            }
            if (c == '\"') {
                if (bl2) {
                    char c2;
                    if (n3 >= n2 || (c2 = string.charAt(n3++)) == ',') break;
                    int n4 = 1245423;
                    String string2 = MessageHandler.getMessage(n4, n3 - 2);
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string2, n4);
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateResponseDigest(String string, String string2, byte[] byArray, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws UnsupportedEncodingException {
        assert (Debug.debugEnter(CLASS_NAME, "generateResponseDigest", String.valueOf(string), String.valueOf(string2), String.valueOf(byArray), String.valueOf(string3), String.valueOf(string4), String.valueOf(string5), String.valueOf(string6), String.valueOf(string7), String.valueOf(string9)));
        this.digestLock.lock();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(':');
            stringBuilder.append(string3);
            stringBuilder.append(':');
            byte[] byArray2 = stringBuilder.toString().getBytes(string9);
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            byte[] byArray4 = this.md5Digest.digest(byArray3);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(':');
            stringBuilder2.append(string4);
            stringBuilder2.append(':');
            stringBuilder2.append(string5);
            if (string2 != null) {
                stringBuilder2.append(':');
                stringBuilder2.append(string2);
            }
            byte[] byArray5 = stringBuilder2.toString().getBytes(string9);
            byte[] byArray6 = new byte[byArray4.length + byArray5.length];
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
            System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
            byte[] byArray7 = this.md5Digest.digest(byArray6);
            byte[] byArray8 = ("AUTHENTICATE:" + string7).getBytes(string9);
            byte[] byArray9 = this.md5Digest.digest(byArray8);
            String string10 = this.getHexString(byArray7);
            String string11 = this.getHexString(byArray9);
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append(string10);
            stringBuilder3.append(':');
            stringBuilder3.append(string4);
            stringBuilder3.append(':');
            stringBuilder3.append(string6);
            stringBuilder3.append(':');
            stringBuilder3.append(string5);
            stringBuilder3.append(':');
            stringBuilder3.append(string8);
            stringBuilder3.append(':');
            stringBuilder3.append(string11);
            byte[] byArray10 = this.md5Digest.digest(stringBuilder3.toString().getBytes(string9));
            return byArray10;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateResponseAuthDigest(String string, String string2, byte[] byArray, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws UnsupportedEncodingException {
        assert (Debug.debugEnter(CLASS_NAME, "generateResponseDigest", String.valueOf(string), String.valueOf(string2), String.valueOf(byArray), String.valueOf(string3), String.valueOf(string4), String.valueOf(string5), String.valueOf(string6), String.valueOf(string7), String.valueOf(string9)));
        this.digestLock.lock();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(':');
            stringBuilder.append(string3);
            stringBuilder.append(':');
            byte[] byArray2 = stringBuilder.toString().getBytes(string9);
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            byte[] byArray4 = this.md5Digest.digest(byArray3);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(':');
            stringBuilder2.append(string4);
            stringBuilder2.append(':');
            stringBuilder2.append(string5);
            if (string2 != null) {
                stringBuilder2.append(':');
                stringBuilder2.append(string2);
            }
            byte[] byArray5 = stringBuilder2.toString().getBytes(string9);
            byte[] byArray6 = new byte[byArray4.length + byArray5.length];
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
            System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
            byte[] byArray7 = this.md5Digest.digest(byArray6);
            String string10 = ":" + string7;
            if (string8.equals("auth-int") || string8.equals("auth-conf")) {
                string10 = string10 + ":00000000000000000000000000000000";
            }
            byte[] byArray8 = string10.getBytes(string9);
            byte[] byArray9 = this.md5Digest.digest(byArray8);
            String string11 = this.getHexString(byArray7);
            String string12 = this.getHexString(byArray9);
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append(string11);
            stringBuilder3.append(':');
            stringBuilder3.append(string4);
            stringBuilder3.append(':');
            stringBuilder3.append(string6);
            stringBuilder3.append(':');
            stringBuilder3.append(string5);
            stringBuilder3.append(':');
            stringBuilder3.append(string8);
            stringBuilder3.append(':');
            stringBuilder3.append(string12);
            byte[] byArray10 = this.md5Digest.digest(stringBuilder3.toString().getBytes(string9));
            return byArray10;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    private String getHexString(byte[] byArray) {
        assert (Debug.debugEnter(CLASS_NAME, "getHexString", String.valueOf(byArray)));
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(StaticUtils.byteToLowerHex(by));
        }
        return stringBuilder.toString();
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048891;
        linkedList.add(new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false, this.identityMapperDN));
        n = 1048774;
        linkedList.add(new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false, this.realm));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        int n = 1048891;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            IdentityMapper identityMapper;
            configAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (configAttribute == null) {
                n = 1245500;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                return false;
            }
            object = configAttribute.pendingValue();
            if (!((DN)object).equals(this.identityMapperDN) && (identityMapper = DirectoryServer.getIdentityMapper((DN)object)) == null) {
                n = 1245501;
                list.add(MessageHandler.getMessage(n, String.valueOf(object), String.valueOf(this.configEntryDN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245502;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 1048774;
        configAttribute = new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1310919;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        int n;
        IdentityMapper identityMapper;
        DN dN;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block23: {
            assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            dN = null;
            identityMapper = null;
            n = 1048891;
            DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
            try {
                object = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
                if (object == null) {
                    n = 1245500;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                } else {
                    dN = ((DNConfigAttribute)object).pendingValue();
                    if (!dN.equals(this.identityMapperDN) && (identityMapper = DirectoryServer.getIdentityMapper(dN)) == null) {
                        n = 1245501;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.configEntryDN)));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 1245502;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            object = null;
            n = 1048774;
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute2 != null) {
                    object = stringConfigAttribute2.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 1310919;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block23;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (dN != null && this.identityMapper != null) {
                this.identityMapperDN = dN;
                this.identityMapper = identityMapper;
                if (bl) {
                    n = 0x100140;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.identityMapperDN)));
                }
            }
            if (this.realm == null) {
                if (object != null) {
                    this.realm = object;
                    if (bl) {
                        n = 1048818;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.realm)));
                    }
                }
            } else if (object == null) {
                this.realm = null;
                if (bl) {
                    n = 1048819;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                }
            } else if (!this.realm.equals(object)) {
                this.realm = object;
                if (bl) {
                    n = 1048818;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.realm)));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    @Override
    public boolean isPasswordBased(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isPasswordBased", String.valueOf(string)));
        return true;
    }

    @Override
    public boolean isSecure(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", String.valueOf(string)));
        return true;
    }
}

