/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.extensions.GSSAPIStateInfo;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSAPISASLMechanismHandler
extends SASLMechanismHandler
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.GSSAPISASLMechanismHandler";
    private DN configEntryDN;
    private DN identityMapperDN;
    private IdentityMapper identityMapper;
    private String kdcAddress;
    private String keyTabFile;
    private String realm;
    private String serverFQDN;

    public GSSAPISASLMechanismHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSASLMechanismHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        StringConfigAttribute stringConfigAttribute;
        StringConfigAttribute stringConfigAttribute2;
        StringConfigAttribute stringConfigAttribute3;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializeSASLMechanismHandler", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        int n = 1048925;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            configAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (configAttribute == null) {
                n = 1245534;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            this.identityMapperDN = configAttribute.activeValue();
            this.identityMapper = DirectoryServer.getIdentityMapper(this.identityMapperDN);
            if (this.identityMapper == null) {
                n = 1245535;
                String string = MessageHandler.getMessage(n, String.valueOf(this.identityMapperDN), String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1245536;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        n = 1048825;
        configAttribute = new StringConfigAttribute("ds-cfg-server-fqdn", MessageHandler.getMessage(n), false, false, false);
        try {
            stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            this.serverFQDN = stringConfigAttribute3 == null ? InetAddress.getLocalHost().getCanonicalHostName() : stringConfigAttribute3.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1310970;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.kdcAddress = null;
        n = 0x100100;
        stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-kdc-address", MessageHandler.getMessage(n), false, false, false);
        try {
            stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
            if (stringConfigAttribute2 != null) {
                this.kdcAddress = stringConfigAttribute2.activeValue();
                System.setProperty("java.security.krb5.kdc", this.kdcAddress);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 0x130101;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.realm = null;
        n = 0x100102;
        stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
            if (stringConfigAttribute != null) {
                this.realm = stringConfigAttribute.activeValue();
                System.setProperty("java.security.krb5.realm", this.realm);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 0x130103;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.keyTabFile = null;
        n = 0x100111;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-keytab", MessageHandler.getMessage(n), false, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object != null) {
                this.keyTabFile = ((StringConfigAttribute)object).activeValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1245458;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        try {
            File file = File.createTempFile("login", "conf");
            object = file.getAbsolutePath();
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            bufferedWriter.write(this.getClass().getName() + " {");
            bufferedWriter.newLine();
            bufferedWriter.write("  com.sun.security.auth.module.Krb5LoginModule required storeKey=true useKeyTab=true ");
            if (this.keyTabFile != null) {
                bufferedWriter.write("keyTab=\"" + this.keyTabFile + "\" ");
            }
            bufferedWriter.write("principal=\"ldap/" + this.serverFQDN);
            if (this.realm != null) {
                bufferedWriter.write("@" + this.realm);
            }
            bufferedWriter.write("\";");
            bufferedWriter.newLine();
            bufferedWriter.write("};");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            n = 1310995;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        System.setProperty("java.security.auth.login.config", (String)object);
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        DirectoryServer.registerSASLMechanismHandler("GSSAPI", this);
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSASLMechanismHandler", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
        DirectoryServer.deregisterSASLMechanismHandler("GSSAPI");
    }

    @Override
    public void processSASLBind(BindOperation bindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(bindOperation)));
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (clientConnection == null) {
            int n = 1245444;
            String string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            return;
        }
        GSSAPIStateInfo gSSAPIStateInfo = null;
        Object object = clientConnection.getSASLAuthStateInfo();
        if (object != null && object instanceof GSSAPIStateInfo) {
            gSSAPIStateInfo = (GSSAPIStateInfo)object;
        } else {
            try {
                gSSAPIStateInfo = new GSSAPIStateInfo(this, bindOperation, this.serverFQDN);
            }
            catch (InitializationException initializationException) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", initializationException));
                bindOperation.setAuthFailureReason(initializationException.getMessageID(), initializationException.getMessage());
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                clientConnection.setSASLAuthStateInfo(null);
                return;
            }
        }
        gSSAPIStateInfo.setBindOperation(bindOperation);
        gSSAPIStateInfo.processAuthenticationStage();
        if (bindOperation.getResultCode() == ResultCode.SUCCESS) {
            DN dN = gSSAPIStateInfo.getUserEntry().getDN();
            AuthenticationInfo authenticationInfo = new AuthenticationInfo(dN, "GSSAPI", DirectoryServer.isRootDN(dN));
            clientConnection.setAuthenticationInfo(authenticationInfo);
            bindOperation.setResultCode(ResultCode.SUCCESS);
            clientConnection.setSASLAuthStateInfo(null);
            try {
                gSSAPIStateInfo.dispose();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
            }
        } else if (bindOperation.getResultCode() == ResultCode.SASL_BIND_IN_PROGRESS) {
            clientConnection.setSASLAuthStateInfo(gSSAPIStateInfo);
        } else {
            clientConnection.setSASLAuthStateInfo(null);
        }
    }

    public Entry getUserForAuthzID(BindOperation bindOperation, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getUserForAuthzID", String.valueOf(bindOperation), String.valueOf(string)));
        return this.identityMapper.getEntryForID(string);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048925;
        linkedList.add(new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false, this.identityMapperDN));
        n = 1048825;
        linkedList.add(new StringConfigAttribute("ds-cfg-server-fqdn", MessageHandler.getMessage(n), false, false, false, this.serverFQDN));
        n = 0x100100;
        linkedList.add(new StringConfigAttribute("ds-cfg-kdc-address", MessageHandler.getMessage(n), false, false, false, this.kdcAddress));
        n = 0x100102;
        linkedList.add(new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false, this.realm));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        Object object2;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        int n = 1048925;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            configAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (configAttribute == null) {
                n = 1245534;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                list.add(string);
                return false;
            }
            object2 = configAttribute.activeValue();
            object = DirectoryServer.getIdentityMapper((DN)object2);
            if (object == null) {
                n = 1245535;
                String string = MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN));
                list.add(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1245536;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string);
            return false;
        }
        n = 1048825;
        configAttribute = new StringConfigAttribute("ds-cfg-server-fqdn", MessageHandler.getMessage(n), false, false, false);
        try {
            object2 = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1310970;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 0x100100;
        object2 = new StringConfigAttribute("ds-cfg-kdc-address", MessageHandler.getMessage(n), false, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 0x130101;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 0x100102;
        object = new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false);
        try {
            StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 0x130103;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n;
        IdentityMapper identityMapper;
        DN dN;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block53: {
            block52: {
                block51: {
                    block50: {
                        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
                        resultCode = ResultCode.SUCCESS;
                        bl2 = false;
                        arrayList = new ArrayList<String>();
                        dN = null;
                        identityMapper = null;
                        n = 1048925;
                        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
                        try {
                            object3 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
                            if (object3 == null) {
                                n = 1245534;
                                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                                if (resultCode == ResultCode.SUCCESS) {
                                    resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                                }
                            } else {
                                dN = ((DNConfigAttribute)object3).activeValue();
                                identityMapper = DirectoryServer.getIdentityMapper(dN);
                                if (identityMapper == null) {
                                    n = 1245535;
                                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.configEntryDN)));
                                    if (resultCode == ResultCode.SUCCESS) {
                                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
                            n = 1245536;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                            if (resultCode != ResultCode.SUCCESS) break block50;
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                    }
                    object3 = null;
                    n = 1048825;
                    StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-server-fqdn", MessageHandler.getMessage(n), false, false, false);
                    try {
                        object2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                        object3 = object2 == null ? InetAddress.getLocalHost().getCanonicalHostName() : ((StringConfigAttribute)object2).pendingValue();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n = 1310970;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode != ResultCode.SUCCESS) break block51;
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
                object2 = null;
                n = 0x100100;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-kdc-address", MessageHandler.getMessage(n), false, false, false);
                try {
                    object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                    if (object != null) {
                        object2 = ((StringConfigAttribute)object).pendingValue();
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n = 0x130101;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode != ResultCode.SUCCESS) break block52;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            object = null;
            n = 0x100102;
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-realm", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute2 != null) {
                    object = stringConfigAttribute2.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 0x130103;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block53;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (!this.identityMapperDN.equals(dN)) {
                this.identityMapperDN = dN;
                this.identityMapper = identityMapper;
                if (bl) {
                    n = 0x100161;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.identityMapperDN)));
                }
            }
            if (this.serverFQDN == null) {
                if (object3 != null) {
                    this.serverFQDN = object3;
                    if (bl) {
                        n = 1048829;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.serverFQDN)));
                    }
                }
            } else if (object3 == null) {
                this.serverFQDN = null;
                if (bl) {
                    n = 1048830;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                }
            } else if (!this.serverFQDN.equals(object3)) {
                this.serverFQDN = object3;
                if (bl) {
                    n = 1048829;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.serverFQDN)));
                }
            }
            if (this.kdcAddress == null) {
                if (object2 != null) {
                    this.kdcAddress = object2;
                    System.setProperty("java.security.krb5.kdc", this.kdcAddress);
                    if (bl) {
                        n = 0x10010B;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(this.kdcAddress)));
                    }
                }
            } else if (object2 == null) {
                this.kdcAddress = null;
                System.clearProperty("java.security.krb5.kdc");
                if (bl) {
                    n = 0x10010C;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                }
            } else if (!this.kdcAddress.equals(object2)) {
                this.kdcAddress = object2;
                System.setProperty("java.security.krb5.kdc", this.kdcAddress);
                if (bl) {
                    n = 0x10010B;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.kdcAddress)));
                }
            }
            if (this.realm == null) {
                if (object != null) {
                    this.realm = object;
                    System.setProperty("java.security.krb5.realm", this.realm);
                    if (bl) {
                        n = 0x10010D;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.realm)));
                    }
                }
            } else if (object == null) {
                this.realm = null;
                System.clearProperty("java.security.krb5.realm");
                if (bl) {
                    n = 0x10010E;
                    arrayList.add(MessageHandler.getMessage(n));
                }
            } else if (!this.realm.equals(object)) {
                this.realm = object;
                System.setProperty("java.security.krb5.realm", this.realm);
                if (bl) {
                    n = 0x10010D;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.realm)));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    @Override
    public boolean isPasswordBased(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isPasswordBased", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean isSecure(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", String.valueOf(string)));
        return true;
    }
}

