/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.AlertHandler;
import org.opends.server.api.DirectoryServerMBean;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.JMXMBean;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;

public class JMXAlertHandler
extends NotificationBroadcasterSupport
implements AlertHandler,
DynamicMBean,
DirectoryServerMBean {
    private static final String CLASS_NAME = "org.opends.server.extensions.JMXAlertHandler";
    private AtomicLong sequenceNumber;
    private DN configEntryDN;
    private ObjectName objectName;

    public JMXAlertHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeAlertHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeAlertHandler", String.valueOf(configEntry)));
        this.sequenceNumber = new AtomicLong(1L);
        this.configEntryDN = configEntry == null ? null : configEntry.getDN();
        MBeanServer mBeanServer = DirectoryServer.getJMXMBeanServer();
        if (mBeanServer != null) {
            try {
                String string = "org.opends.server:type=JMXAlertHandler";
                this.objectName = new ObjectName(string);
                if (mBeanServer.isRegistered(this.objectName)) {
                    mBeanServer.unregisterMBean(this.objectName);
                }
                mBeanServer.registerMBean(this, this.objectName);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeAlertHandler", exception));
                int n = 1245188;
                String string = MessageHandler.getMessage(n, String.valueOf(exception));
                throw new InitializationException(n, string, exception);
            }
        }
    }

    public void finalizeAlertHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeAlertHandler", new String[0]));
    }

    public ObjectName getObjectName() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectName", new String[0]));
        return this.objectName;
    }

    public void sendAlertNotification(AlertGenerator alertGenerator, String string, int n, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "sendAlertNotification", String.valueOf(alertGenerator), String.valueOf(n), String.valueOf(string2)));
        this.sendNotification(new Notification(string, alertGenerator.getClassName(), this.sequenceNumber.getAndIncrement(), System.currentTimeMillis(), string2));
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "getNotificationInfo", new String[0]));
        ArrayList<MBeanNotificationInfo> arrayList = new ArrayList<MBeanNotificationInfo>();
        ConcurrentHashMap<DN, JMXMBean> concurrentHashMap = DirectoryServer.getJMXMBeans();
        for (JMXMBean jMXMBean : concurrentHashMap.values()) {
            MBeanInfo mBeanInfo = jMXMBean.getMBeanInfo();
            for (MBeanNotificationInfo mBeanNotificationInfo : mBeanInfo.getNotifications()) {
                arrayList.add(mBeanNotificationInfo);
            }
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[arrayList.size()];
        arrayList.toArray(mBeanNotificationInfoArray);
        return mBeanNotificationInfoArray;
    }

    public Attribute getAttribute(String string) throws AttributeNotFoundException {
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", new String[0]));
        int n = 3342410;
        String string2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string);
        throw new AttributeNotFoundException(string2);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        assert (Debug.debugEnter(CLASS_NAME, "setAttribute", String.valueOf(attribute)));
        int n = 3342410;
        String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), attribute);
        throw new AttributeNotFoundException(string);
    }

    public AttributeList getAttributes(String[] stringArray) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", String.valueOf(stringArray)));
        return new AttributeList();
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributes", String.valueOf(attributeList)));
        return new AttributeList();
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "invoke", String.valueOf(string), String.valueOf(objectArray), String.valueOf(stringArray)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("(");
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (n = 1; n < stringArray.length; ++n) {
                stringBuilder.append(", ");
                stringBuilder.append(stringArray[n]);
            }
        }
        stringBuilder.append(")");
        n = 3342414;
        String string2 = MessageHandler.getMessage(n, stringBuilder.toString(), String.valueOf(this.configEntryDN));
        throw new MBeanException(new ConfigException(n, string2));
    }

    public MBeanInfo getMBeanInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "getMBeanInfo", new String[0]));
        return new MBeanInfo(CLASS_NAME, "JMX Alert Handler", new MBeanAttributeInfo[0], new MBeanConstructorInfo[0], new MBeanOperationInfo[0], this.getNotificationInfo());
    }
}

