/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DisconnectReason;
import org.opends.server.util.StaticUtils;

public class NullConnectionSecurityProvider
extends ConnectionSecurityProvider {
    private static final String CLASS_NAME = "org.opends.server.extensions.NullConnectionSecurityProvider";
    private static final int BUFFER_SIZE = 4096;
    private ByteBuffer clearBuffer;
    private ClientConnection clientConnection;
    private SocketChannel socketChannel;

    public NullConnectionSecurityProvider() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    protected NullConnectionSecurityProvider(ClientConnection clientConnection, SocketChannel socketChannel) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection)));
        this.clientConnection = clientConnection;
        this.socketChannel = socketChannel;
        this.clearBuffer = ByteBuffer.allocate(4096);
    }

    public void initializeConnectionSecurityProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeConnectionSecurityProvider", String.valueOf(configEntry)));
        this.clearBuffer = null;
        this.clientConnection = null;
        this.socketChannel = null;
    }

    public void finalizeConnectionSecurityProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeConnectionSecurityProvider", new String[0]));
    }

    public String getSecurityMechanismName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecurityMechanismName", new String[0]));
        return "NULL";
    }

    public boolean isSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", new String[0]));
        return false;
    }

    public ConnectionSecurityProvider newInstance(ClientConnection clientConnection, SocketChannel socketChannel) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "newInstance", String.valueOf(clientConnection), String.valueOf(socketChannel)));
        return new NullConnectionSecurityProvider(clientConnection, socketChannel);
    }

    public void disconnect(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "disconnect", new String[0]));
    }

    public int getClearBufferSize() {
        assert (Debug.debugEnter(CLASS_NAME, "getClearBufferSize", new String[0]));
        return 4096;
    }

    public int getEncodedBufferSize() {
        assert (Debug.debugEnter(CLASS_NAME, "getEncodedBufferSize", new String[0]));
        return 4096;
    }

    public boolean readData() {
        assert (Debug.debugEnter(CLASS_NAME, "readData", new String[0]));
        this.clearBuffer.clear();
        try {
            do {
                int n = this.socketChannel.read(this.clearBuffer);
                this.clearBuffer.flip();
                if (n < 0) {
                    this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                    return false;
                }
                if (n != 0) continue;
                return true;
            } while (this.clientConnection.processDataRead(this.clearBuffer));
            return false;
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "readData", iOException));
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, -1, new Object[0]);
            return false;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "readData", exception));
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, 1310830, StaticUtils.stackTraceToSingleLineString(exception));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeData(ByteBuffer byteBuffer) {
        assert (Debug.debugEnter(CLASS_NAME, "writeData", "java.nio.ByteBuffer"));
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        try {
            int n3;
            while (byteBuffer.hasRemaining()) {
                n3 = this.socketChannel.write(byteBuffer);
                if (n3 >= 0) continue;
                this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, -1, new Object[0]);
                boolean bl = false;
                return bl;
            }
            n3 = 1;
            return n3 != 0;
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "writeData", iOException));
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, -1, new Object[0]);
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "writeData", exception));
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, 1310831, StaticUtils.stackTraceToSingleLineString(exception));
            boolean bl = false;
            return bl;
        }
        finally {
            byteBuffer.position(n);
            byteBuffer.limit(n2);
        }
    }
}

