/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.NamedCharacterSet;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomPasswordGenerator
extends PasswordGenerator
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.RandomPasswordGenerator";
    private List<String> encodedCharacterSets;
    private DN configEntryDN;
    private int totalLength;
    private int[] characterCounts;
    private NamedCharacterSet[] characterSets;
    private ReentrantLock generatorLock;
    private String formatString;

    @Override
    public void initializePasswordGenerator(ConfigEntry configEntry) throws ConfigException, InitializationException {
        StringConfigAttribute stringConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordGenerator", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        this.generatorLock = new ReentrantLock();
        HashMap<String, NamedCharacterSet> hashMap = new HashMap<String, NamedCharacterSet>();
        int n = 1048916;
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-password-character-set", MessageHandler.getMessage(n), true, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
            if (stringConfigAttribute == null) {
                n = 1245525;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            this.encodedCharacterSets = stringConfigAttribute.activeValues();
            for (NamedCharacterSet object : NamedCharacterSet.decodeCharacterSets(this.encodedCharacterSets)) {
                if (hashMap.containsKey(object.getName())) {
                    n = 1245526;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), object.getName());
                    throw new ConfigException(n, string2);
                }
                hashMap.put(object.getName(), object);
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordGenerator", exception));
            n = 1245527;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        n = 1048920;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-password-format", MessageHandler.getMessage(n), true, false, false);
        try {
            StringConfigAttribute stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute3 == null) {
                n = 1245529;
                String string = MessageHandler.getMessage(n);
                throw new ConfigException(n, string);
            }
            this.formatString = stringConfigAttribute3.activeValue();
            StringTokenizer stringTokenizer = new StringTokenizer(this.formatString, ", ");
            ArrayList<NamedCharacterSet> arrayList = new ArrayList<NamedCharacterSet>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreTokens()) {
                String string;
                String i = stringTokenizer.nextToken();
                try {
                    int configException = i.indexOf(58);
                    string = i.substring(0, configException);
                    int n2 = Integer.parseInt(i.substring(configException + 1));
                    NamedCharacterSet namedCharacterSet = (NamedCharacterSet)hashMap.get(string);
                    if (namedCharacterSet == null) {
                        n = 1245530;
                        String string2 = MessageHandler.getMessage(n, String.valueOf(this.formatString), String.valueOf(string));
                        throw new ConfigException(n, string2);
                    }
                    arrayList.add(namedCharacterSet);
                    arrayList2.add(n2);
                }
                catch (ConfigException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializePasswordGenerator", exception));
                    n = 1245531;
                    string = MessageHandler.getMessage(n, String.valueOf(this.formatString));
                    throw new ConfigException(n, string, exception);
                }
            }
            this.characterSets = new NamedCharacterSet[arrayList.size()];
            this.characterCounts = new int[this.characterSets.length];
            this.totalLength = 0;
            for (int i = 0; i < this.characterSets.length; ++i) {
                this.characterSets[i] = (NamedCharacterSet)arrayList.get(i);
                this.characterCounts[i] = (Integer)arrayList2.get(i);
                this.totalLength += this.characterCounts[i];
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordGenerator", exception));
            n = 1245532;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizePasswordGenerator() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizePasswordGenerator", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ASN1OctetString generatePassword(Entry entry) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "generatePassword", String.valueOf(entry)));
        StringBuilder stringBuilder = new StringBuilder(this.totalLength);
        this.generatorLock.lock();
        try {
            for (int i = 0; i < this.characterSets.length; ++i) {
                this.characterSets[i].getRandomCharacters(stringBuilder, this.characterCounts[i]);
            }
        }
        finally {
            this.generatorLock.unlock();
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.characterSets.length; ++n) {
            String string = this.characterSets[n].encode();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        n = 1048916;
        linkedList.add(new StringConfigAttribute("ds-cfg-password-character-set", MessageHandler.getMessage(n), true, true, false, arrayList));
        n = 1048920;
        linkedList.add(new StringConfigAttribute("ds-cfg-password-format", MessageHandler.getMessage(n), true, false, false, this.formatString));
        return linkedList;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        StringConfigAttribute stringConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        HashMap<String, NamedCharacterSet> hashMap = new HashMap<String, NamedCharacterSet>();
        int n = 1048916;
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-password-character-set", MessageHandler.getMessage(n), true, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
            if (stringConfigAttribute == null) {
                n = 1245525;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                list.add(string);
                return false;
            }
            for (NamedCharacterSet namedCharacterSet : NamedCharacterSet.decodeCharacterSets(stringConfigAttribute.activeValues())) {
                if (hashMap.containsKey(namedCharacterSet.getName())) {
                    n = 1245526;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), namedCharacterSet.getName());
                    list.add(string);
                    return false;
                }
                hashMap.put(namedCharacterSet.getName(), namedCharacterSet);
            }
        }
        catch (ConfigException configException) {
            list.add(configException.getMessage());
            return false;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245527;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string);
            return false;
        }
        n = 1048920;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-password-format", MessageHandler.getMessage(n), true, false, false);
        try {
            StringConfigAttribute stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute3 == null) {
                list.add(MessageHandler.getMessage(1245529));
                return false;
            }
            String string = stringConfigAttribute3.activeValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                try {
                    int n2 = string3.indexOf(58);
                    string2 = string3.substring(0, n2);
                    int n3 = Integer.parseInt(string3.substring(n2 + 1));
                    NamedCharacterSet namedCharacterSet = (NamedCharacterSet)hashMap.get(string2);
                    if (namedCharacterSet != null) continue;
                    n = 1245530;
                    String string4 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(string2));
                    list.add(string4);
                    return false;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                    n = 1245531;
                    string2 = MessageHandler.getMessage(n, String.valueOf(string));
                    list.add(string2);
                    return false;
                    return true;
                }
            }
        }
        catch (ConfigException configException) {
            list.add(configException.getMessage());
            return false;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245532;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        String string;
        ArrayList arrayList;
        Object object;
        List<String> list;
        ArrayList<String> arrayList2;
        boolean bl2;
        ResultCode resultCode;
        block30: {
            int n;
            HashMap<String, NamedCharacterSet> hashMap;
            block29: {
                assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
                resultCode = ResultCode.SUCCESS;
                bl2 = false;
                arrayList2 = new ArrayList<String>();
                list = null;
                hashMap = new HashMap<String, NamedCharacterSet>();
                n = 1048916;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-password-character-set", MessageHandler.getMessage(n), true, true, false);
                try {
                    object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                    if (object == null) {
                        n = 1245525;
                        arrayList2.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                        }
                    } else {
                        list = ((StringConfigAttribute)object).activeValues();
                        for (NamedCharacterSet object2 : NamedCharacterSet.decodeCharacterSets(this.encodedCharacterSets)) {
                            if (hashMap.containsKey(object2.getName())) {
                                n = 1245526;
                                arrayList2.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), object2.getName()));
                                if (resultCode != ResultCode.SUCCESS) continue;
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                continue;
                            }
                            hashMap.put(object2.getName(), object2);
                        }
                    }
                }
                catch (ConfigException configException) {
                    arrayList2.add(configException.getMessage());
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializePasswordGenerator", exception));
                    n = 1245527;
                    arrayList2.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode != ResultCode.SUCCESS) break block29;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            object = new ArrayList();
            arrayList = new ArrayList();
            string = null;
            n = 1048920;
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-password-format", MessageHandler.getMessage(n), true, false, false);
            try {
                StringConfigAttribute configException = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (configException == null) {
                    n = 1245529;
                    arrayList2.add(MessageHandler.getMessage(1245529));
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                    }
                } else {
                    string = configException.activeValue();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        try {
                            int n2 = string2.indexOf(58);
                            String string3 = string2.substring(0, n2);
                            int n3 = Integer.parseInt(string2.substring(n2 + 1));
                            NamedCharacterSet namedCharacterSet = (NamedCharacterSet)hashMap.get(string3);
                            if (namedCharacterSet == null) {
                                n = 1245530;
                                arrayList2.add(MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(string3)));
                                if (resultCode != ResultCode.SUCCESS) continue;
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                continue;
                            }
                            ((ArrayList)object).add(namedCharacterSet);
                            arrayList.add(n3);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializePasswordGenerator", exception));
                            n = 1245531;
                            arrayList2.add(MessageHandler.getMessage(n, String.valueOf(string)));
                            if (resultCode != ResultCode.SUCCESS) continue;
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                    }
                }
            }
            catch (ConfigException exception) {
                arrayList2.add(exception.getMessage());
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            catch (Exception i) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordGenerator", i));
                n = 1245532;
                arrayList2.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(i)));
                if (resultCode != ResultCode.SUCCESS) break block30;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.generatorLock.lock();
            try {
                void var14_24;
                this.encodedCharacterSets = list;
                this.formatString = string;
                this.characterSets = new NamedCharacterSet[((ArrayList)object).size()];
                this.characterCounts = new int[this.characterSets.length];
                this.totalLength = 0;
                boolean bl3 = false;
                while (var14_24 < this.characterCounts.length) {
                    this.characterSets[var14_24] = (NamedCharacterSet)((ArrayList)object).get((int)var14_24);
                    this.characterCounts[var14_24] = (Integer)arrayList.get((int)var14_24);
                    this.totalLength += this.characterCounts[var14_24];
                    ++var14_24;
                }
            }
            finally {
                this.generatorLock.unlock();
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList2);
    }
}

