/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.ErrorLogger;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.DirectoryFileFormatter;
import org.opends.server.loggers.DirectoryFileHandler;
import org.opends.server.loggers.DirectoryLogLevel;
import org.opends.server.loggers.LoggerThread;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationConfigUtil;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.SizeBasedRotationPolicy;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryErrorLogger
extends ErrorLogger
implements ConfigurableComponent {
    private static final int DEFAULT_TIME_INTERVAL = 30000;
    private static final int DEFAULT_BUFFER_SIZE = 0;
    private Logger errorLogger = null;
    private DirectoryFileHandler fileHandler = null;
    private HashMap<ErrorLogCategory, HashSet<ErrorLogSeverity>> definedSeverities;
    private HashSet<ErrorLogSeverity> defaultSeverities;
    private DN configDN;

    @Override
    public void initializeErrorLogger(ConfigEntry configEntry) throws ConfigException {
        Object object;
        Object object2;
        this.configDN = configEntry.getDN();
        this.defaultSeverities = new HashSet();
        HashSet<String> hashSet = new HashSet<String>();
        for (ErrorLogSeverity errorLogSeverity : ErrorLogSeverity.values()) {
            hashSet.add(errorLogSeverity.toString().toLowerCase());
        }
        List<String> list = this.getSeverities(configEntry, "ds-cfg-default-severity", hashSet);
        if (list.isEmpty()) {
            this.defaultSeverities.add(ErrorLogSeverity.FATAL_ERROR);
            this.defaultSeverities.add(ErrorLogSeverity.SEVERE_ERROR);
            this.defaultSeverities.add(ErrorLogSeverity.SEVERE_WARNING);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ErrorLogSeverity errorLogSeverity;
                String string = (String)iterator.next();
                errorLogSeverity = ErrorLogSeverity.getByName(string);
                if (errorLogSeverity != null) {
                    this.defaultSeverities.add(errorLogSeverity);
                    continue;
                }
                System.err.println("Ignoring invalid severity name:" + string);
            }
        }
        this.definedSeverities = new HashMap();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (ErrorLogCategory errorLogCategory : ErrorLogCategory.values()) {
            for (ErrorLogSeverity object32 : ErrorLogSeverity.values()) {
                object2 = errorLogCategory.toString().toLowerCase() + "=" + object32.toString().toLowerCase();
                hashSet2.add((String)object2);
            }
        }
        List<String> list2 = this.getSeverities(configEntry, "ds-cfg-override-severity", hashSet2);
        Object object4 = list2.iterator();
        while (object4.hasNext()) {
            String string = (String)object4.next();
            if (string == null) continue;
            int n = string.indexOf(61);
            if (n < 0) {
                System.err.println("Invalid override of severity level. Ignoring...");
                continue;
            }
            object = string.substring(0, n);
            ErrorLogCategory errorLogCategory = ErrorLogCategory.getByName((String)object);
            if (errorLogCategory == null) {
                System.err.println("Invalid error log category " + (String)object + ". Ignoring ...");
                continue;
            }
            HashSet<ErrorLogSeverity> hashSet3 = new HashSet<ErrorLogSeverity>();
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), ",");
            while (stringTokenizer.hasMoreElements()) {
                object2 = stringTokenizer.nextToken();
                ErrorLogSeverity errorLogSeverity = ErrorLogSeverity.getByName((String)object2);
                if (errorLogSeverity == null) {
                    System.err.println("Invalid error log severity " + (String)object2 + ". Ignoring ...");
                    continue;
                }
                hashSet3.add(errorLogSeverity);
            }
            this.definedSeverities.put(errorLogCategory, hashSet3);
        }
        object4 = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
        StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object4);
        if (stringConfigAttribute == null) {
            int n = 3407954;
            object = MessageHandler.getMessage(n, configEntry.getDN().toString());
            throw new ConfigException(n, (String)object);
        }
        this.errorLogger = Logger.getLogger("org.opends.server.loggers.DirectoryErrorLogger");
        this.errorLogger.setLevel(Level.ALL);
        File file = new File(stringConfigAttribute.activeValue());
        if (!file.isAbsolute()) {
            file = new File(DirectoryServer.getServerRoot() + File.separator + stringConfigAttribute.activeValue());
        }
        try {
            int n;
            object = RotationConfigUtil.getRotationPolicies(configEntry);
            int n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-buffer-size", 0x40000A);
            if (n2 == -1) {
                n2 = 0;
            }
            this.fileHandler = new DirectoryFileHandler(configEntry, file.getAbsolutePath(), n2);
            this.fileHandler.setFormatter(new DirectoryFileFormatter(false));
            this.errorLogger.addHandler(this.fileHandler);
            if (object != null) {
                ArrayList<ActionType> arrayList = RotationConfigUtil.getPostRotationActions(configEntry);
                this.fileHandler.setPostRotationActions(arrayList);
                Iterator iterator = ((CopyOnWriteArrayList)object).iterator();
                while (iterator.hasNext()) {
                    object2 = (RotationPolicy)iterator.next();
                    if (!(object2 instanceof SizeBasedRotationPolicy)) continue;
                    long l = ((SizeBasedRotationPolicy)object2).getMaxFileSize();
                    this.fileHandler.setFileSize(l);
                    ((CopyOnWriteArrayList)object).remove(object2);
                }
            }
            CopyOnWriteArrayList<RetentionPolicy> copyOnWriteArrayList = RotationConfigUtil.getRetentionPolicies(configEntry);
            int n3 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-thread-time-interval", 0x400009);
            if (n3 == -1) {
                n = 30000;
            }
            object2 = new LoggerThread("ErrorLogger Thread", n, this.fileHandler, (CopyOnWriteArrayList<RotationPolicy>)object, copyOnWriteArrayList);
            ((Thread)object2).start();
        }
        catch (IOException iOException) {
            int n = 0x440002;
            String string = MessageHandler.getMessage(n, String.valueOf(iOException));
            throw new ConfigException(n, string, iOException);
        }
    }

    @Override
    public void closeErrorLogger() {
        this.fileHandler.close();
    }

    @Override
    public void logError(ErrorLogCategory errorLogCategory, ErrorLogSeverity errorLogSeverity, String string, int n) {
        HashSet<ErrorLogSeverity> hashSet = this.definedSeverities.get((Object)errorLogCategory);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)errorLogSeverity)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("category=").append(errorLogCategory.getCategoryName()).append(" severity=").append(errorLogSeverity.getSeverityName()).append(" msgID=").append(String.valueOf(n)).append(" msg=").append(string);
            this.errorLogger.log(DirectoryLogLevel.FATAL_ERROR, stringBuilder.toString());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.errorLogger.equals(object);
    }

    @Override
    public int hashCode() {
        return this.errorLogger.hashCode();
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return null;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        try {
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute2 == null) {
                int n = 3407954;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                list.add(string);
                return false;
            }
        }
        catch (ConfigException configException) {
            int n = 3407927;
            String string = MessageHandler.getMessage(n, this.getClass().getName(), configEntry.getDN().toString(), String.valueOf(configException));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        this.fileHandler.close();
        try {
            this.initializeErrorLogger(configEntry);
        }
        catch (ConfigException configException) {
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private List<String> getSeverities(ConfigEntry configEntry, String string, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute(string, MessageHandler.getMessage(0x300033), false, true, true, set);
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = null;
        try {
            multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
        }
        catch (ConfigException configException) {
            configException.printStackTrace();
            System.err.println("Cannot retrieve the config value for:" + string);
            return arrayList;
        }
        if (multiChoiceConfigAttribute2 == null) {
            return arrayList;
        }
        return multiChoiceConfigAttribute2.activeValues();
    }
}

