/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class DirectoryFileFormatter
extends Formatter {
    private boolean auditFormat = false;

    public DirectoryFileFormatter(boolean bl) {
        this.auditFormat = bl;
    }

    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.auditFormat) {
            stringBuilder.append("[");
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("]");
            stringBuilder.append(" ");
        }
        String string = logRecord.getMessage();
        stringBuilder.append(string);
        stringBuilder.append(ServerConstants.EOL);
        if (!this.auditFormat && logRecord.getThrown() != null) {
            stringBuilder.append(StaticUtils.stackTraceToString(logRecord.getThrown()));
        }
        return stringBuilder.toString();
    }
}

