/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.loggers.FileNumberRetentionPolicy;
import org.opends.server.loggers.FixedTimeRotationPolicy;
import org.opends.server.loggers.FreeDiskSpaceRetentionPolicy;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.SizeBasedRetentionPolicy;
import org.opends.server.loggers.SizeBasedRotationPolicy;
import org.opends.server.loggers.TimeLimitRotationPolicy;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotationConfigUtil {
    private static final String CLASS_NAME = "org.opends.server.loggers.RotationConfigUtil";

    public static CopyOnWriteArrayList<RotationPolicy> getRotationPolicies(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getRotationPolicies", String.valueOf(configEntry)));
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("size");
        hashSet.add("timeofday");
        hashSet.add("fixedtime");
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-rotation-policy", MessageHandler.getMessage(0x300033), false, true, true, hashSet);
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
        if (multiChoiceConfigAttribute2 == null) {
            int n = 3277024;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string, n);
            return null;
        }
        int n = 0;
        RotationPolicy rotationPolicy = null;
        CopyOnWriteArrayList<RotationPolicy> copyOnWriteArrayList = new CopyOnWriteArrayList<RotationPolicy>();
        List<String> list = multiChoiceConfigAttribute2.activeValues();
        for (String string : list) {
            Object object;
            if ((string = string.trim()).equalsIgnoreCase("Size")) {
                int n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-size-limit", 0x400005);
                if (n2 == -1) {
                    n = 3408097;
                    object = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, (String)object);
                }
                rotationPolicy = new SizeBasedRotationPolicy(n2);
            } else if (string.equalsIgnoreCase("FixedTime")) {
                int n3 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-fixed-time-limit", 0x400006);
                if (n3 == -1) {
                    n = 3408098;
                    object = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, (String)object);
                }
                rotationPolicy = new TimeLimitRotationPolicy(n3);
            } else if (string.equalsIgnoreCase("TimeOfDay")) {
                Object object2;
                String string2;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-time-of-day", MessageHandler.getMessage(0x300033), true, false, true);
                object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (object == null) {
                    n = 3408098;
                    string2 = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, string2);
                }
                string2 = ((StringConfigAttribute)object).activeValue().trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken().trim();
                    arrayList.add(object2);
                }
                object2 = new int[arrayList.size()];
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    String string3 = (String)arrayList.get(i);
                    try {
                        object2[i] = Integer.parseInt(string3);
                        continue;
                    }
                    catch (Exception exception) {
                        String string4 = MessageHandler.getMessage(n, configEntry.getDN().toString());
                        throw new ConfigException(n, string4);
                    }
                }
                rotationPolicy = new FixedTimeRotationPolicy((int[])object2);
            } else {
                n = 3408099;
                String string5 = MessageHandler.getMessage(n, string, configEntry.getDN().toString());
                throw new ConfigException(n, string5);
            }
            copyOnWriteArrayList.add(rotationPolicy);
        }
        return copyOnWriteArrayList;
    }

    public static CopyOnWriteArrayList<RetentionPolicy> getRetentionPolicies(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getRetentionPolicies", String.valueOf(configEntry)));
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
        StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
        if (stringConfigAttribute2 == null) {
            int n = 3407954;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            throw new ConfigException(n, string);
        }
        File file = new File(stringConfigAttribute2.activeValue().trim());
        if (!file.isAbsolute()) {
            file = new File(DirectoryServer.getServerRoot() + File.separator + stringConfigAttribute2.activeValue().trim());
        }
        String string = file.getName();
        String string2 = file.getParent();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("numberoffiles");
        hashSet.add("diskspaceused");
        hashSet.add("freediskspace");
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-retention-policy", MessageHandler.getMessage(0x300033), false, true, true, hashSet);
        MultiChoiceConfigAttribute multiChoiceConfigAttribute2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
        if (multiChoiceConfigAttribute2 == null) {
            int n = 3211621;
            String string3 = MessageHandler.getMessage(n, configEntry.getDN().toString());
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, string3, n);
            return null;
        }
        int n = 0;
        RetentionPolicy retentionPolicy = null;
        CopyOnWriteArrayList<RetentionPolicy> copyOnWriteArrayList = new CopyOnWriteArrayList<RetentionPolicy>();
        List<String> list = multiChoiceConfigAttribute2.activeValues();
        for (String string4 : list) {
            Object object;
            int n2;
            if ((string4 = string4.trim()).equalsIgnoreCase("numberOfFiles")) {
                n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-number-of-files", 0x400007);
                if (n2 == -1) {
                    n = 3277159;
                    object = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, (String)object);
                }
                retentionPolicy = new FileNumberRetentionPolicy(string2, string, n2);
            } else if (string4.equalsIgnoreCase("diskSpaceUsed")) {
                n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-disk-space-used", 0x400008);
                if (n2 == -1) {
                    n = 3277160;
                    object = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, (String)object);
                }
                retentionPolicy = new SizeBasedRetentionPolicy(string2, string, n2);
            } else if (string4.equalsIgnoreCase("freeDiskSpace")) {
                n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-free-disk-space", 0x40000B);
                if (n2 == -1) {
                    n = 3408252;
                    object = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, (String)object);
                }
                try {
                    object = File.class.getMethod("getFreeSpace", new Class[0]);
                }
                catch (Exception exception) {
                    n = 3408253;
                    String string5 = MessageHandler.getMessage(n, configEntry.getDN().toString());
                    throw new ConfigException(n, string5);
                }
                retentionPolicy = new FreeDiskSpaceRetentionPolicy(string2, string, n2);
            } else {
                n = 3277158;
                String string6 = MessageHandler.getMessage(n, string4, configEntry.getDN().toString());
                throw new ConfigException(n, string6);
            }
            copyOnWriteArrayList.add(retentionPolicy);
        }
        return copyOnWriteArrayList;
    }

    public static ArrayList<ActionType> getPostRotationActions(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getPostRotationActions", String.valueOf(configEntry)));
        ArrayList<ActionType> arrayList = new ArrayList<ActionType>();
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-rotation-action", MessageHandler.getMessage(0x300033), true, false, true);
        StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
        if (stringConfigAttribute2 == null) {
            return arrayList;
        }
        String string = stringConfigAttribute2.activeValue().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("GZIPCompress")) {
                arrayList.add(ActionType.GZIP_COMPRESS);
                continue;
            }
            if (string2.equals("ZIPCompress")) {
                arrayList.add(ActionType.ZIP_COMPRESS);
                continue;
            }
            if (string2.equals("Sign")) {
                arrayList.add(ActionType.SIGN);
                continue;
            }
            if (string2.equals("Encrypt")) {
                arrayList.add(ActionType.ENCRYPT);
                continue;
            }
            int n = 0;
            throw new ConfigException(n, MessageHandler.getMessage(n));
        }
        return arrayList;
    }

    public static String getCertificateAlias(ConfigEntry configEntry) {
        String string = null;
        int n = 0x400004;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(n), false, false, true);
        try {
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            string = stringConfigAttribute2 == null ? "server-cert" : stringConfigAttribute2.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getCertificateAlias", exception));
            return null;
        }
        return string;
    }

    public static int getIntegerAttribute(ConfigEntry configEntry, String string, int n) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getIntegerAttribute", String.valueOf(configEntry), string));
        int n2 = -1;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute(string, MessageHandler.getMessage(n), true, false, false, true, 1L, false, 0L, 0L);
        IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
        if (integerConfigAttribute2 != null) {
            n2 = integerConfigAttribute2.activeIntValue();
        }
        return n2;
    }
}

