/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.opends.server.api.DebugLogger;
import org.opends.server.api.ProtocolElement;
import org.opends.server.config.ConfigEntry;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class StartupDebugLogger
extends DebugLogger {
    public static final String ENV_VARIABLE_DEBUG_LOG_LEVEL = "DS_DEBUG_LEVEL";
    private HashMap<DebugLogCategory, HashSet<DebugLogSeverity>> definedSeverities;
    private HashSet<DebugLogSeverity> defaultSeverities;
    private PrintWriter writer;

    public void initializeDebugLogger(ConfigEntry configEntry) {
        this.writer = new PrintWriter(System.err, true);
        this.defaultSeverities = new HashSet();
        this.defaultSeverities.add(DebugLogSeverity.ERROR);
        this.defaultSeverities.add(DebugLogSeverity.WARNING);
        this.definedSeverities = new HashMap();
        String string = System.getenv(ENV_VARIABLE_DEBUG_LOG_LEVEL);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n < 0) {
                    this.writer.println("StartupDebugLogger:  Token \"" + string2 + "\" read from environment variable " + ENV_VARIABLE_DEBUG_LOG_LEVEL + " does not contain " + "an equal sign to separate the category from the " + "severity list.  It will be ignored");
                    continue;
                }
                String string3 = string2.substring(0, n);
                DebugLogCategory debugLogCategory = DebugLogCategory.getByName(string3);
                if (debugLogCategory == null) {
                    this.writer.println("StartupDebugLogger:  Unknown debug log category \"" + string3 + "\" read from environment variable " + ENV_VARIABLE_DEBUG_LOG_LEVEL + " will be ignored.");
                    continue;
                }
                HashSet<DebugLogSeverity> hashSet = new HashSet<DebugLogSeverity>();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2.substring(n + 1), ",");
                while (stringTokenizer2.hasMoreElements()) {
                    String string4 = stringTokenizer2.nextToken();
                    DebugLogSeverity debugLogSeverity = DebugLogSeverity.getByName(string4);
                    if (debugLogSeverity == null) {
                        this.writer.println("StartupDebugLogger:  Unknown debug log severity \"" + string4 + "\" read from environment " + "variable " + ENV_VARIABLE_DEBUG_LOG_LEVEL + " will be ignored.");
                        continue;
                    }
                    hashSet.add(debugLogSeverity);
                }
                this.definedSeverities.put(debugLogCategory, hashSet);
            }
        }
    }

    public void closeDebugLogger() {
    }

    public void debugBytesRead(String string, String string2, ByteBuffer byteBuffer) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.DATA_READ);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=DATA_READ, data:" + ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(stringBuilder, byteBuffer, 5);
            this.writer.println(stringBuilder.toString());
        }
    }

    public void debugBytesWritten(String string, String string2, ByteBuffer byteBuffer) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.DATA_WRITE);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=DATA_WRITE, data:" + ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(stringBuilder, byteBuffer, 5);
            this.writer.println(stringBuilder.toString());
        }
    }

    public void debugConstructor(String string, String ... stringArray) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.CONSTRUCTOR);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.INFO)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=CONSTRUCTOR - ");
            stringBuilder.append(string);
            stringBuilder.append("(");
            switch (stringArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    stringBuilder.append(stringArray[0]);
                    break;
                }
                default: {
                    stringBuilder.append(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append(",");
                        stringBuilder.append(stringArray[i]);
                    }
                }
            }
            stringBuilder.append(")");
            this.writer.println(stringBuilder.toString());
        }
    }

    public void debugEnter(String string, String string2, String ... stringArray) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.METHOD_ENTER);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.INFO)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=ENTER - ");
            stringBuilder.append(string);
            stringBuilder.append(".");
            stringBuilder.append(string2);
            stringBuilder.append("(");
            switch (stringArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    stringBuilder.append(stringArray[0]);
                    break;
                }
                default: {
                    stringBuilder.append(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append(",");
                        stringBuilder.append(stringArray[i]);
                    }
                }
            }
            stringBuilder.append(")");
            this.writer.println(stringBuilder.toString());
        }
    }

    public void debugMessage(DebugLogCategory debugLogCategory, DebugLogSeverity debugLogSeverity, String string, String string2, String string3) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)debugLogCategory);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)debugLogSeverity)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=");
            stringBuilder.append(debugLogCategory.getCategoryName());
            stringBuilder.append(", severity=");
            stringBuilder.append(debugLogSeverity.getSeverityName());
            stringBuilder.append(", class=");
            stringBuilder.append(string);
            stringBuilder.append(", method=");
            stringBuilder.append(string2);
            stringBuilder.append(", msg=\"");
            stringBuilder.append(string3);
            stringBuilder.append("\"");
            this.writer.println(stringBuilder);
        }
    }

    public void debugException(String string, String string2, Throwable throwable) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.EXCEPTION);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.ERROR)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=EXCEPTION, class=");
            stringBuilder.append(string);
            stringBuilder.append(", method=");
            stringBuilder.append(string2);
            stringBuilder.append(", trace:" + ServerConstants.EOL);
            StaticUtils.stackTraceToString(stringBuilder, throwable);
            this.writer.println(stringBuilder);
        }
    }

    public void debugProtocolElementRead(String string, String string2, ProtocolElement protocolElement) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.PROTOCOL_READ);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=PROTOCOL_READ, element:" + ServerConstants.EOL);
            protocolElement.toString(stringBuilder, 5);
            this.writer.println(stringBuilder.toString());
        }
    }

    public void debugProtocolElementWritten(String string, String string2, ProtocolElement protocolElement) {
        HashSet<DebugLogSeverity> hashSet = this.definedSeverities.get((Object)DebugLogCategory.PROTOCOL_WRITE);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)DebugLogSeverity.COMMUNICATION)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=PROTOCOL_WRITE, element:" + ServerConstants.EOL);
            protocolElement.toString(stringBuilder, 5);
            this.writer.println(stringBuilder.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object != null && object instanceof StartupDebugLogger;
    }

    public int hashCode() {
        return 12345;
    }
}

