/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.opends.server.api.ErrorLogger;
import org.opends.server.config.ConfigEntry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.TimeThread;

public class StartupErrorLogger
extends ErrorLogger {
    public static final String ENV_VARIABLE_ERROR_LOG_LEVEL = "DS_ERROR_LEVEL";
    private HashMap<ErrorLogCategory, HashSet<ErrorLogSeverity>> definedSeverities;
    private HashSet<ErrorLogSeverity> defaultSeverities;
    private PrintWriter writer;

    public void initializeErrorLogger(ConfigEntry configEntry) {
        this.writer = new PrintWriter(System.err, true);
        this.defaultSeverities = new HashSet();
        this.defaultSeverities.add(ErrorLogSeverity.FATAL_ERROR);
        this.defaultSeverities.add(ErrorLogSeverity.SEVERE_ERROR);
        this.defaultSeverities.add(ErrorLogSeverity.SEVERE_WARNING);
        this.defaultSeverities.add(ErrorLogSeverity.NOTICE);
        this.definedSeverities = new HashMap();
        String string = System.getenv(ENV_VARIABLE_ERROR_LOG_LEVEL);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n < 0) {
                    this.writer.println("StartupErrorLogger:  Token \"" + string2 + "\" read from environment variable " + ENV_VARIABLE_ERROR_LOG_LEVEL + " does not contain " + "an equal sign to separate the category from the " + "severity list.  It will be ignored");
                    continue;
                }
                String string3 = string2.substring(0, n);
                ErrorLogCategory errorLogCategory = ErrorLogCategory.getByName(string3);
                if (errorLogCategory == null) {
                    this.writer.println("StartupErrorLogger:  Unknown error log category \"" + string3 + "\" read from environment variable " + ENV_VARIABLE_ERROR_LOG_LEVEL + " will be ignored.");
                    continue;
                }
                HashSet<ErrorLogSeverity> hashSet = new HashSet<ErrorLogSeverity>();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2.substring(n + 1), ",");
                while (stringTokenizer2.hasMoreElements()) {
                    String string4 = stringTokenizer2.nextToken();
                    ErrorLogSeverity errorLogSeverity = ErrorLogSeverity.getByName(string4);
                    if (errorLogSeverity == null) {
                        this.writer.println("StartupErrorLogger:  Unknown error log severity \"" + string4 + "\" read from environment " + "variable " + ENV_VARIABLE_ERROR_LOG_LEVEL + " will be ignored.");
                        continue;
                    }
                    hashSet.add(errorLogSeverity);
                }
                this.definedSeverities.put(errorLogCategory, hashSet);
            }
        }
    }

    public void closeErrorLogger() {
    }

    public void logError(ErrorLogCategory errorLogCategory, ErrorLogSeverity errorLogSeverity, String string, int n) {
        HashSet<ErrorLogSeverity> hashSet = this.definedSeverities.get((Object)errorLogCategory);
        if (hashSet == null) {
            hashSet = this.defaultSeverities;
        }
        if (hashSet.contains((Object)errorLogSeverity)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(TimeThread.getLocalTime());
            stringBuilder.append("] category=");
            stringBuilder.append(errorLogCategory.getCategoryName());
            stringBuilder.append(" severity=");
            stringBuilder.append(errorLogSeverity.getSeverityName());
            stringBuilder.append(" id=");
            stringBuilder.append(n);
            stringBuilder.append(" msg=\"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
            this.writer.println(stringBuilder.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object != null && object instanceof StartupErrorLogger;
    }

    public int hashCode() {
        return 12345;
    }
}

