/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.PostRotationAction;

public class ZIPAction
implements PostRotationAction {
    private static final String CLASS_NAME = "org.opends.server.loggers.ZIPAction";
    private File originalFile;
    private File newFile;
    private boolean deleteOriginal;

    public ZIPAction(String string, String string2, boolean bl) {
        this.originalFile = new File(string);
        this.newFile = new File(string2);
        this.deleteOriginal = bl;
    }

    public boolean execute() {
        FileInputStream fileInputStream = null;
        ZipOutputStream zipOutputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n;
            if (!this.originalFile.exists()) {
                System.err.println("Source file does not exist:" + this.originalFile);
                return false;
            }
            fileInputStream = new FileInputStream(this.originalFile);
            bl = true;
            FileOutputStream fileOutputStream = new FileOutputStream(this.newFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            bl2 = true;
            ZipEntry zipEntry = new ZipEntry(this.originalFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[8192];
            while ((n = fileInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.close();
            bl2 = false;
            fileInputStream.close();
            bl = false;
            if (this.deleteOriginal && !this.originalFile.delete()) {
                System.err.println("Cannot delete original file:" + this.originalFile);
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            block13: {
                block12: {
                    assert (Debug.debugException(CLASS_NAME, "execute", iOException));
                    if (bl) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {
                            if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "execute", exception)) break block12;
                            throw new AssertionError();
                        }
                    }
                }
                if (bl2) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "execute", exception)) break block13;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }
    }
}

