/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.messages;

import java.util.IllegalFormatException;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.messages.BackendMessages;
import org.opends.server.messages.ConfigMessages;
import org.opends.server.messages.CoreMessages;
import org.opends.server.messages.ExtensionsMessages;
import org.opends.server.messages.JebMessages;
import org.opends.server.messages.LoggerMessages;
import org.opends.server.messages.PluginMessages;
import org.opends.server.messages.ProtocolMessages;
import org.opends.server.messages.SchemaMessages;
import org.opends.server.messages.TaskMessages;
import org.opends.server.messages.ToolMessages;
import org.opends.server.messages.UtilityMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandler {
    public static final int CATEGORY_MASK_CORE = 0;
    public static final int CATEGORY_MASK_EXTENSIONS = 0x100000;
    public static final int CATEGORY_MASK_PROTOCOL = 0x200000;
    public static final int CATEGORY_MASK_CONFIG = 0x300000;
    public static final int CATEGORY_MASK_LOG = 0x400000;
    public static final int CATEGORY_MASK_UTIL = 0x500000;
    public static final int CATEGORY_MASK_SCHEMA = 0x600000;
    public static final int CATEGORY_MASK_PLUGIN = 0x700000;
    public static final int CATEGORY_MASK_JEB = 0x800000;
    public static final int CATEGORY_MASK_SYNC = 0x1000000;
    public static final int CATEGORY_MASK_BACKEND = 0x900000;
    public static final int CATEGORY_MASK_TOOLS = 0xA00000;
    public static final int CATEGORY_MASK_TASK = 0xB00000;
    public static final int CATEGORY_MASK_THIRD_PARTY = Integer.MIN_VALUE;
    public static final int CATEGORY_MASK_USER_DEFINED = -1048576;
    public static final int SEVERITY_MASK_INFORMATIONAL = 0;
    public static final int SEVERITY_MASK_MILD_WARNING = 65536;
    public static final int SEVERITY_MASK_SEVERE_WARNING = 131072;
    public static final int SEVERITY_MASK_MILD_ERROR = 196608;
    public static final int SEVERITY_MASK_SEVERE_ERROR = 262144;
    public static final int SEVERITY_MASK_FATAL_ERROR = 327680;
    public static final int SEVERITY_MASK_DEBUG = 393216;
    public static final int SEVERITY_MASK_NOTICE = 458752;
    private static ConcurrentHashMap<Integer, String> messageMap = new ConcurrentHashMap();

    public static String getMessage(int n) {
        String string = messageMap.get(n);
        if (string == null) {
            string = "Unknown message for message ID " + n;
        }
        return string;
    }

    public static String getMessage(int n, Object ... objectArray) {
        String string = messageMap.get(n);
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unknown message for message ID ");
            stringBuilder.append(n);
            stringBuilder.append(" -- provided arguments were:  ");
            if (objectArray != null && objectArray.length > 0) {
                stringBuilder.append(String.valueOf(objectArray[0]));
                for (int i = 1; i < objectArray.length; ++i) {
                    stringBuilder.append(", ");
                    stringBuilder.append(String.valueOf(objectArray[i]));
                }
            }
            return stringBuilder.toString();
        }
        try {
            return String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(" -- mismatched arguments were:  ");
            if (objectArray != null && objectArray.length > 0) {
                stringBuilder.append(String.valueOf(objectArray[0]));
                for (int i = 1; i < objectArray.length; ++i) {
                    stringBuilder.append(", ");
                    stringBuilder.append(String.valueOf(objectArray[i]));
                }
            }
            return stringBuilder.toString();
        }
    }

    public static void registerMessage(int n, String string) {
        messageMap.put(n, string);
    }

    public static ConcurrentHashMap<Integer, String> getMessages() {
        return messageMap;
    }

    static {
        CoreMessages.registerMessages();
        ExtensionsMessages.registerMessages();
        ProtocolMessages.registerMessages();
        ConfigMessages.registerMessages();
        LoggerMessages.registerMessages();
        UtilityMessages.registerMessages();
        SchemaMessages.registerMessages();
        PluginMessages.registerMessages();
        JebMessages.registerMessages();
        BackendMessages.registerMessages();
        ToolMessages.registerMessages();
        TaskMessages.registerMessages();
    }
}

