/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceMonitorProvider
extends MonitorProvider {
    private static final String CLASS_NAME = "org.opends.server.monitors.StackTraceMonitorProvider";

    public StackTraceMonitorProvider() {
        super("Stack Trace Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMonitorProvider", String.valueOf(configEntry)));
    }

    @Override
    public String getMonitorInstanceName() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorInstanceName", new String[0]));
        return "JVM Stack Trace";
    }

    @Override
    public long getUpdateInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpdateInterval", new String[0]));
        return 0L;
    }

    @Override
    public void updateMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "updateMonitorData", new String[0]));
    }

    public ArrayList<Attribute> getMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorData", new String[0]));
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        int n = 0;
        for (Thread thread : map.keySet()) {
            StackTraceElement[] stackTraceElementArray;
            String string = "thread-" + n + "-";
            arrayList.add(this.createAttribute(string + "name", thread.getName()));
            arrayList.add(this.createAttribute(string + "id:", String.valueOf(thread.getId())));
            arrayList.add(this.createAttribute(string + "priority", String.valueOf(thread.getPriority())));
            arrayList.add(this.createAttribute(string + "state", thread.getState().toString()));
            ThreadGroup threadGroup = thread.getThreadGroup();
            if (threadGroup != null) {
                arrayList.add(this.createAttribute(string + "group", threadGroup.getName()));
            }
            if ((stackTraceElementArray = map.get(thread)) != null) {
                int n2 = 0;
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(stackTraceElement.getClassName());
                    stringBuilder.append(".");
                    stringBuilder.append(stackTraceElement.getMethodName());
                    stringBuilder.append("(");
                    stringBuilder.append(stackTraceElement.getFileName());
                    stringBuilder.append(":");
                    stringBuilder.append(stackTraceElement.getLineNumber());
                    stringBuilder.append(")");
                    if (stackTraceElement.isNativeMethod()) {
                        stringBuilder.append(" -- Native method");
                    }
                    arrayList.add(this.createAttribute(string + "stack-frame-" + n2, stringBuilder.toString()));
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    private Attribute createAttribute(String string, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "createAttribute", String.valueOf(string), String.valueOf(string2)));
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType(string);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string2);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        try {
            linkedHashSet.add(new AttributeValue(aSN1OctetString, attributeType.normalize(aSN1OctetString)));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createAttribute", exception));
            linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        }
        return new Attribute(attributeType, string, linkedHashSet);
    }
}

