/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.util.Arrays;
import java.util.HashMap;
import org.opends.server.loggers.Debug;
import org.opends.server.plugins.profiler.ProfileStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileStackFrame
implements Comparable {
    private static final String CLASS_NAME = "org.opends.server.plugins.profiler.ProfilerThread";
    private HashMap<Integer, Long> lineNumbers;
    private HashMap<ProfileStackFrame, ProfileStackFrame> subordinateFrames;
    private String className;
    private String methodName;

    public ProfileStackFrame(String string, String string2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2)));
        this.className = string;
        this.methodName = string2;
        this.lineNumbers = new HashMap();
        this.subordinateFrames = new HashMap();
    }

    public String getClassName() {
        assert (Debug.debugEnter(CLASS_NAME, "getClassName", new String[0]));
        return this.className;
    }

    public String getMethodName() {
        assert (Debug.debugEnter(CLASS_NAME, "getMethodName", new String[0]));
        return this.methodName;
    }

    public String getHTMLSafeMethodName() {
        assert (Debug.debugEnter(CLASS_NAME, "getHTMLSafeMethodName", new String[0]));
        int n = this.methodName.length();
        StringBuilder stringBuilder = new StringBuilder(n + 6);
        for (int i = 0; i < n; ++i) {
            char c = this.methodName.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public HashMap<Integer, Long> getLineNumbers() {
        assert (Debug.debugEnter(CLASS_NAME, "getLineNumbers", new String[0]));
        return this.lineNumbers;
    }

    public void updateLineNumberCount(int n, long l) {
        assert (Debug.debugEnter(CLASS_NAME, "updateLineNumberCount", String.valueOf(n), String.valueOf(l)));
        Long l2 = this.lineNumbers.get(n);
        if (l2 == null) {
            this.lineNumbers.put(n, l);
        } else {
            this.lineNumbers.put(n, l2 + l);
        }
    }

    public long getTotalCount() {
        assert (Debug.debugEnter(CLASS_NAME, "getTotalCount", new String[0]));
        long l = 0L;
        for (Long l2 : this.lineNumbers.values()) {
            l += l2.longValue();
        }
        return l;
    }

    public ProfileStackFrame[] getSubordinateFrames() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubordinateFrames", new String[0]));
        Object[] objectArray = new ProfileStackFrame[]{};
        objectArray = this.subordinateFrames.values().toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public boolean hasSubFrames() {
        assert (Debug.debugEnter(CLASS_NAME, "hasSubFrames", new String[0]));
        return !this.subordinateFrames.isEmpty();
    }

    public void recurseSubFrames(ProfileStack profileStack, int n, long l, HashMap<String, HashMap<ProfileStack, Long>> hashMap) {
        assert (Debug.debugEnter(CLASS_NAME, "recurseSubFrames", new String[0]));
        if (n < 0) {
            return;
        }
        String string = profileStack.getClassName(n);
        String string2 = profileStack.getMethodName(n);
        ProfileStackFrame profileStackFrame = new ProfileStackFrame(string, string2);
        int n2 = profileStack.getLineNumber(n);
        ProfileStackFrame profileStackFrame2 = this.subordinateFrames.get(profileStackFrame);
        if (profileStackFrame2 == null) {
            profileStackFrame2 = profileStackFrame;
            this.subordinateFrames.put(profileStackFrame2, profileStackFrame2);
        }
        profileStackFrame2.updateLineNumberCount(n2, l);
        String string3 = string + "." + string2;
        HashMap<ProfileStack, Long> hashMap2 = hashMap.get(string3);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            hashMap.put(string3, hashMap2);
        }
        hashMap2.put(profileStack, l);
        profileStackFrame2.recurseSubFrames(profileStack, n - 1, l, hashMap);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.className.hashCode() + this.methodName.hashCode();
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            ProfileStackFrame profileStackFrame = (ProfileStackFrame)object;
            return this.className.equals(profileStackFrame.className) && this.methodName.equals(profileStackFrame.methodName);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "equals", exception));
            return false;
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "compareTo", String.valueOf(object)));
        ProfileStackFrame profileStackFrame = (ProfileStackFrame)object;
        long l = this.getTotalCount();
        long l2 = profileStackFrame.getTotalCount();
        if (l > l2) {
            return -1;
        }
        if (l < l2) {
            return 1;
        }
        int n = this.className.compareTo(profileStackFrame.className);
        if (n == 0) {
            n = this.methodName.compareTo(profileStackFrame.methodName);
        }
        return n;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTotalCount());
        stringBuilder.append("    ");
        stringBuilder.append(this.className);
        stringBuilder.append('.');
        stringBuilder.append(this.methodName);
        return stringBuilder.toString();
    }
}

