/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1Long
extends ASN1Element {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Long";
    private static final long serialVersionUID = -6015600344725970947L;
    private long longValue;

    public ASN1Long(long l) {
        super((byte)2, ASN1Long.encodeLongValue(l));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(l)));
        this.longValue = l;
    }

    public ASN1Long(byte by, long l) {
        super(by, ASN1Long.encodeLongValue(l));
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), String.valueOf(l)));
        this.longValue = l;
    }

    private ASN1Long(byte by, byte[] byArray, long l) {
        super(by, byArray);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), StaticUtils.bytesToHex(byArray), String.valueOf(l)));
        this.longValue = l;
    }

    public long longValue() {
        assert (Debug.debugEnter(CLASS_NAME, "longValue", new String[0]));
        return this.longValue;
    }

    public void setValue(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(l)));
        this.longValue = l;
        this.setValueInternal(ASN1Long.encodeLongValue(l));
    }

    public void setValue(byte[] byArray) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n = 2293785;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        if (byArray.length < 1 || byArray.length > 8) {
            int n = 2294021;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
        this.longValue = 0L;
        for (byte by : byArray) {
            this.longValue = this.longValue << 8 | (long)(by & 0xFF);
        }
        this.setValueInternal(byArray);
    }

    public static ASN1Long decodeAsLong(ASN1Element aSN1Element) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsLong", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293787;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray = aSN1Element.value();
        if (byArray.length < 1 || byArray.length > 8) {
            int n = 2294022;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
        long l = 0L;
        for (byte by : byArray) {
            l = l << 8 | (long)(by & 0xFF);
        }
        return new ASN1Long(aSN1Element.getType(), byArray, l);
    }

    public static ASN1Long decodeAsLong(byte[] byArray) throws ASN1Exception {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsLong", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n2 = 2293789;
            String string = MessageHandler.getMessage(n2);
            throw new ASN1Exception(n2, string);
        }
        if (byArray.length < 3) {
            int n3 = 2293790;
            String string = MessageHandler.getMessage(n3, byArray.length);
            throw new ASN1Exception(n3, string);
        }
        byte by = byArray[0];
        int n4 = byArray[1] & 0x7F;
        int n5 = 2;
        if (n4 != byArray[1]) {
            n = n4;
            if (n > 4) {
                int n6 = 0x230003;
                String string = MessageHandler.getMessage(n6, n);
                throw new ASN1Exception(n6, string);
            }
            if (byArray.length < 2 + n) {
                int n7 = 2293764;
                String string = MessageHandler.getMessage(n7, n);
                throw new ASN1Exception(n7, string);
            }
            n4 = 0;
            n5 = 2 + n;
            for (int i = 0; i < n; ++i) {
                n4 = n4 << 8 | byArray[i + 2] & 0xFF;
            }
        }
        if (byArray.length - n5 != n4) {
            n = 2293765;
            String string = MessageHandler.getMessage(n, n4, byArray.length - n5);
            throw new ASN1Exception(n, string);
        }
        if (n4 < 1 || n4 > 8) {
            n = 2294023;
            String string = MessageHandler.getMessage(n, n4);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n5, byArray2, 0, n4);
        long l = 0L;
        for (byte by2 : byArray2) {
            l = l << 8 | (long)(by2 & 0xFF);
        }
        return new ASN1Long(by, byArray2, l);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ASN1Long(type=");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(", value=");
        stringBuilder.append(this.longValue);
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("ASN.1 Long");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  BER Type:  ");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Value:  ");
        stringBuilder.append(this.longValue);
        stringBuilder.append(" (");
        stringBuilder.append(StaticUtils.bytesToHex(this.value()));
        stringBuilder.append(")");
        stringBuilder.append(ServerConstants.EOL);
    }
}

