/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;

public class ASN1Reader {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Reader";
    private InputStream inputStream;
    private int maxElementSize;
    private Socket socket;

    public ASN1Reader(Socket socket) throws IOException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(socket)));
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.maxElementSize = -1;
    }

    public ASN1Reader(InputStream inputStream) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(inputStream)));
        this.inputStream = inputStream;
        this.socket = null;
        this.maxElementSize = -1;
    }

    public int getMaxElementSize() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaxElementSize", new String[0]));
        return this.maxElementSize;
    }

    public void setMaxElementSize(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setMaxElementSize", String.valueOf(n)));
        this.maxElementSize = n;
    }

    public int getIOTimeout() throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "getIOTimeout", new String[0]));
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getSoTimeout();
    }

    public void setIOTimeout(int n) throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "setIOTimeout", String.valueOf(n)));
        if (this.socket == null) {
            return;
        }
        this.socket.setSoTimeout(Math.max(0, n));
    }

    public ASN1Element readElement() throws IOException, ASN1Exception {
        int n;
        int n2;
        int n3;
        int n4 = this.inputStream.read();
        if (n4 < 0) {
            return null;
        }
        byte by = (byte)(n4 & 0xFF);
        int n5 = this.inputStream.read();
        if (n5 != (n3 = n5 & 0x7F)) {
            if (n3 > 4) {
                int n6 = 2293768;
                String string = MessageHandler.getMessage(n6, n3);
                throw new ASN1Exception(n6, string);
            }
            n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.inputStream.read();
                if (n < 0) {
                    int n7 = 2293769;
                    String string = MessageHandler.getMessage(n7, n3);
                    throw new IOException(string);
                }
                n5 = n5 << 8 | n;
            }
        }
        if (n5 == 0) {
            return new ASN1Element(by);
        }
        if (this.maxElementSize > 0 && n5 > this.maxElementSize) {
            n2 = 2293951;
            String string = MessageHandler.getMessage(n2, n5, this.maxElementSize);
            throw new ASN1Exception(n2, string);
        }
        byte[] byArray = new byte[n5];
        n = 0;
        int n8 = n5;
        while (n8 > 0) {
            int n9 = this.inputStream.read(byArray, n, n8);
            if (n9 < 0) {
                int n10 = 2293770;
                String string = MessageHandler.getMessage(n10, n5, n8);
                throw new IOException(string);
            }
            n8 -= n9;
            n += n9;
        }
        return new ASN1Element(by, byArray);
    }

    public void close() {
        block7: {
            block6: {
                assert (Debug.debugEnter(CLASS_NAME, "close", new String[0]));
                try {
                    this.inputStream.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "close", exception)) break block6;
                    throw new AssertionError();
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "close", exception)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }
}

