/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Constants;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASN1Sequence
extends ASN1Element {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Sequence";
    private static final long serialVersionUID = 694649828357992307L;
    private ArrayList<ASN1Element> elements;

    public ASN1Sequence() {
        super((byte)48);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.elements = new ArrayList();
    }

    public ASN1Sequence(byte by) {
        super(by);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by)));
        this.elements = new ArrayList();
    }

    public ASN1Sequence(ArrayList<ASN1Element> arrayList) {
        super((byte)48, ASN1Sequence.encodeValue(arrayList));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(arrayList)));
        this.elements = arrayList == null ? new ArrayList() : arrayList;
    }

    public ASN1Sequence(byte by, ArrayList<ASN1Element> arrayList) {
        super(by, ASN1Sequence.encodeValue(arrayList));
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), String.valueOf(arrayList)));
        this.elements = arrayList == null ? new ArrayList() : arrayList;
    }

    private ASN1Sequence(byte by, byte[] byArray, ArrayList<ASN1Element> arrayList) {
        super(by, byArray);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), StaticUtils.bytesToHex(byArray), String.valueOf(arrayList)));
        this.elements = arrayList == null ? new ArrayList() : arrayList;
    }

    public ArrayList<ASN1Element> elements() {
        assert (Debug.debugEnter(CLASS_NAME, "elements", new String[0]));
        return this.elements;
    }

    public void setElements(ArrayList<ASN1Element> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(arrayList)));
        if (arrayList == null) {
            this.elements.clear();
            this.setValueInternal(ASN1Constants.NO_VALUE);
        } else {
            this.elements = arrayList;
            this.setValueInternal(ASN1Sequence.encodeValue(arrayList));
        }
    }

    @Override
    public void setValue(byte[] byArray) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n = 2293799;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        this.elements = ASN1Sequence.decodeElements(byArray);
        this.setValueInternal(byArray);
    }

    public static ASN1Sequence decodeAsSequence(ASN1Element aSN1Element) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsSequence", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293800;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray = aSN1Element.value();
        ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeElements(byArray);
        return new ASN1Sequence(aSN1Element.getType(), byArray, arrayList);
    }

    public static ASN1Sequence decodeAsSequence(byte[] byArray) throws ASN1Exception {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsSequence", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n2 = 2293801;
            String string = MessageHandler.getMessage(n2);
            throw new ASN1Exception(n2, string);
        }
        if (byArray.length < 2) {
            int n3 = 0x230002;
            String string = MessageHandler.getMessage(n3, byArray.length);
            throw new ASN1Exception(n3, string);
        }
        byte by = byArray[0];
        int n4 = byArray[1] & 0x7F;
        int n5 = 2;
        if (n4 != byArray[1]) {
            n = n4;
            if (n > 4) {
                int n6 = 0x230003;
                String string = MessageHandler.getMessage(n6, n);
                throw new ASN1Exception(n6, string);
            }
            if (byArray.length < 2 + n) {
                int n7 = 2293764;
                String string = MessageHandler.getMessage(n7, n);
                throw new ASN1Exception(n7, string);
            }
            n4 = 0;
            n5 = 2 + n;
            for (int i = 0; i < n; ++i) {
                n4 = n4 << 8 | byArray[i + 2] & 0xFF;
            }
        }
        if (byArray.length - n5 != n4) {
            n = 2293765;
            String string = MessageHandler.getMessage(n, n4, byArray.length - n5);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n5, byArray2, 0, n4);
        ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeElements(byArray2);
        return new ASN1Sequence(by, byArray2, arrayList);
    }

    public static ASN1Sequence decodeAsSequence(byte by, byte[] byArray) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsSequence", StaticUtils.byteToHex(by), StaticUtils.bytesToHex(byArray)));
        ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeElements(byArray);
        return new ASN1Sequence(by, byArray, arrayList);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ASN1Sequence(type=");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(", values={ ");
        if (!this.elements.isEmpty()) {
            Iterator<ASN1Element> iterator = this.elements.iterator();
            iterator.next().toString(stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                iterator.next().toString(stringBuilder);
            }
        }
        stringBuilder.append(" })");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("ASN.1 Sequence");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  BER Type:  ");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(ServerConstants.EOL);
        if (!this.elements.isEmpty()) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Decoded Values:");
            stringBuilder.append(ServerConstants.EOL);
            Iterator<ASN1Element> iterator = this.elements.iterator();
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  ");
            iterator.next().toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("  ");
                iterator.next().toString(stringBuilder);
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Value:  ");
        stringBuilder.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(stringBuilder, this.value(), n + 2);
    }
}

