/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.core.SearchOperation;
import org.opends.server.extensions.InternalConnectionSecurityProvider;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalConnectionHandler;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.Modification;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalClientConnection
extends ClientConnection {
    private static final String CLASS_NAME = "org.opends.server.protocols.internal.InternalClientConnection";
    private static AtomicInteger nextMessageID = new AtomicInteger(1);
    private static AtomicLong nextConnectionID = new AtomicLong(-1L);
    private static AtomicLong nextOperationID = new AtomicLong(0L);
    private ConnectionSecurityProvider securityProvider;
    private static InternalClientConnection rootConnection = new InternalClientConnection();
    private AuthenticationInfo authenticationInfo;
    private LinkedList<Operation> operationList;
    private long connectionID;

    public InternalClientConnection() {
        block6: {
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            String string = "cn=Internal Client";
            try {
                DN dN = DN.decode(string);
                this.authenticationInfo = new AuthenticationInfo(dN, true);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "<init>", directoryException));
                Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_ERROR, 2359560, string, StaticUtils.stackTraceToSingleLineString(directoryException));
            }
            this.connectionID = nextConnectionID.getAndDecrement();
            this.operationList = new LinkedList();
            try {
                this.securityProvider = new InternalConnectionSecurityProvider();
                this.securityProvider.initializeConnectionSecurityProvider(null);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "<init>", exception)) break block6;
                throw new AssertionError();
            }
        }
    }

    public InternalClientConnection(AuthenticationInfo authenticationInfo) {
        block3: {
            assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(authenticationInfo)));
            this.authenticationInfo = authenticationInfo;
            this.connectionID = nextConnectionID.getAndDecrement();
            this.operationList = new LinkedList();
            try {
                this.securityProvider = new InternalConnectionSecurityProvider();
                this.securityProvider.initializeConnectionSecurityProvider(null);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "<init>", exception)) break block3;
                throw new AssertionError();
            }
        }
    }

    public static InternalClientConnection getRootConnection() {
        assert (Debug.debugEnter(CLASS_NAME, "getRootConnection", new String[0]));
        return rootConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextOperationID() {
        assert (Debug.debugEnter(CLASS_NAME, "nextOperationID", new String[0]));
        long l = nextOperationID.getAndIncrement();
        if (l < 0L) {
            AtomicLong atomicLong = nextOperationID;
            synchronized (atomicLong) {
                if (nextOperationID.get() < 0L) {
                    nextOperationID.set(1L);
                    return 0L;
                }
                return nextOperationID.getAndIncrement();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextMessageID() {
        assert (Debug.debugEnter(CLASS_NAME, "nextMessageID", new String[0]));
        int n = nextMessageID.getAndIncrement();
        if (n < 0) {
            AtomicInteger atomicInteger = nextMessageID;
            synchronized (atomicInteger) {
                if (nextMessageID.get() < 0) {
                    nextMessageID.set(2);
                    return 1;
                }
                return nextMessageID.getAndIncrement();
            }
        }
        return n;
    }

    @Override
    public long getConnectionID() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionID", new String[0]));
        return this.connectionID;
    }

    @Override
    public ConnectionHandler getConnectionHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionHandler", new String[0]));
        return InternalConnectionHandler.getInstance();
    }

    @Override
    public String getProtocol() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocol", new String[0]));
        return "internal";
    }

    @Override
    public String getClientAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientAddress", new String[0]));
        return "internal";
    }

    @Override
    public String getServerAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerAddress", new String[0]));
        return "internal";
    }

    @Override
    public InetAddress getRemoteAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getRemoteAddress", new String[0]));
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getLocalAddress", new String[0]));
        return null;
    }

    @Override
    public boolean isSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", new String[0]));
        return this.securityProvider.isSecure();
    }

    @Override
    public ConnectionSecurityProvider getConnectionSecurityProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionSecurityProvider", new String[0]));
        return this.securityProvider;
    }

    @Override
    public void setConnectionSecurityProvider(ConnectionSecurityProvider connectionSecurityProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "setConnectionSecurityProvider", String.valueOf(connectionSecurityProvider)));
        this.securityProvider = connectionSecurityProvider;
    }

    @Override
    public String getSecurityMechanism() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecurityMechanism", new String[0]));
        return this.securityProvider.getSecurityMechanismName();
    }

    @Override
    public boolean processDataRead(ByteBuffer byteBuffer) {
        assert (Debug.debugEnter(CLASS_NAME, "processDataRead", new String[0]));
        return false;
    }

    @Override
    public void sendResponse(Operation operation) {
        assert (Debug.debugEnter(CLASS_NAME, "sendResponse", String.valueOf(operation)));
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthenticationInfo", new String[0]));
        return this.authenticationInfo;
    }

    @Override
    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthenticationInfo", String.valueOf(authenticationInfo)));
    }

    @Override
    public void setUnauthenticated() {
        assert (Debug.debugEnter(CLASS_NAME, "setUnauthenticated", new String[0]));
    }

    public AddOperation processAdd(ByteString byteString, List<LDAPAttribute> list) {
        assert (Debug.debugEnter(CLASS_NAME, "processAdd", String.valueOf(byteString), String.valueOf(list)));
        AddOperation addOperation = new AddOperation(this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, list);
        addOperation.setInternalOperation(true);
        addOperation.run();
        return addOperation;
    }

    public AddOperation processAdd(DN dN, Map<ObjectClass, String> map, Map<AttributeType, List<Attribute>> map2, Map<AttributeType, List<Attribute>> map3) {
        assert (Debug.debugEnter(CLASS_NAME, "processAdd", String.valueOf(dN), String.valueOf(map), String.valueOf(map2), String.valueOf(map3)));
        AddOperation addOperation = new AddOperation(this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, map, map2, map3);
        addOperation.setInternalOperation(true);
        addOperation.run();
        return addOperation;
    }

    public BindOperation processSimpleBind(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "processSimpleBind", String.valueOf(byteString), "ByteString"));
        BindOperation bindOperation = new BindOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, byteString2);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public BindOperation processSimpleBind(DN dN, ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "processSimpleBind", String.valueOf(dN), "ByteString"));
        BindOperation bindOperation = new BindOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, byteString);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public BindOperation processSASLBind(ByteString byteString, String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(byteString), String.valueOf(string), "ASN1OctetString"));
        BindOperation bindOperation = new BindOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, string, aSN1OctetString);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public BindOperation processSASLBind(DN dN, String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(dN), "ByteString"));
        BindOperation bindOperation = new BindOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, string, aSN1OctetString);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public CompareOperation processCompare(ByteString byteString, String string, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "processCompare", String.valueOf(byteString), String.valueOf(string), String.valueOf(byteString2)));
        CompareOperation compareOperation = new CompareOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, string, byteString2);
        compareOperation.setInternalOperation(true);
        compareOperation.run();
        return compareOperation;
    }

    public CompareOperation processCompare(DN dN, AttributeType attributeType, ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "processCompare", String.valueOf(dN), String.valueOf(attributeType), String.valueOf(byteString)));
        CompareOperation compareOperation = new CompareOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, attributeType, byteString);
        compareOperation.setInternalOperation(true);
        compareOperation.run();
        return compareOperation;
    }

    public DeleteOperation processDelete(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "processDelete", String.valueOf(byteString)));
        DeleteOperation deleteOperation = new DeleteOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString);
        deleteOperation.setInternalOperation(true);
        deleteOperation.run();
        return deleteOperation;
    }

    public DeleteOperation processDelete(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "processDelete", String.valueOf(dN)));
        DeleteOperation deleteOperation = new DeleteOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN);
        deleteOperation.setInternalOperation(true);
        deleteOperation.run();
        return deleteOperation;
    }

    public ExtendedOperation processExtendedOperation(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "processExtendedOperation", String.valueOf(string), String.valueOf(aSN1OctetString)));
        ExtendedOperation extendedOperation = new ExtendedOperation(this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), string, aSN1OctetString);
        extendedOperation.setInternalOperation(true);
        extendedOperation.run();
        return extendedOperation;
    }

    public ModifyOperation processModify(ByteString byteString, List<LDAPModification> list) {
        assert (Debug.debugEnter(CLASS_NAME, "processModify", String.valueOf(byteString), String.valueOf(list)));
        ModifyOperation modifyOperation = new ModifyOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, list);
        modifyOperation.setInternalOperation(true);
        modifyOperation.run();
        return modifyOperation;
    }

    public ModifyOperation processModify(DN dN, List<Modification> list) {
        assert (Debug.debugEnter(CLASS_NAME, "processModify", String.valueOf(dN), String.valueOf(list)));
        ModifyOperation modifyOperation = new ModifyOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, list);
        modifyOperation.setInternalOperation(true);
        modifyOperation.run();
        return modifyOperation;
    }

    public ModifyDNOperation processModifyDN(ByteString byteString, ByteString byteString2, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyDN", String.valueOf(byteString), String.valueOf(byteString2), String.valueOf(bl)));
        return this.processModifyDN(byteString, byteString2, bl, null);
    }

    public ModifyDNOperation processModifyDN(ByteString byteString, ByteString byteString2, boolean bl, ByteString byteString3) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyDN", String.valueOf(byteString), String.valueOf(byteString2), String.valueOf(bl), String.valueOf(byteString3)));
        ModifyDNOperation modifyDNOperation = new ModifyDNOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, byteString2, bl, byteString3);
        modifyDNOperation.setInternalOperation(true);
        modifyDNOperation.run();
        return modifyDNOperation;
    }

    public ModifyDNOperation processModifyDN(DN dN, RDN rDN, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyDN", String.valueOf(dN), String.valueOf(rDN), String.valueOf(bl)));
        return this.processModifyDN(dN, rDN, bl, null);
    }

    public ModifyDNOperation processModifyDN(DN dN, RDN rDN, boolean bl, DN dN2) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyDN", String.valueOf(dN), String.valueOf(rDN), String.valueOf(bl), String.valueOf(dN2)));
        ModifyDNOperation modifyDNOperation = new ModifyDNOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, rDN, bl, dN2);
        modifyDNOperation.setInternalOperation(true);
        modifyDNOperation.run();
        return modifyDNOperation;
    }

    public InternalSearchOperation processSearch(ByteString byteString, SearchScope searchScope, LDAPFilter lDAPFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(byteString), String.valueOf((Object)searchScope), String.valueOf(lDAPFilter)));
        return this.processSearch(byteString, searchScope, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, lDAPFilter, new LinkedHashSet<String>(0));
    }

    public InternalSearchOperation processSearch(ByteString byteString, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, LDAPFilter lDAPFilter, LinkedHashSet<String> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(byteString), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n), String.valueOf(n2), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(linkedHashSet)));
        InternalSearchOperation internalSearchOperation = new InternalSearchOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, searchScope, dereferencePolicy, n, n2, bl, lDAPFilter, linkedHashSet, null);
        internalSearchOperation.run();
        return internalSearchOperation;
    }

    public InternalSearchOperation processSearch(ByteString byteString, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, LDAPFilter lDAPFilter, LinkedHashSet<String> linkedHashSet, InternalSearchListener internalSearchListener) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(byteString), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n), String.valueOf(n2), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(linkedHashSet), String.valueOf(internalSearchListener)));
        InternalSearchOperation internalSearchOperation = new InternalSearchOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), byteString, searchScope, dereferencePolicy, n, n2, bl, lDAPFilter, linkedHashSet, internalSearchListener);
        internalSearchOperation.run();
        return internalSearchOperation;
    }

    public InternalSearchOperation processSearch(DN dN, SearchScope searchScope, SearchFilter searchFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(dN), String.valueOf((Object)searchScope), String.valueOf(searchFilter)));
        return this.processSearch(dN, searchScope, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, searchFilter, new LinkedHashSet<String>(0));
    }

    public InternalSearchOperation processSearch(DN dN, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, SearchFilter searchFilter, LinkedHashSet<String> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(dN), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n), String.valueOf(n2), String.valueOf(bl), String.valueOf(searchFilter), String.valueOf(linkedHashSet)));
        InternalSearchOperation internalSearchOperation = new InternalSearchOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, searchScope, dereferencePolicy, n, n2, bl, searchFilter, linkedHashSet, null);
        internalSearchOperation.run();
        return internalSearchOperation;
    }

    public InternalSearchOperation processSearch(DN dN, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, SearchFilter searchFilter, LinkedHashSet<String> linkedHashSet, InternalSearchListener internalSearchListener) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(dN), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n), String.valueOf(n2), String.valueOf(bl), String.valueOf(searchFilter), String.valueOf(linkedHashSet), String.valueOf(internalSearchListener)));
        InternalSearchOperation internalSearchOperation = new InternalSearchOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), dN, searchScope, dereferencePolicy, n, n2, bl, searchFilter, linkedHashSet, internalSearchListener);
        internalSearchOperation.run();
        return internalSearchOperation;
    }

    @Override
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchResultEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "sendSearchEntry", String.valueOf(searchOperation), String.valueOf(searchResultEntry)));
        ((InternalSearchOperation)searchOperation).addSearchEntry(searchResultEntry);
    }

    @Override
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchResultReference) {
        assert (Debug.debugEnter(CLASS_NAME, "sendSearchReference", String.valueOf(searchOperation), String.valueOf(searchResultReference)));
        ((InternalSearchOperation)searchOperation).addSearchReference(searchResultReference);
        return true;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        assert (Debug.debugEnter(CLASS_NAME, "sendIntermediateResponseMessage", String.valueOf(intermediateResponse)));
        return false;
    }

    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean bl, String string, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "disconnect", String.valueOf((Object)disconnectReason), String.valueOf(bl), String.valueOf(string), String.valueOf(n)));
    }

    @Override
    public boolean bindInProgress() {
        assert (Debug.debugEnter(CLASS_NAME, "bindInProgress", new String[0]));
        return false;
    }

    @Override
    public void setBindInProgress(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setBindInProgress", String.valueOf(bl)));
    }

    @Override
    public Collection<Operation> getOperationsInProgress() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationsInProgress", new String[0]));
        return this.operationList;
    }

    @Override
    public Operation getOperationInProgress(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationInProgress", String.valueOf(n)));
        return null;
    }

    @Override
    public boolean removeOperationInProgress(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "removeOperationInProgress", String.valueOf(n)));
        return false;
    }

    @Override
    public CancelResult cancelOperation(int n, CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelOperation", String.valueOf(n), String.valueOf(cancelRequest)));
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelAllOperations", String.valueOf(cancelRequest)));
    }

    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelAllOperationsExcept", String.valueOf(cancelRequest), String.valueOf(n)));
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("InternalClientConnection(connID=");
        stringBuilder.append(this.connectionID);
        stringBuilder.append(", authDN=\"");
        stringBuilder.append(this.getAuthenticationInfo().getAuthenticationDN());
        stringBuilder.append("\")");
    }
}

