/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

public class AbandonRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.AbandonRequestProtocolOp";
    private int idToAbandon;

    public AbandonRequestProtocolOp(int n) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n)));
        this.idToAbandon = n;
    }

    public int getIDToAbandon() {
        assert (Debug.debugEnter(CLASS_NAME, "getIDToAbandon", new String[0]));
        return this.idToAbandon;
    }

    public void setIDToAbandon(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setIDToAbandon", String.valueOf(n)));
        this.idToAbandon = n;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 80;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Abandon Request";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        return new ASN1Integer(80, this.idToAbandon);
    }

    public static AbandonRequestProtocolOp decodeAbandonRequest(ASN1Element aSN1Element) throws LDAPException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAbandonRequest", String.valueOf(aSN1Element)));
        try {
            n = aSN1Element.decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeAbandonRequest", exception));
            int n2 = 2293819;
            String string = MessageHandler.getMessage(n2, String.valueOf(exception));
            throw new LDAPException(2, n2, string, exception);
        }
        return new AbandonRequestProtocolOp(n);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("AbandonRequest(idToAbandon=");
        stringBuilder.append(this.idToAbandon);
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Abandon Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  ID to Abandon:  ");
        stringBuilder.append(this.idToAbandon);
        stringBuilder.append(ServerConstants.EOL);
    }
}

