/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

public class ExtendedRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.ExtendedRequestProtocolOp";
    private ASN1OctetString value;
    private String oid;

    public ExtendedRequestProtocolOp(String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.oid = string;
        this.value = null;
    }

    public ExtendedRequestProtocolOp(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.oid = string;
        this.value = aSN1OctetString;
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public void setOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setOID", String.valueOf(string)));
        this.oid = string;
    }

    public ASN1OctetString getValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", new String[0]));
        return this.value;
    }

    public void setValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", new String[0]));
        this.value = aSN1OctetString;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 119;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Extended Request";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(new ASN1OctetString(-128, this.oid));
        if (this.value != null) {
            this.value.setType((byte)-127);
            arrayList.add(this.value);
        }
        return new ASN1Sequence(119, arrayList);
    }

    public static ExtendedRequestProtocolOp decodeExtendedRequest(ASN1Element aSN1Element) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        String string;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeExtendedRequest", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeExtendedRequest", exception));
            int n = 2293851;
            String string2 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string2, exception);
        }
        int n = arrayList.size();
        if (n < 1 || n > 2) {
            int n2 = 2293852;
            String string3 = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string3);
        }
        try {
            string = arrayList.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeExtendedRequest", exception));
            int n3 = 2293853;
            String string4 = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string4, exception);
        }
        if (n == 2) {
            try {
                aSN1OctetString = arrayList.get(1).decodeAsOctetString();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "decodeExtendedRequest", exception));
                int n4 = 2293854;
                String string5 = MessageHandler.getMessage(n4, String.valueOf(exception));
                throw new LDAPException(2, n4, string5, exception);
            }
        } else {
            aSN1OctetString = null;
        }
        return new ExtendedRequestProtocolOp(string, aSN1OctetString);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ExtendedRequest(oid=");
        stringBuilder.append(this.oid);
        if (this.value != null) {
            stringBuilder.append(", value=");
            this.value.toString(stringBuilder);
        }
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Extended Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  OID:  ");
        stringBuilder.append(this.oid);
        stringBuilder.append(ServerConstants.EOL);
        if (this.value != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Value:");
            stringBuilder.append(ServerConstants.EOL);
            this.value.toString(stringBuilder, n + 4);
        }
    }
}

