/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.ModifyRequestProtocolOp";
    private ArrayList<LDAPModification> modifications;
    private ASN1OctetString dn;

    public ModifyRequestProtocolOp(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
        this.modifications = new ArrayList();
    }

    public ModifyRequestProtocolOp(ASN1OctetString aSN1OctetString, ArrayList<LDAPModification> arrayList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(arrayList)));
        this.dn = aSN1OctetString;
        this.modifications = arrayList == null ? new ArrayList() : arrayList;
    }

    public ASN1OctetString getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.dn;
    }

    public void setDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
    }

    public ArrayList<LDAPModification> getModifications() {
        assert (Debug.debugEnter(CLASS_NAME, "getModifications", new String[0]));
        return this.modifications;
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 102;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Modify Request";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(this.dn);
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.modifications.size());
        for (LDAPModification lDAPModification : this.modifications) {
            arrayList2.add(lDAPModification.encode());
        }
        arrayList.add(new ASN1Sequence(arrayList2));
        return new ASN1Sequence(102, arrayList);
    }

    public static ModifyRequestProtocolOp decodeModifyRequest(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<LDAPModification> arrayList;
        ASN1OctetString aSN1OctetString;
        ArrayList<ASN1Element> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeModifyRequest", String.valueOf(aSN1Element)));
        try {
            arrayList2 = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeModifyRequest", exception));
            int n = 2293874;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        int n = arrayList2.size();
        if (n != 2) {
            int n2 = 2293875;
            String string = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string);
        }
        try {
            aSN1OctetString = arrayList2.get(0).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeModifyRequest", exception));
            int n3 = 2293876;
            String string = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string, exception);
        }
        try {
            ArrayList<ASN1Element> arrayList3 = arrayList2.get(1).decodeAsSequence().elements();
            arrayList = new ArrayList<LDAPModification>(arrayList3.size());
            for (ASN1Element aSN1Element2 : arrayList3) {
                arrayList.add(LDAPModification.decode(aSN1Element2));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeModifyRequest", exception));
            int n4 = 2293877;
            String string = MessageHandler.getMessage(n4, String.valueOf(exception));
            throw new LDAPException(2, n4, string, exception);
        }
        return new ModifyRequestProtocolOp(aSN1OctetString, arrayList);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ModifyRequest(dn=");
        this.dn.toString(stringBuilder);
        stringBuilder.append(", mods={");
        if (!this.modifications.isEmpty()) {
            Iterator<LDAPModification> iterator = this.modifications.iterator();
            iterator.next().toString(stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                iterator.next().toString(stringBuilder);
            }
        }
        stringBuilder.append("})");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Modify Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  DN:  ");
        this.dn.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("  Modifications:");
        stringBuilder.append(ServerConstants.EOL);
        for (LDAPModification lDAPModification : this.modifications) {
            lDAPModification.toString(stringBuilder, n + 4);
        }
    }
}

