/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Null;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

public class UnbindRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.UnbindRequestProtocolOp";

    public UnbindRequestProtocolOp() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 66;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Unbind Request";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        return new ASN1Null(66);
    }

    public static UnbindRequestProtocolOp decodeUnbindRequest(ASN1Element aSN1Element) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeUnbindRequest", new String[0]));
        try {
            aSN1Element.decodeAsNull();
            return new UnbindRequestProtocolOp();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeUnbindRequest", exception));
            int n = 2293834;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("UnbindRequest()");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("Unbind Request");
        stringBuilder.append(ServerConstants.EOL);
    }
}

