/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Schema;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypeSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.AttributeTypeSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public AttributeTypeSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "AttributeTypeDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "AttributeTypeDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "AttributeTypeDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "AttributeTypeDescription";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.3";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Attribute Type Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        try {
            AttributeTypeSyntax.decodeAttributeType(byteString, DirectoryServer.getSchema());
            return true;
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
    }

    public static AttributeType decodeAttributeType(ByteString byteString, Schema schema) throws DirectoryException {
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAttributeType", String.valueOf(byteString)));
        String string = byteString.stringValue();
        String string2 = StaticUtils.toLowerCase(string);
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        if (n >= n2) {
            int n3 = 6488116;
            String string3 = MessageHandler.getMessage(n3);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if ((c = string.charAt(n++)) != '(') {
            int n4 = 6488117;
            String string4 = MessageHandler.getMessage(n4, string, n - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 0x630036;
            String string5 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        int n6 = n;
        if (StaticUtils.isDigit(c)) {
            boolean bl = false;
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (bl) {
                        int n7 = 6488119;
                        String string6 = MessageHandler.getMessage(n7, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n7);
                    }
                    bl = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int n8 = 6488120;
                    String string7 = MessageHandler.getMessage(n8, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n8);
                }
                bl = false;
            }
        } else {
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int n9 = 6488121;
                String string8 = MessageHandler.getMessage(n9, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string8, n9);
            }
        }
        if (n >= n2) {
            int n10 = 0x630036;
            String string9 = MessageHandler.getMessage(n10, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string9, n10);
        }
        String string10 = string2.substring(n6, n - 1);
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n11 = 0x630036;
            String string11 = MessageHandler.getMessage(n11, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string11, n11);
        }
        String string12 = string10;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string13 = null;
        AttributeType attributeType = null;
        AttributeSyntax attributeSyntax = DirectoryServer.getDefaultAttributeSyntax();
        ApproximateMatchingRule approximateMatchingRule = null;
        EqualityMatchingRule equalityMatchingRule = null;
        OrderingMatchingRule orderingMatchingRule = null;
        SubstringMatchingRule substringMatchingRule = null;
        AttributeUsage attributeUsage = AttributeUsage.USER_APPLICATIONS;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        block5: while (true) {
            StringBuilder stringBuilder = new StringBuilder();
            n = AttributeTypeSyntax.readTokenName(string, stringBuilder, n);
            String string14 = stringBuilder.toString();
            String string15 = StaticUtils.toLowerCase(string14);
            if (string14.equals(")")) {
                if (n >= n2) break;
                int n12 = 6488123;
                String string16 = MessageHandler.getMessage(n12, string, n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string16, n12);
            }
            if (string15.equals("name")) {
                if ((c = string.charAt(n++)) == '\'') {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    StringBuilder stringBuilder3 = new StringBuilder();
                    n = AttributeTypeSyntax.readQuotedString(string, string2, stringBuilder2, stringBuilder3, n - 1);
                    string12 = stringBuilder2.toString();
                    linkedList.add(string12);
                    continue;
                }
                if (c == '(') {
                    StringBuilder stringBuilder4 = new StringBuilder();
                    StringBuilder stringBuilder5 = new StringBuilder();
                    n = AttributeTypeSyntax.readQuotedString(string, string2, stringBuilder4, stringBuilder5, n);
                    string12 = stringBuilder4.toString();
                    linkedList.add(string12);
                    while (true) {
                        if (string.charAt(n) == ')') {
                            ++n;
                            while (true) {
                                if (n >= n2 || (c = string.charAt(n)) != ' ') continue block5;
                                ++n;
                            }
                        }
                        stringBuilder4 = new StringBuilder();
                        stringBuilder5 = new StringBuilder();
                        n = AttributeTypeSyntax.readQuotedString(string, string2, stringBuilder4, stringBuilder5, n);
                        linkedList.add(stringBuilder4.toString());
                    }
                }
                int n13 = 6488122;
                String string17 = MessageHandler.getMessage(n13, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string17, n13);
            }
            if (string15.equals("desc")) {
                StringBuilder stringBuilder6 = new StringBuilder();
                n = AttributeTypeSyntax.readQuotedString(string, stringBuilder6, n);
                string13 = stringBuilder6.toString();
                continue;
            }
            if (string15.equals("obsolete")) {
                bl3 = true;
                continue;
            }
            if (string15.equals("sup")) {
                StringBuilder stringBuilder7 = new StringBuilder();
                n = AttributeTypeSyntax.readWOID(string2, stringBuilder7, n);
                attributeType = schema.getAttributeType(stringBuilder7.toString());
                if (attributeType == null) {
                    int n14 = 6422589;
                    String string18 = MessageHandler.getMessage(n14, String.valueOf(string10), String.valueOf(stringBuilder7));
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string18, n14);
                    attributeType = DirectoryServer.getDefaultAttributeType(stringBuilder7.toString());
                }
                approximateMatchingRule = attributeType.getApproximateMatchingRule();
                equalityMatchingRule = attributeType.getEqualityMatchingRule();
                orderingMatchingRule = attributeType.getOrderingMatchingRule();
                substringMatchingRule = attributeType.getSubstringMatchingRule();
                attributeSyntax = attributeType.getSyntax();
                bl4 = attributeType.isSingleValue();
                bl = attributeType.isCollective();
                bl2 = attributeType.isNoUserModification();
                attributeUsage = attributeType.getUsage();
                continue;
            }
            if (string15.equals("approx") || string15.equals("approximate")) {
                StringBuilder stringBuilder8 = new StringBuilder();
                n = AttributeTypeSyntax.readWOID(string2, stringBuilder8, n);
                ApproximateMatchingRule approximateMatchingRule2 = schema.getApproximateMatchingRule(stringBuilder8.toString());
                if (approximateMatchingRule2 == null) {
                    int n15 = 6422590;
                    String string19 = MessageHandler.getMessage(n15, String.valueOf(string10), String.valueOf(stringBuilder8));
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string19, n15);
                    continue;
                }
                approximateMatchingRule = approximateMatchingRule2;
                continue;
            }
            if (string15.equals("equality")) {
                StringBuilder stringBuilder9 = new StringBuilder();
                n = AttributeTypeSyntax.readWOID(string2, stringBuilder9, n);
                EqualityMatchingRule equalityMatchingRule2 = schema.getEqualityMatchingRule(stringBuilder9.toString());
                if (equalityMatchingRule2 == null) {
                    int n16 = 6422591;
                    String string20 = MessageHandler.getMessage(n16, String.valueOf(string10), String.valueOf(stringBuilder9));
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string20, n16);
                    continue;
                }
                equalityMatchingRule = equalityMatchingRule2;
                continue;
            }
            if (string15.equals("ordering")) {
                StringBuilder stringBuilder10 = new StringBuilder();
                n = AttributeTypeSyntax.readWOID(string2, stringBuilder10, n);
                OrderingMatchingRule orderingMatchingRule2 = schema.getOrderingMatchingRule(stringBuilder10.toString());
                if (orderingMatchingRule2 == null) {
                    int n17 = 6422592;
                    String string21 = MessageHandler.getMessage(n17, String.valueOf(string10), String.valueOf(stringBuilder10));
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string21, n17);
                    continue;
                }
                orderingMatchingRule = orderingMatchingRule2;
                continue;
            }
            if (string15.equals("substr")) {
                StringBuilder stringBuilder11 = new StringBuilder();
                n = AttributeTypeSyntax.readWOID(string2, stringBuilder11, n);
                SubstringMatchingRule substringMatchingRule2 = schema.getSubstringMatchingRule(stringBuilder11.toString());
                if (substringMatchingRule2 == null) {
                    int n18 = 6422593;
                    String string22 = MessageHandler.getMessage(n18, String.valueOf(string10), String.valueOf(stringBuilder11));
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string22, n18);
                    continue;
                }
                substringMatchingRule = substringMatchingRule2;
                continue;
            }
            if (string15.equals("syntax")) {
                String string23;
                boolean bl5 = false;
                boolean bl6 = false;
                StringBuilder stringBuilder12 = new StringBuilder();
                while (n < n2) {
                    c = string2.charAt(n++);
                    if (bl5) {
                        if (c == '}') {
                            c = string2.charAt(n);
                            if (c == ' ') break;
                            int n19 = 6488120;
                            string23 = MessageHandler.getMessage(n19, string, Character.valueOf(c), n - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string23, n19);
                        }
                        if (StaticUtils.isDigit(c)) continue;
                        int n20 = 6488120;
                        string23 = MessageHandler.getMessage(n20, string, Character.valueOf(c), n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string23, n20);
                    }
                    if (StaticUtils.isDigit(c)) {
                        stringBuilder12.append(c);
                        bl6 = false;
                        continue;
                    }
                    if (c == '.') {
                        if (bl6) {
                            int n21 = 6488119;
                            string23 = MessageHandler.getMessage(n21, string, n - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string23, n21);
                        }
                        stringBuilder12.append(c);
                        bl6 = true;
                        continue;
                    }
                    if (c == '{') {
                        bl5 = true;
                        continue;
                    }
                    if (c == ' ') break;
                    int n22 = 6488120;
                    string23 = MessageHandler.getMessage(n22, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string23, n22);
                }
                if ((attributeSyntax = schema.getSyntax(stringBuilder12.toString())) == null) {
                    int n23 = 6422594;
                    string23 = MessageHandler.getMessage(n23, String.valueOf(string10), String.valueOf(stringBuilder12));
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string23, n23);
                    attributeSyntax = DirectoryServer.getDefaultAttributeSyntax();
                }
                if (approximateMatchingRule == null) {
                    approximateMatchingRule = attributeSyntax.getApproximateMatchingRule();
                }
                if (equalityMatchingRule == null) {
                    equalityMatchingRule = attributeSyntax.getEqualityMatchingRule();
                }
                if (orderingMatchingRule == null) {
                    orderingMatchingRule = attributeSyntax.getOrderingMatchingRule();
                }
                if (substringMatchingRule != null) continue;
                substringMatchingRule = attributeSyntax.getSubstringMatchingRule();
                continue;
            }
            if (string15.equals("single-value")) {
                bl4 = true;
                continue;
            }
            if (string15.equals("collective")) {
                bl = true;
                continue;
            }
            if (string15.equals("no-user-modification")) {
                bl2 = true;
                continue;
            }
            if (string15.equals("usage")) {
                StringBuilder stringBuilder13 = new StringBuilder();
                while (n < n2 && (c = string2.charAt(n++)) != ' ') {
                    stringBuilder13.append(c);
                }
                String string24 = stringBuilder13.toString();
                if (string24.equals("userapplications")) {
                    attributeUsage = AttributeUsage.USER_APPLICATIONS;
                    continue;
                }
                if (string24.equals("directoryoperation")) {
                    attributeUsage = AttributeUsage.DIRECTORY_OPERATION;
                    continue;
                }
                if (string24.equals("distributedoperation")) {
                    attributeUsage = AttributeUsage.DISTRIBUTED_OPERATION;
                    continue;
                }
                if (string24.equals("dsaoperation")) {
                    attributeUsage = AttributeUsage.DSA_OPERATION;
                    continue;
                }
                attributeUsage = AttributeUsage.USER_APPLICATIONS;
                int n24 = 6422595;
                String string25 = MessageHandler.getMessage(n24, String.valueOf(string10), String.valueOf(stringBuilder13), String.valueOf((Object)attributeUsage));
                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string25, n24);
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            n = AttributeTypeSyntax.readExtraParameterValues(string, arrayList, n);
            hashMap.put(string14, arrayList);
        }
        return new AttributeType(string12, linkedList, string10, string13, attributeType, attributeSyntax, approximateMatchingRule, equalityMatchingRule, orderingMatchingRule, substringMatchingRule, attributeUsage, bl, bl2, bl3, bl4, hashMap);
    }

    private static int readTokenName(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readTokenName", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 0x630036;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        while (n < n2 && (c = string.charAt(n++)) != ' ') {
            stringBuilder.append(c);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        return n;
    }

    private static int readQuotedString(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 0x630036;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c != '\'') {
            int n4 = 6422596;
            String string3 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) != '\'') {
            stringBuilder.append(c);
            ++n;
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 0x630036;
            String string4 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
        }
        return n;
    }

    private static int readQuotedString(String string, String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), String.valueOf(string2), "java.lang.StringBuilder", "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string2.length();
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 0x630036;
            String string3 = MessageHandler.getMessage(n3, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if (c != '\'') {
            int n4 = 6422596;
            String string4 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) != '\'') {
            stringBuilder2.append(c);
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 0x630036;
            String string5 = MessageHandler.getMessage(n5, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        return n;
    }

    private static int readWOID(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "readWOID", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n3 = string.length();
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            int n4 = 0x630036;
            String string2 = MessageHandler.getMessage(n4, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n4);
        }
        if (StaticUtils.isDigit(c)) {
            n2 = 0;
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (n2 != 0) {
                        int n5 = 6488119;
                        String string3 = MessageHandler.getMessage(n5, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n5);
                    }
                    stringBuilder.append(c);
                    n2 = 1;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return n - 1;
                    }
                    int n6 = 6488120;
                    String string4 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n6);
                }
                stringBuilder.append(c);
                n2 = 0;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == ')') {
                    return n - 1;
                }
                int n7 = 6488121;
                String string5 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n7);
            }
        } else {
            int n8 = 6488122;
            String string6 = MessageHandler.getMessage(n8, string, Character.valueOf(c), n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n8);
        }
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            n2 = 0x630036;
            String string7 = MessageHandler.getMessage(n2, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n2);
        }
        return n;
    }

    private static int readExtraParameterValues(String string, List<String> list, int n) throws DirectoryException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "readExtraParameterValues", String.valueOf(string), "java.util.concurrent.CopyOnWriteArrayList<String>", String.valueOf(n)));
        int n2 = string.length();
        char c = string.charAt(n++);
        while (n < n2 && c == ' ') {
            c = string.charAt(n++);
        }
        if (n >= n2) {
            int n3 = 0x630036;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c == '\'') {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != '\'') {
                stringBuilder.append(c);
            }
            list.add(stringBuilder.toString());
        } else if (c == '(') {
            while (true) {
                ++n;
                while (n < n2 && (c = string.charAt(n)) == ' ') {
                    ++n;
                }
                if (n >= n2) {
                    int n4 = 0x630036;
                    String string3 = MessageHandler.getMessage(n4, string);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
                }
                if (c != ')') {
                    if (c == '(') {
                        int n5 = 6488122;
                        String string4 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
                    }
                    n = AttributeTypeSyntax.readExtraParameterValues(string, list, n);
                    continue;
                }
                break;
            }
        } else {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                stringBuilder.append(c);
            }
            list.add(stringBuilder.toString());
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n6 = 0x630036;
            String string5 = MessageHandler.getMessage(n6, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n6);
        }
        return n;
    }
}

