/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class AuthPasswordExactEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.AuthPasswordExactEqualityMatchingRule";

    public AuthPasswordExactEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "authPasswordExactMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.4203.1.2.2";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "authentication password exact matching rule";
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        try {
            StringBuilder[] stringBuilderArray = AuthPasswordSyntax.decodeAuthPassword(byteString.stringValue());
            StringBuilder stringBuilder = new StringBuilder(2 + stringBuilderArray[0].length() + stringBuilderArray[1].length() + stringBuilderArray[2].length());
            stringBuilder.append((CharSequence)stringBuilderArray[0]);
            stringBuilder.append('$');
            stringBuilder.append((CharSequence)stringBuilderArray[1]);
            stringBuilder.append('$');
            stringBuilder.append((CharSequence)stringBuilderArray[2]);
            return new ASN1OctetString(stringBuilder.toString());
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "normalizeValue", directoryException));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw directoryException;
                }
                case WARN: {
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, directoryException.getErrorMessage(), directoryException.getErrorMessageID());
                    return new ASN1OctetString(byteString.stringValue());
                }
            }
            return new ASN1OctetString(byteString.stringValue());
        }
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

