/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Schema;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.NameForm;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DITStructureRuleSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.DITStructureRuleSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public DITStructureRuleSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "DITStructureRuleDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "DITStructureRuleDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "DITStructureRuleDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "DITStructureRuleDescription";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.17";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "DIT Structure Rule Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        try {
            DITStructureRuleSyntax.decodeDITStructureRule(byteString, DirectoryServer.getSchema());
            return true;
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
    }

    public static DITStructureRule decodeDITStructureRule(ByteString byteString, Schema schema) throws DirectoryException {
        String string;
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeDITStructureRule", String.valueOf(byteString)));
        String string2 = byteString.stringValue();
        String string3 = StaticUtils.toLowerCase(string2);
        int n2 = string2.length();
        for (n = 0; n < n2 && string2.charAt(n) == ' '; ++n) {
        }
        if (n >= n2) {
            int n3 = 6488236;
            String string4 = MessageHandler.getMessage(n3);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n3);
        }
        if ((c = string2.charAt(n++)) != '(') {
            int n4 = 6488237;
            String string5 = MessageHandler.getMessage(n4, string2, n - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n4);
        }
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488238;
            String string6 = MessageHandler.getMessage(n5, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n5);
        }
        int n6 = n;
        while (n < n2 && (c = string2.charAt(n++)) != ' ') {
            if (StaticUtils.isDigit(c)) continue;
            int n7 = 6488239;
            String string7 = MessageHandler.getMessage(n7, string2, Character.valueOf(c), n - 1);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n7);
        }
        if (n >= n2) {
            int n8 = 6488238;
            String string8 = MessageHandler.getMessage(n8, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string8, n8);
        }
        int n9 = Integer.parseInt(string2.substring(n6, n - 1));
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n10 = 6488238;
            String string9 = MessageHandler.getMessage(n10, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string9, n10);
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        String string10 = null;
        boolean bl = false;
        NameForm nameForm = null;
        CopyOnWriteArraySet copyOnWriteArraySet = null;
        ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2 = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>();
        block4: while (true) {
            Object object;
            Serializable serializable;
            StringBuilder stringBuilder = new StringBuilder();
            n = DITStructureRuleSyntax.readTokenName(string2, stringBuilder, n);
            string = stringBuilder.toString();
            String string11 = StaticUtils.toLowerCase(string);
            if (string.equals(")")) {
                if (n >= n2) break;
                int n11 = 6488240;
                String string12 = MessageHandler.getMessage(n11, string2, n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n11);
            }
            if (string11.equals("name")) {
                if ((c = string2.charAt(n++)) == '\'') {
                    serializable = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    n = DITStructureRuleSyntax.readQuotedString(string2, string3, (StringBuilder)serializable, stringBuilder2, n - 1);
                    concurrentHashMap.put(stringBuilder2.toString(), ((StringBuilder)serializable).toString());
                    continue;
                }
                if (c == '(') {
                    serializable = new StringBuilder();
                    StringBuilder stringBuilder3 = new StringBuilder();
                    n = DITStructureRuleSyntax.readQuotedString(string2, string3, (StringBuilder)serializable, stringBuilder3, n);
                    concurrentHashMap.put(stringBuilder3.toString(), ((StringBuilder)serializable).toString());
                    while (true) {
                        if (string2.charAt(n) == ')') {
                            ++n;
                            while (true) {
                                if (n >= n2 || (c = string2.charAt(n)) != ' ') continue block4;
                                ++n;
                            }
                        }
                        serializable = new StringBuilder();
                        stringBuilder3 = new StringBuilder();
                        n = DITStructureRuleSyntax.readQuotedString(string2, string3, (StringBuilder)serializable, stringBuilder3, n);
                        concurrentHashMap.put(stringBuilder3.toString(), ((StringBuilder)serializable).toString());
                    }
                }
                int n12 = 6488241;
                String string13 = MessageHandler.getMessage(n12, string2, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string13, n12);
            }
            if (string11.equals("desc")) {
                serializable = new StringBuilder();
                n = DITStructureRuleSyntax.readQuotedString(string2, (StringBuilder)serializable, n);
                string10 = ((StringBuilder)serializable).toString();
                continue;
            }
            if (string11.equals("obsolete")) {
                bl = true;
                continue;
            }
            if (string11.equals("form")) {
                serializable = new StringBuilder();
                n = DITStructureRuleSyntax.readWOID(string3, (StringBuilder)serializable, n);
                nameForm = schema.getNameForm(((StringBuilder)serializable).toString());
                if (nameForm != null) continue;
                int n13 = 6488242;
                object = MessageHandler.getMessage(n13, string2, ((StringBuilder)serializable).toString());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)object, n13);
            }
            if (string11.equals("sup")) {
                int n14;
                serializable = new LinkedList();
                if ((c = string2.charAt(n++)) == '(') {
                    while (true) {
                        if (n < n2 && (c = string2.charAt(n)) == ' ') {
                            ++n;
                            continue;
                        }
                        if (n >= n2) {
                            int n15 = 6488238;
                            object = MessageHandler.getMessage(n15, string3);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)object, n15);
                        }
                        n6 = n;
                        while (n < n2 && (c = string2.charAt(n++)) != ' ') {
                            if (StaticUtils.isDigit(c)) continue;
                            int n16 = 6488239;
                            object = MessageHandler.getMessage(n16, string2, Character.valueOf(c), n - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)object, n16);
                        }
                        if (n >= n2) {
                            int n17 = 6488238;
                            String string14 = MessageHandler.getMessage(n17, string2);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string14, n17);
                        }
                        n14 = Integer.parseInt(string2.substring(n6, n - 1));
                        object = schema.getDITStructureRule(n14);
                        if (object == null) {
                            int n18 = 6488243;
                            String string15 = MessageHandler.getMessage(n18, string2, n14);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string15, n18);
                        }
                        ((LinkedList)serializable).add(object);
                        while (n < n2 && (c = string2.charAt(n)) == ' ') {
                            ++n;
                        }
                        if (n >= n2) {
                            int n19 = 6488238;
                            String string16 = MessageHandler.getMessage(n19, string3);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string16, n19);
                        }
                        if (c == ')') break;
                    }
                    ++n;
                    while (n < n2 && (c = string2.charAt(n)) == ' ') {
                        ++n;
                    }
                    if (n >= n2) {
                        int n20 = 6488238;
                        String string17 = MessageHandler.getMessage(n20, string3);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string17, n20);
                    }
                } else {
                    if (n >= n2) {
                        int n21 = 6488238;
                        object = MessageHandler.getMessage(n21, string3);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)object, n21);
                    }
                    n6 = n - 1;
                    while (n < n2 && (c = string2.charAt(n++)) != ' ') {
                        if (StaticUtils.isDigit(c)) continue;
                        int n22 = 6488239;
                        object = MessageHandler.getMessage(n22, string2, Character.valueOf(c), n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)object, n22);
                    }
                    if (n >= n2) {
                        int n23 = 6488238;
                        String string18 = MessageHandler.getMessage(n23, string2);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string18, n23);
                    }
                    n14 = Integer.parseInt(string2.substring(n6, n - 1));
                    object = schema.getDITStructureRule(n14);
                    if (object == null) {
                        int n24 = 6488243;
                        String string19 = MessageHandler.getMessage(n24, string2, n14);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string19, n24);
                    }
                    ((LinkedList)serializable).add(object);
                    while (n < n2 && (c = string2.charAt(n)) == ' ') {
                        ++n;
                    }
                    if (n >= n2) {
                        int n25 = 6488238;
                        String string20 = MessageHandler.getMessage(n25, string3);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string20, n25);
                    }
                }
                copyOnWriteArraySet = new CopyOnWriteArraySet(serializable);
                continue;
            }
            serializable = new CopyOnWriteArrayList();
            n = DITStructureRuleSyntax.readExtraParameterValues(string2, (CopyOnWriteArrayList<String>)serializable, n);
            concurrentHashMap2.put(string, (CopyOnWriteArrayList<String>)serializable);
        }
        if (nameForm == null) {
            int n26 = 6488244;
            string = MessageHandler.getMessage(n26, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n26);
        }
        return new DITStructureRule(concurrentHashMap, n9, string10, bl, nameForm, copyOnWriteArraySet, concurrentHashMap2);
    }

    private static int readTokenName(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readTokenName", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488238;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        while (n < n2 && (c = string.charAt(n++)) != ' ') {
            stringBuilder.append(c);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        return n;
    }

    private static int readQuotedString(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488238;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c != '\'') {
            int n4 = 6488245;
            String string3 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) != '\'') {
            stringBuilder.append(c);
            ++n;
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488238;
            String string4 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
        }
        return n;
    }

    private static int readQuotedString(String string, String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), String.valueOf(string2), "java.lang.StringBuilder", "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string2.length();
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488238;
            String string3 = MessageHandler.getMessage(n3, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if (c != '\'') {
            int n4 = 6488245;
            String string4 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) != '\'') {
            stringBuilder2.append(c);
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488238;
            String string5 = MessageHandler.getMessage(n5, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        return n;
    }

    private static int readWOID(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "readWOID", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n3 = string.length();
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            int n4 = 6488238;
            String string2 = MessageHandler.getMessage(n4, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n4);
        }
        if (StaticUtils.isDigit(c)) {
            n2 = 0;
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (n2 != 0) {
                        int n5 = 6488246;
                        String string3 = MessageHandler.getMessage(n5, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n5);
                    }
                    stringBuilder.append(c);
                    n2 = 1;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return n - 1;
                    }
                    int n6 = 6488247;
                    String string4 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n6);
                }
                stringBuilder.append(c);
                n2 = 0;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == ')') {
                    return n - 1;
                }
                int n7 = 6488248;
                String string5 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n7);
            }
        } else {
            int n8 = 6488241;
            String string6 = MessageHandler.getMessage(n8, string, Character.valueOf(c), n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n8);
        }
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            n2 = 6488238;
            String string7 = MessageHandler.getMessage(n2, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n2);
        }
        return n;
    }

    private static int readExtraParameterValues(String string, CopyOnWriteArrayList<String> copyOnWriteArrayList, int n) throws DirectoryException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "readExtraParameterValues", String.valueOf(string), "java.util.concurrent.CopyOnWriteArrayList<String>", String.valueOf(n)));
        int n2 = string.length();
        char c = string.charAt(n++);
        while (n < n2 && c == ' ') {
            c = string.charAt(n++);
        }
        if (n >= n2) {
            int n3 = 6488238;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c == '\'') {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != '\'') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        } else if (c == '(') {
            while (true) {
                ++n;
                while (n < n2 && (c = string.charAt(n)) == ' ') {
                    ++n;
                }
                if (n >= n2) {
                    int n4 = 6488238;
                    String string3 = MessageHandler.getMessage(n4, string);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
                }
                if (c != ')') {
                    if (c == '(') {
                        int n5 = 6488241;
                        String string4 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
                    }
                    n = DITStructureRuleSyntax.readExtraParameterValues(string, copyOnWriteArrayList, n);
                    continue;
                }
                break;
            }
        } else {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n6 = 6488238;
            String string5 = MessageHandler.getMessage(n6, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n6);
        }
        return n;
    }
}

