/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryStringSyntax
extends AttributeSyntax
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.schema.DirectoryStringSyntax";
    private ApproximateMatchingRule defaultApproximateMatchingRule;
    private boolean allowZeroLengthValues;
    private DN configEntryDN;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    public static final AttributeValueDecoder<String> DECODER = new AttributeValueDecoder<String>(){

        @Override
        public String decode(AttributeValue attributeValue) throws DirectoryException {
            attributeValue.getNormalizedValue();
            return attributeValue.getStringValue();
        }
    };

    public DirectoryStringSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultApproximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
        if (this.defaultApproximateMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553601, "1.3.6.1.4.1.26027.1.4.1", "DirectoryString");
        }
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "DirectoryString");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "DirectoryString");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "DirectoryString");
        }
        if (configEntry == null) {
            return;
        }
        this.allowZeroLengthValues = false;
        int n = 6291695;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-allow-zero-length-values", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 != null) {
                this.allowZeroLengthValues = booleanConfigAttribute2.activeValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "allowZeroLengthValues", exception));
            n = 6553840;
            String string = MessageHandler.getMessage(n, "ds-cfg-allow-zero-length-values", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
        }
        this.configEntryDN = configEntry.getDN();
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSyntax", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "DirectoryString";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Directory String";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return this.defaultApproximateMatchingRule;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        if (this.allowZeroLengthValues || byteString.value().length > 0) {
            return true;
        }
        int n = 6553841;
        stringBuilder.append(MessageHandler.getMessage(n));
        return false;
    }

    public boolean allowZeroLengthValues() {
        assert (Debug.debugEnter(CLASS_NAME, "allowZeroLengthValues", new String[0]));
        return this.allowZeroLengthValues;
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 6291695;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-zero-length-values", MessageHandler.getMessage(n), false, this.allowZeroLengthValues));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        int n = 6291695;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-allow-zero-length-values", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            bl = false;
            n = 6553840;
            list.add(MessageHandler.getMessage(n, "ds-cfg-allow-zero-length-values", StaticUtils.stackTraceToSingleLineString(exception)));
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = false;
        int n = 6291695;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-allow-zero-length-values", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 != null) {
                bl3 = booleanConfigAttribute2.pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            resultCode = DirectoryServer.getServerErrorResultCode();
            n = 6553840;
            arrayList.add(MessageHandler.getMessage(n, "ds-cfg-allow-zero-length-values", StaticUtils.stackTraceToSingleLineString(exception)));
        }
        if (resultCode == ResultCode.SUCCESS && bl3 != this.allowZeroLengthValues) {
            this.allowZeroLengthValues = bl3;
            if (bl) {
                n = 6291698;
                arrayList.add(MessageHandler.getMessage(n, "ds-cfg-allow-zero-length-values", String.valueOf(configEntry.getDN()), String.valueOf(this.allowZeroLengthValues)));
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

