/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class DistinguishedNameEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.DistinguishedNameEqualityMatchingRule";

    public DistinguishedNameEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "distinguishedNameMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.1";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.12";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        try {
            dN = DN.decode(byteString.stringValue());
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "normalizeValue", directoryException));
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                throw directoryException;
            }
            return this.bestEffortNormalize(StaticUtils.toLowerCase(byteString.stringValue()));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "normalizeValue", exception));
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                int n = 6488089;
                String string = MessageHandler.getMessage(n, byteString.stringValue(), String.valueOf(exception));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
            }
            return this.bestEffortNormalize(StaticUtils.toLowerCase(byteString.stringValue()));
        }
        return new ASN1OctetString(dN.toNormalizedString());
    }

    private ByteString bestEffortNormalize(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "bestEffortNormalize", String.valueOf(string)));
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (i == 0) continue;
                char c2 = string.charAt(i - 1);
                if (c2 == '\\') {
                    stringBuilder.append(' ');
                    continue;
                }
                if (c2 == ',') continue;
                if (i == n - 1) break;
                c2 = string.charAt(i + 1);
                if (c2 == ' ' || c2 == ',') continue;
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(c);
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

